/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AbstractExTreeDataProvider;
import com.alee.extended.tree.ExTreeDataProvider;
import com.alee.extended.tree.ExTreeModel;
import com.alee.extended.tree.sample.SampleExDataProvider;
import com.alee.extended.tree.sample.SampleTreeCellEditor;
import com.alee.extended.tree.sample.SampleTreeCellRenderer;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.laf.tree.WebTreeCellRenderer;
import com.alee.utils.CollectionUtils;
import com.alee.utils.compare.Filter;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebExTree<E extends UniqueNode>
extends WebTree<E> {
    protected Comparator<E> comparator;
    protected Filter<E> filter;

    public WebExTree() {
        this.setDataProvider(new SampleExDataProvider());
        this.setCellRenderer(new SampleTreeCellRenderer());
        this.setCellEditor(new SampleTreeCellEditor());
    }

    public WebExTree(ExTreeDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        this.setCellRenderer(new WebTreeCellRenderer());
        this.setCellEditor(new WebTreeCellEditor());
    }

    public ExTreeDataProvider<E> getDataProvider() {
        TreeModel model = this.getModel();
        return model != null && model instanceof ExTreeModel ? this.getExModel().getDataProvider() : null;
    }

    public void setDataProvider(ExTreeDataProvider dataProvider) {
        if (dataProvider != null) {
            ExTreeDataProvider<E> oldDataProvider = this.getDataProvider();
            this.setModel(new ExTreeModel(this, dataProvider));
            this.firePropertyChange("dataProvider", oldDataProvider, dataProvider);
        }
    }

    public Comparator<E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<E> comparator) {
        Comparator<E> oldComparator = this.comparator;
        this.comparator = comparator;
        ExTreeDataProvider<E> dataProvider = this.getDataProvider();
        if (dataProvider instanceof AbstractExTreeDataProvider) {
            ((AbstractExTreeDataProvider)dataProvider).setChildsComparator(comparator);
            this.updateSortingAndFiltering();
        }
        this.firePropertyChange("comparator", oldComparator, comparator);
    }

    public void clearComparator() {
        this.setComparator(null);
    }

    public Filter<E> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<E> filter) {
        Filter<E> oldFilter = this.filter;
        this.filter = filter;
        ExTreeDataProvider<E> dataProvider = this.getDataProvider();
        if (dataProvider instanceof AbstractExTreeDataProvider) {
            ((AbstractExTreeDataProvider)dataProvider).setChildsFilter(filter);
            this.updateSortingAndFiltering();
        }
        this.firePropertyChange("filter", oldFilter, filter);
    }

    public void clearFilter() {
        this.setFilter(null);
    }

    public void updateSortingAndFiltering() {
        this.getExModel().updateSortingAndFiltering();
    }

    public void updateSortingAndFiltering(E node) {
        this.getExModel().updateSortingAndFiltering(node);
    }

    public ExTreeModel<E> getExModel() {
        return (ExTreeModel)this.getModel();
    }

    public boolean isExModel() {
        TreeModel model = this.getModel();
        return model != null && model instanceof ExTreeModel;
    }

    public void setChildNodes(E parent, List<E> children) {
        this.getExModel().setChildNodes(parent, children);
    }

    public void addChildNode(E parent, E child) {
        this.getExModel().addChildNodes((UniqueNode)parent, Arrays.asList(child));
    }

    public void addChildNodes(E parent, List<E> children) {
        this.getExModel().addChildNodes(parent, children);
    }

    public void insertChildNodes(List<E> children, E parent, int index) {
        this.getExModel().insertNodesInto(children, parent, index);
    }

    public void insertChildNodes(E[] children, E parent, int index) {
        this.getExModel().insertNodesInto((UniqueNode[])children, (UniqueNode)parent, index);
    }

    public void insertChildNode(E child, E parent, int index) {
        this.getExModel().insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
    }

    public boolean removeNode(String nodeId) {
        return this.removeNode(this.findNode(nodeId));
    }

    public boolean removeNode(E node) {
        boolean exists;
        boolean bl = exists = node != null && ((UniqueNode)node).getParent() != null;
        if (exists) {
            this.getExModel().removeNodeFromParent((MutableTreeNode)node);
        }
        return exists;
    }

    public void removeNodes(List<E> nodes) {
        this.getExModel().removeNodesFromParent(nodes);
    }

    public void removeNodes(E[] nodes) {
        this.getExModel().removeNodesFromParent(nodes);
    }

    public E findNode(String nodeId) {
        return this.getExModel().findNode(nodeId);
    }

    public void updateNode(String nodeId) {
        this.updateNode(this.findNode(nodeId));
    }

    public void updateNode(E node) {
        this.getExModel().updateNode(node);
    }

    public void updateNodeStructure(String nodeId) {
        this.updateNodeStructure(this.findNode(nodeId));
    }

    public void updateNodeStructure(E node) {
        this.getExModel().updateNodeStructure(node);
    }

    public void reloadSelectedNodes() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                UniqueNode node = (UniqueNode)this.getNodeForPath(path);
                if (node == null) continue;
                this.performReload(node, path, false);
            }
        }
    }

    public E reloadNodeUnderPoint(Point point) {
        return this.reloadNodeUnderPoint(point.x, point.y);
    }

    public E reloadNodeUnderPoint(int x, int y) {
        return this.reloadPath(this.getPathForLocation(x, y));
    }

    public E reloadRootNode() {
        return (E)this.reloadNode((UniqueNode)this.getRootNode());
    }

    public E reloadNode(String nodeId) {
        return this.reloadNode(this.findNode(nodeId));
    }

    public E reloadNode(E node) {
        return this.reloadNode(node, false);
    }

    public E reloadNode(E node, boolean select) {
        if (node != null) {
            this.performReload(node, this.getPathForNode(node), select);
            return node;
        }
        return null;
    }

    public E reloadPath(TreePath path) {
        return this.reloadPath(path, false);
    }

    public E reloadPath(TreePath path, boolean select) {
        UniqueNode node;
        if (path != null && (node = (UniqueNode)this.getNodeForPath(path)) != null) {
            this.performReload(node, path, select);
            return (E)node;
        }
        return null;
    }

    protected void performReload(E node, TreePath path, boolean select) {
        if (select && !this.isPathSelected(path)) {
            this.setSelectionPath(path);
        }
        if (!this.isExpanded(path)) {
            this.expandPath(path);
        }
        if (node != null) {
            this.getExModel().reload((TreeNode)node);
        }
    }

    @Override
    public void expandNode(String nodeId) {
        this.expandNode(this.findNode(nodeId));
    }

    public void expandPath(List<String> pathNodeIds) {
        this.expandPath(pathNodeIds, true, true);
    }

    public void expandPath(List<String> pathNodeIds, boolean expandLastNode) {
        this.expandPath(pathNodeIds, expandLastNode, true);
    }

    public void expandPath(List<String> pathNodeIds, boolean expandLastNode, boolean selectLastNode) {
        ArrayList<String> ids = CollectionUtils.copy(pathNodeIds);
        for (int initial = 0; initial < ids.size(); ++initial) {
            E initialNode = this.findNode((String)ids.get(initial));
            if (initialNode == null) continue;
            for (int i = 0; i <= initial; ++i) {
                ids.remove(i);
            }
            if (ids.size() > 0) {
                this.expandPathImpl(initialNode, ids, expandLastNode, selectLastNode);
            }
            return;
        }
    }

    protected void expandPathImpl(E currentNode, List<String> leftToExpand, boolean expandLastNode, boolean selectLastNode) {
        if (leftToExpand.size() > 0) {
            this.expandNode(currentNode);
            E nextNode = this.findNode(leftToExpand.get(0));
            leftToExpand.remove(0);
            if (nextNode != null) {
                this.expandPathImpl(nextNode, leftToExpand, expandLastNode, selectLastNode);
            } else {
                this.expandPathEndImpl(currentNode, expandLastNode, selectLastNode);
            }
        } else {
            this.expandPathEndImpl(currentNode, expandLastNode, selectLastNode);
        }
    }

    protected void expandPathEndImpl(E lastFoundNode, boolean expandLastNode, boolean selectLastNode) {
        if (selectLastNode) {
            this.setSelectedNode(lastFoundNode);
        }
        if (expandLastNode) {
            this.expandNode(lastFoundNode);
        }
    }
}

