/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.ExTreeDataProvider;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.collection.DoubleMap;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ExTreeModel<E extends UniqueNode>
extends WebTreeModel<E> {
    protected final WebTree<E> tree;
    protected final ExTreeDataProvider<E> dataProvider;
    protected E rootNode = null;
    protected final Object cacheLock = new Object();
    protected final Map<String, Boolean> nodeCached = new HashMap<String, Boolean>();
    protected final Map<String, List<E>> rawNodeChildsCache = new HashMap<String, List<E>>();
    protected final DoubleMap<String, E> nodeById = new DoubleMap();

    public ExTreeModel(WebTree<E> tree, ExTreeDataProvider<E> dataProvider) {
        super(null);
        this.tree = tree;
        this.dataProvider = dataProvider;
        this.loadTreeData((UniqueNode)this.getRootNode());
    }

    public ExTreeDataProvider<E> getDataProvider() {
        return this.dataProvider;
    }

    public E getRoot() {
        if (this.rootNode == null) {
            this.rootNode = this.dataProvider.getRoot();
            this.cacheNodeById(this.rootNode);
        }
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.dataProvider.isLeaf((UniqueNode)node);
    }

    @Override
    public int getChildCount(Object parent) {
        UniqueNode node = (UniqueNode)parent;
        if (this.isLeaf(node)) {
            return 0;
        }
        if (this.areChildsLoaded(node)) {
            return super.getChildCount(parent);
        }
        return this.loadChildsCount(node);
    }

    public E getChild(Object parent, int index) {
        return (E)((UniqueNode)super.getChild(parent, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areChildsLoaded(E node) {
        Object object = this.cacheLock;
        synchronized (object) {
            Boolean cached = this.nodeCached.get(((UniqueNode)node).getId());
            return cached != null && cached != false;
        }
    }

    protected void loadTreeData(E node) {
        int childCount = this.getChildCount(node);
        for (int i = 0; i < childCount; ++i) {
            this.loadTreeData(this.getChild(node, i));
        }
    }

    @Override
    public void reload(TreeNode node) {
        UniqueNode reloadedNode = (UniqueNode)node;
        this.tree.cancelEditing();
        this.clearNodeChildsCache(reloadedNode, false);
        reloadedNode.removeAllChildren();
        super.reload(reloadedNode);
        this.loadTreeData(reloadedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildsCache(E node, boolean clearNode) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (clearNode) {
                this.nodeById.remove(((UniqueNode)node).getId());
            }
            this.nodeCached.remove(((UniqueNode)node).getId());
            List<E> children = this.rawNodeChildsCache.remove(((UniqueNode)node).getId());
            if (children != null) {
                this.clearNodeChildsCache(children, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildsCache(List<E> nodes, boolean clearNodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (UniqueNode node : nodes) {
                this.clearNodeChildsCache(node, clearNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildsCache(E[] nodes, boolean clearNodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (E node : nodes) {
                this.clearNodeChildsCache(node, clearNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheNodeById(E node) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.nodeById.put(((UniqueNode)node).getId(), node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheNodesById(List<E> nodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (UniqueNode node : nodes) {
                this.nodeById.put(node.getId(), node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadChildsCount(E parent) {
        List<E> childs = this.dataProvider.getChilds(parent);
        Object object = this.cacheLock;
        synchronized (object) {
            this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), childs);
            this.cacheNodesById(childs);
        }
        List<E> realChilds = this.filterAndSort(parent, childs);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
        }
        if (realChilds != null && realChilds.size() > 0) {
            this.insertNodesIntoImpl(realChilds, parent, 0);
        }
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildNodes(E parent, final List<E> childs) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), childs);
            this.cacheNodesById(childs);
        }
        final List<E> realChilds = this.filterAndSort(parent, childs);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
        }
        SwingUtils.invokeLater(new Runnable((UniqueNode)parent){
            final /* synthetic */ UniqueNode val$parent;
            {
                this.val$parent = uniqueNode;
            }

            @Override
            public void run() {
                if (realChilds != null && realChilds.size() > 0) {
                    ExTreeModel.this.clearNodeChildsCache(childs, false);
                    ExTreeModel.this.insertNodesIntoImpl(realChilds, this.val$parent, 0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNodes(E parent, List<E> childs) {
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> cachedChilds = this.rawNodeChildsCache.get(((UniqueNode)parent).getId());
            if (cachedChilds == null) {
                cachedChilds = new ArrayList(childs.size());
                this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), cachedChilds);
            }
            cachedChilds.addAll(childs);
            this.cacheNodesById(childs);
        }
        this.clearNodeChildsCache(childs, false);
        this.insertNodesIntoImpl(childs, parent, ((DefaultMutableTreeNode)parent).getChildCount());
        this.updateSortingAndFiltering(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        if (node == null) {
            return;
        }
        UniqueNode childNode = (UniqueNode)node;
        UniqueNode parentNode = childNode.getParent();
        if (parentNode == null) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> childs = this.rawNodeChildsCache.get(parentNode.getId());
            if (childs != null) {
                childs.remove(childNode);
            }
        }
        this.clearNodeChildsCache(childNode, true);
        childNode.removeAllChildren();
        super.removeNodeFromParent(node);
        this.updateSortingAndFiltering(parentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        UniqueNode childNode = (UniqueNode)newChild;
        UniqueNode parentNode = (UniqueNode)parent;
        Object object = this.cacheLock;
        synchronized (object) {
            List<UniqueNode> childs = this.rawNodeChildsCache.get(parentNode.getId());
            if (childs == null) {
                childs = new ArrayList(1);
                this.rawNodeChildsCache.put(parentNode.getId(), childs);
            }
            childs.add(index, childNode);
            this.cacheNodeById(childNode);
        }
        this.clearNodeChildsCache(childNode, false);
        this.insertNodeIntoImpl(childNode, parentNode, index);
        this.updateSortingAndFiltering(parentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodesInto(List<E> children, E parent, int index) {
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> childs = this.rawNodeChildsCache.get(((UniqueNode)parent).getId());
            if (childs == null) {
                childs = new ArrayList(1);
                this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), childs);
            }
            childs.addAll(index, children);
            this.cacheNodesById(children);
        }
        this.clearNodeChildsCache(children, false);
        this.insertNodesIntoImpl(children, parent, index);
        this.updateSortingAndFiltering(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodesInto(E[] children, E parent, int index) {
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> childs = this.rawNodeChildsCache.get(((UniqueNode)parent).getId());
            if (childs == null) {
                childs = new ArrayList(1);
                this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), childs);
            }
            for (int i = children.length - 1; i >= 0; --i) {
                childs.add(index, children[i]);
            }
            this.cacheNodesById(Arrays.asList(children));
        }
        this.clearNodeChildsCache((E)children, false);
        this.insertNodesIntoImpl((UniqueNode[])children, (UniqueNode)parent, index);
        this.updateSortingAndFiltering(parent);
    }

    protected void insertNodeIntoImpl(E child, E parent, int index) {
        super.insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
    }

    protected void insertNodesIntoImpl(List<E> children, E parent, int index) {
        super.insertNodesInto(children, parent, index);
    }

    protected void insertNodesIntoImpl(E[] children, E parent, int index) {
        super.insertNodesInto(children, parent, index);
    }

    public void updateSortingAndFiltering() {
        this.updateSortingAndFiltering(this.getRoot(), true);
    }

    public void updateSortingAndFiltering(E parentNode) {
        this.updateSortingAndFiltering(parentNode, false);
    }

    public void updateSortingAndFiltering(E parentNode, boolean recursively) {
        if (parentNode != null) {
            this.performSortingAndFiltering(parentNode, recursively);
        }
    }

    protected void performSortingAndFiltering(E parentNode, boolean recursively) {
        TreeState treeState = this.tree.getTreeState();
        if (recursively) {
            this.performSortingAndFilteringRecursivelyImpl(parentNode);
        } else {
            this.performSortingAndFilteringImpl(parentNode);
        }
        this.nodeStructureChanged((TreeNode)parentNode);
        this.tree.setTreeState(treeState);
    }

    protected void performSortingAndFilteringRecursivelyImpl(E parentNode) {
        this.performSortingAndFilteringImpl(parentNode);
        for (int i = 0; i < ((DefaultMutableTreeNode)parentNode).getChildCount(); ++i) {
            this.performSortingAndFilteringRecursivelyImpl((UniqueNode)((DefaultMutableTreeNode)parentNode).getChildAt(i));
        }
    }

    protected void performSortingAndFilteringImpl(E parentNode) {
        List<E> childs = this.rawNodeChildsCache.get(((UniqueNode)parentNode).getId());
        if (childs != null) {
            ((DefaultMutableTreeNode)parentNode).removeAllChildren();
            List<E> realChilds = this.filterAndSort(parentNode, childs);
            for (UniqueNode child : realChilds) {
                ((DefaultMutableTreeNode)parentNode).add(child);
            }
        }
    }

    protected List<E> filterAndSort(E parentNode, List<E> childs) {
        if (childs == null || childs.size() == 0) {
            return new ArrayList(0);
        }
        Filter<E> filter = this.dataProvider.getChildsFilter(parentNode);
        Comparator<E> comparator = this.dataProvider.getChildsComparator(parentNode);
        if (filter != null) {
            ArrayList<E> filtered = CollectionUtils.filter(childs, filter);
            if (comparator != null) {
                Collections.sort(filtered, comparator);
            }
            return filtered;
        }
        if (comparator != null) {
            childs = CollectionUtils.copy(childs);
            Collections.sort(childs, comparator);
        }
        return childs;
    }

    public E findNode(String nodeId) {
        return (E)((UniqueNode)this.nodeById.get(nodeId));
    }

    public DoubleMap<String, E> getNodesCache() {
        return MapUtils.copyDoubleMap(this.nodeById);
    }
}

