/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.slide;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionUtils;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.slide.SlideType;
import com.alee.utils.GraphicsUtils;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;

public class SlideTransitionEffect
extends DefaultTransitionEffect {
    private static final String SLIDE_MINIMUM_SPEED = "SLIDE_MINIMUM_SPEED";
    private static final String SLIDE_SPEED = "SLIDE_SPEED";
    private static final String SLIDE_FADE = "SLIDE_FADE";
    private static final String SLIDE_TYPE = "SLIDE_TYPE";
    private int minimumSpeed;
    private int speed;
    private boolean fade;
    private SlideType type;
    private Direction direction;
    private int slideProgress;

    public int getMinimumSpeed() {
        return this.get(SLIDE_MINIMUM_SPEED, 1);
    }

    public void setMinimumSpeed(int speed) {
        this.put(SLIDE_MINIMUM_SPEED, speed);
    }

    public int getSpeed() {
        return this.get(SLIDE_SPEED, 20);
    }

    public void setSpeed(int speed) {
        this.put(SLIDE_SPEED, speed);
    }

    public boolean isFade() {
        return this.get(SLIDE_FADE, true);
    }

    public void setFade(boolean transparent) {
        this.put(SLIDE_FADE, transparent);
    }

    public SlideType getType() {
        return this.get(SLIDE_TYPE, SlideType.random);
    }

    public void setType(SlideType type) {
        this.put(SLIDE_TYPE, (Object)type);
    }

    @Override
    public void prepareAnimation(ImageTransition imageTransition) {
        this.minimumSpeed = this.getMinimumSpeed();
        this.speed = this.getSpeed();
        this.fade = this.isFade();
        this.type = TransitionUtils.getActualValue(this.getType());
        this.direction = TransitionUtils.getActualValue(this.getDirection());
        this.slideProgress = 0;
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        int maxProgress = this.direction.equals((Object)Direction.left) || this.direction.equals((Object)Direction.right) ? imageTransition.getWidth() : imageTransition.getHeight();
        int resultSpeed = Math.max(this.minimumSpeed, Math.round((float)this.speed * (float)Math.sqrt((float)Math.abs(this.type.equals((Object)SlideType.moveOld) ? this.slideProgress : maxProgress - this.slideProgress) / (float)maxProgress)));
        this.slideProgress = Math.min(this.slideProgress + resultSpeed, maxProgress);
        if (this.slideProgress < maxProgress) {
            imageTransition.repaint();
            return false;
        }
        this.type = null;
        return true;
    }

    @Override
    public void paint(Graphics2D g2d, ImageTransition transition) {
        int width = transition.getWidth();
        int height = transition.getHeight();
        float floatProgress = (float)this.slideProgress / (float)(this.direction.isHorizontal() ? width : height);
        if (this.type.equals((Object)SlideType.moveNew)) {
            Point np = new Point(0, 0);
            if (this.direction.equals((Object)Direction.left)) {
                np.x = width - this.slideProgress;
            } else if (this.direction.equals((Object)Direction.right)) {
                np.x = -width + this.slideProgress;
            } else if (this.direction.equals((Object)Direction.up)) {
                np.y = height - this.slideProgress;
            } else if (this.direction.equals((Object)Direction.down)) {
                np.y = -height + this.slideProgress;
            }
            g2d.drawImage(transition.getCurrentImage(), 0, 0, width, height, null);
            Composite old = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(floatProgress), this.fade);
            g2d.drawImage(transition.getOtherImage(), np.x, np.y, width, height, null);
            GraphicsUtils.restoreComposite(g2d, old, this.fade);
        } else if (this.type.equals((Object)SlideType.moveOld)) {
            Point cp = new Point(0, 0);
            if (this.direction.equals((Object)Direction.left)) {
                cp.x = -this.slideProgress;
            } else if (this.direction.equals((Object)Direction.right)) {
                cp.x = this.slideProgress;
            } else if (this.direction.equals((Object)Direction.up)) {
                cp.y = -this.slideProgress;
            } else if (this.direction.equals((Object)Direction.down)) {
                cp.y = this.slideProgress;
            }
            g2d.drawImage(transition.getOtherImage(), 0, 0, width, height, null);
            Composite old = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(1.0f - floatProgress), this.fade);
            g2d.drawImage(transition.getCurrentImage(), cp.x, cp.y, width, height, null);
            GraphicsUtils.restoreComposite(g2d, old, this.fade);
        } else if (this.type.equals((Object)SlideType.moveBoth)) {
            Point cp = new Point(0, 0);
            Point np = new Point(0, 0);
            if (this.direction.equals((Object)Direction.left)) {
                cp.x = -this.slideProgress;
                np.x = width - this.slideProgress;
            } else if (this.direction.equals((Object)Direction.right)) {
                cp.x = this.slideProgress;
                np.x = -width + this.slideProgress;
            } else if (this.direction.equals((Object)Direction.up)) {
                cp.y = -this.slideProgress;
                np.y = height - this.slideProgress;
            } else if (this.direction.equals((Object)Direction.down)) {
                cp.y = this.slideProgress;
                np.y = -height + this.slideProgress;
            }
            g2d.drawImage(transition.getCurrentImage(), cp.x, cp.y, width, height, null);
            g2d.drawImage(transition.getOtherImage(), np.x, np.y, width, height, null);
        }
    }
}

