/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition;

import com.alee.extended.transition.TransitionListener;
import com.alee.extended.transition.effects.TransitionEffect;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ImageTransition
extends JComponent
implements ActionListener {
    protected List<TransitionListener> transitionListeners = new ArrayList<TransitionListener>(1);
    protected BufferedImage currentImage = null;
    protected BufferedImage otherImage = null;
    protected List<TransitionEffect> transitionEffects = new ArrayList<TransitionEffect>();
    protected WebTimer animator = null;
    protected boolean animating = false;
    protected boolean blocked = false;
    protected TransitionEffect actualTransitionEffect = null;

    public ImageTransition() {
        this(null, null);
    }

    public ImageTransition(BufferedImage currentImage) {
        this(currentImage, null);
    }

    public ImageTransition(BufferedImage currentImage, BufferedImage otherImage) {
        this.currentImage = currentImage;
        this.otherImage = otherImage;
        SwingUtils.setOrientation(this);
        this.setOpaque(false);
    }

    public boolean isAnimating() {
        return this.animator != null && this.animator.isRunning() && this.animating;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public BufferedImage getCurrentImage() {
        return this.currentImage;
    }

    public void setCurrentImage(BufferedImage currentImage) {
        this.currentImage = currentImage;
    }

    public BufferedImage getOtherImage() {
        return this.otherImage;
    }

    public void setOtherImage(BufferedImage otherImage) {
        this.otherImage = otherImage;
    }

    public List<TransitionEffect> getTransitionEffects() {
        return this.transitionEffects;
    }

    public TransitionEffect getTransitionEffect() {
        return this.transitionEffects != null && this.transitionEffects.size() > 0 ? this.transitionEffects.get(0) : null;
    }

    public void addTransitionEffect(TransitionEffect transitionEffect) {
        if (this.transitionEffects == null) {
            this.transitionEffects = new ArrayList<TransitionEffect>();
        }
        this.transitionEffects.add(transitionEffect);
    }

    public void clearTransitionEffects() {
        if (this.transitionEffects != null) {
            this.transitionEffects.clear();
            this.transitionEffects = null;
        }
    }

    public void removeTransitionEffect(TransitionEffect transitionEffect) {
        if (this.transitionEffects != null) {
            this.transitionEffects.remove(transitionEffect);
        }
    }

    public void setTransitionEffect(TransitionEffect transitionEffect) {
        this.transitionEffects = transitionEffect != null ? CollectionUtils.copy(transitionEffect) : null;
    }

    public void setTransitionEffects(List<TransitionEffect> transitionEffects) {
        this.transitionEffects = transitionEffects;
    }

    public void setTransitionEffects(TransitionEffect ... transitionEffects) {
        this.transitionEffects = transitionEffects != null ? CollectionUtils.copy(transitionEffects) : null;
    }

    public void destroy() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
            this.animator = null;
        }
        if (this.transitionListeners.size() > 0) {
            this.transitionListeners.clear();
        }
        if (this.currentImage != null) {
            this.currentImage.flush();
            this.currentImage = null;
        }
        if (this.otherImage != null) {
            this.otherImage.flush();
            this.otherImage = null;
        }
    }

    public void changeImage(BufferedImage otherImage) {
        if (!this.isAnimating()) {
            this.setOtherImage(otherImage);
            this.performTransition();
        }
    }

    public void performTransition() {
        if (this.isAnimating() || this.isBlocked()) {
            return;
        }
        if (this.transitionEffects == null || this.transitionEffects.size() <= 0) {
            this.actualTransitionEffect = null;
        } else if (this.transitionEffects.size() == 1) {
            this.actualTransitionEffect = this.transitionEffects.get(0);
        } else if (this.transitionEffects.size() > 1) {
            this.actualTransitionEffect = this.transitionEffects.get(MathUtils.random(this.transitionEffects.size()));
        }
        long animationDelay = this.actualTransitionEffect != null ? this.actualTransitionEffect.getAnimationDelay() : 0L;
        this.animator = new WebTimer("ImageTransition.animator", animationDelay, (ActionListener)this);
        this.fireTransitionStarted();
        this.animator.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.actualTransitionEffect == null || this.actualTransitionEffect.performAnimationTick(this)) {
            this.animator.stop();
            this.finishTransition();
        }
    }

    public void cancelTransition() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }

    protected void finishTransition() {
        BufferedImage oldCurrent = this.currentImage;
        this.currentImage = this.otherImage;
        this.otherImage = oldCurrent;
        this.actualTransitionEffect = null;
        this.repaint();
        this.fireTransitionFinished();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.actualTransitionEffect != null && this.actualTransitionEffect.isAnimating() && this.currentImage != null && this.otherImage != null) {
            this.actualTransitionEffect.paint(g2d, this);
        } else if (this.currentImage != null) {
            g2d.drawImage(this.currentImage, 0, 0, this.getWidth(), this.getHeight(), null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.currentImage != null) {
            return new Dimension(this.currentImage.getWidth(), this.currentImage.getHeight());
        }
        if (this.otherImage != null) {
            return new Dimension(this.otherImage.getWidth(), this.otherImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public void addTransitionListener(TransitionListener listener) {
        this.transitionListeners.add(listener);
    }

    public void removeTransitionListener(TransitionListener listener) {
        this.transitionListeners.remove(listener);
    }

    public void fireTransitionStarted() {
        for (TransitionListener listener : CollectionUtils.copy(this.transitionListeners)) {
            listener.transitionStarted();
        }
    }

    public void fireTransitionFinished() {
        for (TransitionListener listener : CollectionUtils.copy(this.transitionListeners)) {
            listener.transitionFinished();
        }
    }
}

