/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DefaultTabTitleComponentProvider;
import com.alee.extended.tab.DocumentAdapter;
import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentDataCancellableRunnable;
import com.alee.extended.tab.DocumentDataProvider;
import com.alee.extended.tab.DocumentDataRunnable;
import com.alee.extended.tab.DocumentDragViewHandler;
import com.alee.extended.tab.DocumentListener;
import com.alee.extended.tab.DocumentPaneEventMethods;
import com.alee.extended.tab.DocumentPaneListener;
import com.alee.extended.tab.DocumentPaneState;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.SplitData;
import com.alee.extended.tab.StructureData;
import com.alee.extended.tab.TabTitleComponentProvider;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.managers.drag.DragManager;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.utils.CollectionUtils;
import com.alee.utils.EventUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.Customizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.AncestorEvent;

public class WebDocumentPane<T extends DocumentData>
extends WebPanel
implements DocumentPaneEventMethods<T>,
SettingsMethods,
SwingConstants {
    public static final ImageIcon closeTabIcon = new ImageIcon(PaneData.class.getResource("icons/close.png"));
    public static final ImageIcon closeTabRolloverIcon = new ImageIcon(PaneData.class.getResource("icons/close-rollover.png"));
    protected static final String DATA_KEY = "document.pane.data";
    protected List<DocumentListener<T>> documentListeners = new ArrayList<DocumentListener<T>>(1);
    protected List<DocumentPaneListener<T>> documentPaneListeners = new ArrayList<DocumentPaneListener<T>>(1);
    protected final String id;
    protected StructureData root;
    protected PaneData<T> activePane;
    protected Customizer<WebTabbedPane> tabbedPaneCustomizer;
    protected TabTitleComponentProvider<T> tabTitleComponentProvider;
    protected Customizer<WebSplitPane> splitPaneCustomizer;
    protected boolean closeable = true;
    protected boolean dragEnabled = true;
    protected boolean dragBetweenPanesEnabled = false;
    protected boolean splitEnabled = true;
    protected boolean tabMenuEnabled = true;
    protected WeakReference<T> previouslySelected = new WeakReference<Object>(null);
    protected DocumentDataProvider<T> documentsProvider = null;

    public WebDocumentPane() {
        this((Customizer<WebSplitPane>)null, (Customizer<WebTabbedPane>)null, (TabTitleComponentProvider<T>)null);
    }

    public WebDocumentPane(Customizer<WebTabbedPane> tabbedPaneCustomizer) {
        this(null, tabbedPaneCustomizer, null);
    }

    public WebDocumentPane(TabTitleComponentProvider<T> tabTitleComponentProvider) {
        this(null, null, tabTitleComponentProvider);
    }

    public WebDocumentPane(Customizer<WebTabbedPane> tabbedPaneCustomizer, TabTitleComponentProvider<T> tabTitleComponentProvider) {
        this(null, tabbedPaneCustomizer, tabTitleComponentProvider);
    }

    public WebDocumentPane(Customizer<WebSplitPane> splitPaneCustomizer, Customizer<WebTabbedPane> tabbedPaneCustomizer) {
        this(splitPaneCustomizer, tabbedPaneCustomizer, null);
    }

    public WebDocumentPane(Customizer<WebSplitPane> splitPaneCustomizer, Customizer<WebTabbedPane> tabbedPaneCustomizer, TabTitleComponentProvider<T> tabTitleComponentProvider) {
        super("document-pane");
        this.tabbedPaneCustomizer = tabbedPaneCustomizer;
        this.splitPaneCustomizer = splitPaneCustomizer;
        this.tabTitleComponentProvider = tabTitleComponentProvider != null ? tabTitleComponentProvider : this.createDefaultTabTitleComponentProvider();
        this.id = TextUtils.generateId("WDP");
        this.init();
        final DocumentDragViewHandler dragViewHandler = new DocumentDragViewHandler(this);
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                DragManager.registerViewHandler(dragViewHandler);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                DragManager.unregisterViewHandler(dragViewHandler);
            }
        });
    }

    protected TabTitleComponentProvider<T> createDefaultTabTitleComponentProvider() {
        return new DefaultTabTitleComponentProvider();
    }

    public String getId() {
        return this.id;
    }

    public Customizer<WebTabbedPane> getTabbedPaneCustomizer() {
        return this.tabbedPaneCustomizer;
    }

    public void setTabbedPaneCustomizer(Customizer<WebTabbedPane> customizer) {
        this.tabbedPaneCustomizer = customizer;
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.updateTabbedPaneCustomizer(this);
        }
    }

    public TabTitleComponentProvider<T> getTabTitleComponentProvider() {
        return this.tabTitleComponentProvider;
    }

    public void setTabTitleComponentProvider(TabTitleComponentProvider<T> provider) {
        this.tabTitleComponentProvider = provider != null ? provider : this.createDefaultTabTitleComponentProvider();
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.updateTabTitleComponents();
        }
    }

    public Customizer<WebSplitPane> getSplitPaneCustomizer() {
        return this.splitPaneCustomizer;
    }

    public void setSplitPaneCustomizer(Customizer<WebSplitPane> customizer) {
        this.splitPaneCustomizer = customizer;
        for (SplitData<T> paneData : this.getAllSplitPanes()) {
            paneData.updateSplitPaneCustomizer(this);
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public boolean isDragBetweenPanesEnabled() {
        return this.dragBetweenPanesEnabled;
    }

    public void setDragBetweenPanesEnabled(boolean dragBetweenPanesEnabled) {
        this.dragBetweenPanesEnabled = dragBetweenPanesEnabled;
    }

    public boolean isSplitEnabled() {
        return this.splitEnabled;
    }

    public void setSplitEnabled(boolean splitEnabled) {
        this.splitEnabled = splitEnabled;
    }

    public boolean isTabMenuEnabled() {
        return this.tabMenuEnabled;
    }

    public void setTabMenuEnabled(boolean tabMenuEnabled) {
        this.tabMenuEnabled = tabMenuEnabled;
    }

    public StructureData getStructureRoot() {
        return this.root;
    }

    public void setStructureRoot(StructureData root) {
        if (this.root != null) {
            this.remove(this.root.getComponent());
        }
        if (root != null) {
            this.add(root.getComponent(), (Object)"Center");
            this.root = root;
            this.activePane = root.findClosestPane();
            this.revalidate();
            this.repaint();
        } else {
            this.init();
        }
    }

    protected void init() {
        PaneData rootPane = new PaneData(this);
        this.add((Component)rootPane.getTabbedPane(), (Object)"Center");
        this.root = rootPane;
        this.activePane = rootPane;
    }

    public void split(T movedDocument, int direction) {
        PaneData<T> pane = this.getPane(movedDocument);
        if (pane != null) {
            this.split(pane, movedDocument, direction);
        }
    }

    protected PaneData<T> split(PaneData<T> splittedPane, T movedDocument, int direction) {
        PaneData otherPane;
        if (splittedPane != null) {
            SplitData<T> splitData;
            int orientation;
            boolean ltr = direction == 4 || direction == 3;
            int n = orientation = direction == 2 || direction == 4 ? 1 : 0;
            if (splittedPane.getTabbedPane().getParent() == this) {
                otherPane = new PaneData(this);
                Dimension size = splittedPane.getTabbedPane().getSize();
                PaneData first = ltr ? splittedPane : otherPane;
                PaneData last = ltr ? otherPane : splittedPane;
                splitData = new SplitData(this, orientation, first, last);
                this.remove((Component)splittedPane.getTabbedPane());
                this.add((Component)splitData.getSplitPane(), (Object)"Center");
                splitData.getSplitPane().setDividerLocation(orientation == 1 ? size.width / 2 : size.height / 2);
                this.root = splitData;
            } else {
                WebSplitPane parentSplit = (WebSplitPane)splittedPane.getTabbedPane().getParent();
                SplitData<T> parentSplitData = WebDocumentPane.getData(parentSplit);
                if (parentSplitData.getOrientation() == orientation && ltr && parentSplitData.getFirst() == splittedPane && parentSplitData.getLast() instanceof PaneData) {
                    splitData = parentSplitData;
                    otherPane = (PaneData)parentSplitData.getLast();
                } else if (parentSplitData.getOrientation() == orientation && !ltr && parentSplitData.getLast() == splittedPane && parentSplitData.getFirst() instanceof PaneData) {
                    splitData = parentSplitData;
                    otherPane = (PaneData)parentSplitData.getFirst();
                } else {
                    otherPane = new PaneData(this);
                    int parentSplitLocation = parentSplitData.getSplitPane().getDividerLocation();
                    Dimension size = splittedPane.getTabbedPane().getSize();
                    PaneData first = ltr ? splittedPane : otherPane;
                    PaneData last = ltr ? otherPane : splittedPane;
                    splitData = new SplitData(this, orientation, first, last);
                    parentSplitData.replace(splittedPane, splitData);
                    splitData.getSplitPane().setDividerLocation(orientation == 1 ? size.width / 2 : size.height / 2);
                    parentSplitData.getSplitPane().setDividerLocation(parentSplitLocation);
                }
            }
            if (movedDocument != null) {
                splittedPane.remove(movedDocument);
                otherPane.add(movedDocument);
            }
            this.revalidate();
            this.repaint();
            otherPane.getTabbedPane().requestFocusInWindow();
            otherPane.activate();
            this.fireSplitted(splittedPane, splitData);
        } else {
            otherPane = null;
        }
        return otherPane;
    }

    public void merge(StructureData toMerge) {
        if (toMerge instanceof PaneData) {
            PaneData mergedPane = (PaneData)toMerge;
            Container parent = mergedPane.getTabbedPane().getParent();
            if (parent instanceof WebSplitPane) {
                WebSplitPane splitPane = (WebSplitPane)parent;
                this.mergeImpl(WebDocumentPane.getData(splitPane));
                this.revalidate();
                this.repaint();
            }
        } else {
            this.mergeImpl((SplitData)toMerge);
            this.revalidate();
            this.repaint();
        }
        this.checkSelection();
    }

    protected void mergeImpl(SplitData<T> splitData) {
        WebSplitPane splitPane;
        StructureData result;
        StructureData first = splitData.getFirst();
        StructureData last = splitData.getLast();
        if (WebDocumentPane.isEmptyPane(first) || WebDocumentPane.isEmptyPane(last)) {
            result = WebDocumentPane.isEmptyPane(first) ? last : first;
        } else {
            if (first instanceof SplitData) {
                this.mergeImpl((SplitData)first);
                first = splitData.getFirst();
            }
            if (last instanceof SplitData) {
                this.mergeImpl((SplitData)last);
                last = splitData.getLast();
            }
            PaneData firstPane = (PaneData)first;
            PaneData lastPane = (PaneData)last;
            PaneData toPane = firstPane.count() > lastPane.count() ? firstPane : lastPane;
            PaneData fromPane = firstPane.count() > lastPane.count() ? lastPane : firstPane;
            for (DocumentData document : CollectionUtils.copy(fromPane.getData())) {
                fromPane.remove(document);
                toPane.add(document);
            }
            result = toPane;
        }
        if (this.activePane == first || this.activePane == last) {
            this.activePane = result.findClosestPane();
        }
        if ((splitPane = splitData.getSplitPane()).getParent() == this) {
            this.remove((Component)splitPane);
            this.add(result.getComponent(), (Object)"Center");
            this.root = result;
        } else {
            WebSplitPane parentSplit = (WebSplitPane)splitPane.getParent();
            SplitData<T> parentSplitData = WebDocumentPane.getData(parentSplit);
            int dividerLocation = parentSplit.getDividerLocation();
            if (parentSplit.getLeftComponent() == splitPane) {
                parentSplitData.setFirst(result);
            } else {
                parentSplitData.setLast(result);
            }
            parentSplit.setDividerLocation(dividerLocation);
        }
        this.fireMerged(splitData, result);
    }

    public PaneData<T> getActivePane() {
        return this.activePane;
    }

    protected void activate(PaneData<T> paneData) {
        if (paneData != null && paneData != this.activePane) {
            this.activePane = paneData;
            this.checkSelection();
        }
    }

    protected void activate(T document) {
        this.activate((T)this.getPane(document));
        this.setSelected((DocumentData)document);
    }

    public T getSelectedDocument() {
        return this.activePane != null ? (T)this.activePane.getSelected() : null;
    }

    public T getDocument(int index) {
        return this.activePane != null ? (T)this.activePane.get(index) : null;
    }

    public T getDocument(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            T document = paneData.get(id);
            if (document == null) continue;
            return document;
        }
        return null;
    }

    public List<T> getDocuments() {
        ArrayList<T> documents = new ArrayList<T>();
        for (PaneData<T> paneData : this.getAllPanes()) {
            documents.addAll(paneData.getData());
        }
        return documents;
    }

    public int getDocumentsCount() {
        int count = 0;
        for (PaneData<T> paneData : this.getAllPanes()) {
            count += paneData.count();
        }
        return count;
    }

    public List<PaneData<T>> getAllPanes() {
        ArrayList<PaneData<T>> panes = new ArrayList<PaneData<T>>();
        this.collectPanes(this.root, panes);
        return panes;
    }

    protected void collectPanes(StructureData structureData, List<PaneData<T>> panes) {
        if (structureData instanceof PaneData) {
            panes.add((PaneData)structureData);
        } else {
            SplitData splitData = (SplitData)structureData;
            this.collectPanes(splitData.getFirst(), panes);
            this.collectPanes(splitData.getLast(), panes);
        }
    }

    public List<SplitData<T>> getAllSplitPanes() {
        ArrayList<SplitData<T>> panes = new ArrayList<SplitData<T>>();
        this.collectSplitPanes(this.root, panes);
        return panes;
    }

    protected void collectSplitPanes(StructureData structureData, List<SplitData<T>> splits) {
        if (structureData instanceof SplitData) {
            SplitData splitData = (SplitData)structureData;
            splits.add(splitData);
            this.collectSplitPanes(splitData.getFirst(), splits);
            this.collectSplitPanes(splitData.getLast(), splits);
        }
    }

    public PaneData<T> getPane(T document) {
        return this.getPane(((DocumentData)document).getId());
    }

    public PaneData<T> getPane(String documentId) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (!paneData.contains(documentId)) continue;
            return paneData;
        }
        return null;
    }

    public void setSelected(int index) {
        if (this.activePane != null) {
            this.activePane.setSelected(index);
        }
    }

    public void selectPrevious() {
        if (this.activePane != null) {
            this.activePane.selectPrevious();
        }
    }

    public void selectNext() {
        if (this.activePane != null) {
            this.activePane.selectNext();
        }
    }

    public void setSelected(DocumentData document) {
        this.setSelected(document.getId());
    }

    public void setSelected(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            T document = paneData.get(id);
            if (document == null) continue;
            paneData.setSelected(document);
            paneData.activate();
        }
    }

    public boolean isDocumentOpened(T document) {
        return this.isDocumentOpened(((DocumentData)document).getId());
    }

    public boolean isDocumentOpened(String documentId) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (!paneData.contains(documentId)) continue;
            return true;
        }
        return false;
    }

    public void openDocument(String documentId) {
        if (this.documentsProvider != null) {
            this.openDocument(this.documentsProvider.provide(documentId));
        }
    }

    public void openDocument(T document) {
        if (document != null) {
            if (this.isDocumentOpened(document)) {
                this.setSelected((DocumentData)document);
            } else if (this.activePane != null) {
                this.activePane.open(document);
                this.activePane.setSelected(document);
            }
        }
    }

    public void closeDocument(int index) {
        if (this.activePane != null) {
            this.activePane.close(index);
        }
    }

    public void closeDocument(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.close(id);
        }
    }

    public void closeDocument(T document) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (paneData.close(document)) break;
        }
    }

    public void closeAll() {
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.closeAll();
        }
    }

    protected void checkSelection() {
        T selected = this.getSelectedDocument();
        if (selected != null && this.previouslySelected.get() != selected) {
            this.previouslySelected = new WeakReference<T>(selected);
            PaneData<T> pane = this.getPane(selected);
            this.fireDocumentSelected(selected, pane, pane.indexOf(selected));
        }
    }

    public DocumentDataProvider<T> getDocumentsProvider() {
        return this.documentsProvider;
    }

    public void setDocumentsProvider(DocumentDataProvider<T> provider) {
        this.documentsProvider = provider;
    }

    public DocumentPaneState getDocumentPaneState() {
        return this.getDocumentPaneStateImpl(this.root);
    }

    protected DocumentPaneState getDocumentPaneStateImpl(StructureData structure) {
        if (structure != null) {
            if (structure instanceof PaneData) {
                PaneData paneData = (PaneData)structure;
                Object selected = paneData.getSelected();
                return new DocumentPaneState(selected != null ? ((DocumentData)selected).getId() : null, paneData.getDocumentIds());
            }
            SplitData splitData = (SplitData)structure;
            DocumentPaneState first = this.getDocumentPaneStateImpl(splitData.getFirst());
            DocumentPaneState last = this.getDocumentPaneStateImpl(splitData.getLast());
            Pair<DocumentPaneState, DocumentPaneState> splitState = new Pair<DocumentPaneState, DocumentPaneState>(first, last);
            return new DocumentPaneState(splitData.getOrientation(), splitData.getDividerLocation(), splitState);
        }
        return null;
    }

    public void setDocumentPaneState(DocumentPaneState state) {
        List<T> openedDocuments = this.getDocuments();
        HashMap<String, DocumentData> documents = new HashMap<String, DocumentData>(openedDocuments.size());
        for (DocumentData document : openedDocuments) {
            documents.put(document.getId(), document);
        }
        this.closeAll();
        this.setStructureRoot(this.restoreStructureStateImpl(state, documents));
    }

    protected StructureData<T> restoreStructureStateImpl(final DocumentPaneState state, Map<String, T> documents) {
        StructureData<DocumentData<Object>> restored;
        if (state.isSplit().booleanValue()) {
            Pair<DocumentPaneState, DocumentPaneState> splitState = state.getSplitState();
            StructureData<T> first = this.restoreStructureStateImpl(splitState.getKey(), documents);
            StructureData<T> last = this.restoreStructureStateImpl(splitState.getValue(), documents);
            final SplitData splitData = new SplitData(this, state.getSplitOrientation(), first, last);
            splitData.getSplitPane().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    WebSplitPane splitPane = splitData.getSplitPane();
                    if (splitPane.getWidth() > 0 || splitPane.getHeight() > 0) {
                        splitData.setDividerLocation(state.getDividerLocation());
                        splitPane.removeComponentListener(this);
                    }
                }
            });
            restored = splitData;
        } else {
            String selectedId;
            PaneData<DocumentData> paneData = new PaneData<DocumentData>(this);
            if (state.getDocumentIds() != null) {
                for (String id : state.getDocumentIds()) {
                    DocumentData document;
                    if (this.documentsProvider != null && !documents.containsKey(id)) {
                        documents.put(id, this.documentsProvider.provide(id));
                    }
                    if (!documents.containsKey(id) || (document = (DocumentData)documents.get(id)) == null) continue;
                    paneData.open(document);
                }
            }
            if ((selectedId = state.getSelectedId()) != null && documents.containsKey(selectedId)) {
                paneData.setSelected((DocumentData)documents.get(selectedId));
            }
            restored = paneData;
        }
        return restored;
    }

    public void addDocumentPaneListener(DocumentPaneListener<T> listener) {
        this.documentPaneListeners.add(listener);
    }

    public void removeDocumentPaneListener(DocumentPaneListener<T> listener) {
        this.documentPaneListeners.remove(listener);
    }

    public void fireSplitted(PaneData<T> splittedPane, SplitData<T> newSplitData) {
        for (DocumentPaneListener<T> listener : CollectionUtils.copy(this.documentPaneListeners)) {
            listener.splitted(this, splittedPane, newSplitData);
        }
    }

    public void fireMerged(SplitData<T> mergedSplit, StructureData<T> newStructureData) {
        for (DocumentPaneListener<T> listener : CollectionUtils.copy(this.documentPaneListeners)) {
            listener.merged(this, mergedSplit, newStructureData);
        }
    }

    public void fireOrientationChanged(SplitData<T> splitData) {
        for (DocumentPaneListener<T> listener : CollectionUtils.copy(this.documentPaneListeners)) {
            listener.orientationChanged(this, splitData);
        }
    }

    public void fireSidesSwapped(SplitData<T> splitData) {
        for (DocumentPaneListener<T> listener : CollectionUtils.copy(this.documentPaneListeners)) {
            listener.sidesSwapped(this, splitData);
        }
    }

    public void fireDividerLocationChanged(SplitData<T> splitData) {
        for (DocumentPaneListener<T> listener : CollectionUtils.copy(this.documentPaneListeners)) {
            listener.dividerLocationChanged(this, splitData);
        }
    }

    public void addDocumentListener(DocumentListener<T> listener) {
        this.documentListeners.add(listener);
    }

    public void removeDocumentListener(DocumentListener<T> listener) {
        this.documentListeners.remove(listener);
    }

    public void fireDocumentOpened(T document, PaneData<T> pane, int index) {
        for (DocumentListener<T> listener : CollectionUtils.copy(this.documentListeners)) {
            listener.opened(document, pane, index);
        }
    }

    public void fireDocumentSelected(T document, PaneData<T> pane, int index) {
        for (DocumentListener<T> listener : CollectionUtils.copy(this.documentListeners)) {
            listener.selected(document, pane, index);
        }
    }

    public boolean fireDocumentClosing(T document, PaneData<T> pane, int index) {
        boolean allow = true;
        for (DocumentListener<T> listener : CollectionUtils.copy(this.documentListeners)) {
            allow = allow && listener.closing(document, pane, index);
        }
        return allow;
    }

    public void fireDocumentClosed(T document, PaneData<T> pane, int index) {
        for (DocumentListener<T> listener : CollectionUtils.copy(this.documentListeners)) {
            listener.closed(document, pane, index);
        }
    }

    @Override
    public DocumentAdapter<T> onDocumentOpen(DocumentDataRunnable<T> runnable) {
        return EventUtils.onDocumentOpen(this, runnable);
    }

    @Override
    public DocumentAdapter<T> onDocumentSelection(DocumentDataRunnable<T> runnable) {
        return EventUtils.onDocumentSelection(this, runnable);
    }

    @Override
    public DocumentAdapter<T> onDocumentClosing(DocumentDataCancellableRunnable<T> runnable) {
        return EventUtils.onDocumentClosing(this, runnable);
    }

    @Override
    public DocumentAdapter<T> onDocumentClose(DocumentDataRunnable<T> runnable) {
        return EventUtils.onDocumentClose(this, runnable);
    }

    @Override
    public void registerSettings(String key) {
        SettingsManager.registerComponent((JComponent)this, key);
    }

    public <V extends DefaultValue> void registerSettings(String key, Class<V> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, key, defaultValueClass);
    }

    @Override
    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, key, defaultValue);
    }

    @Override
    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((JComponent)this, group, key);
    }

    public <V extends DefaultValue> void registerSettings(String group, String key, Class<V> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, group, key, defaultValueClass);
    }

    @Override
    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, group, key, defaultValue);
    }

    @Override
    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, key, loadInitialSettings, applySettingsChanges);
    }

    public <V extends DefaultValue> void registerSettings(String key, Class<V> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, key, defaultValueClass, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, key, defaultValue, loadInitialSettings, applySettingsChanges);
    }

    public <V extends DefaultValue> void registerSettings(String group, String key, Class<V> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, group, key, defaultValueClass, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, group, key, defaultValue, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((JComponent)this, settingsProcessor);
    }

    @Override
    public void unregisterSettings() {
        SettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        SettingsManager.loadComponentSettings(this);
    }

    @Override
    public void saveSettings() {
        SettingsManager.saveComponentSettings(this);
    }

    public static <T extends DocumentData> PaneData<T> getData(WebTabbedPane tabbedPane) {
        return (PaneData)tabbedPane.getClientProperty(DATA_KEY);
    }

    public static <T extends DocumentData> SplitData<T> getData(WebSplitPane splitPane) {
        return (SplitData)splitPane.getClientProperty(DATA_KEY);
    }

    public static boolean isEmptyPane(StructureData data) {
        return data instanceof PaneData && ((PaneData)data).count() == 0;
    }
}

