/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.AbstractPainter;
import com.alee.extended.painter.ComponentState;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class NinePatchStatePainter<E extends JComponent>
extends AbstractPainter<E> {
    protected Map<String, NinePatchIcon> stateIcons;

    public NinePatchStatePainter() {
        this.stateIcons = new HashMap<String, NinePatchIcon>();
    }

    public NinePatchStatePainter(Map<String, NinePatchIcon> stateIcons) {
        this.stateIcons = stateIcons;
    }

    public Map<String, NinePatchIcon> getStateIcons() {
        return this.stateIcons;
    }

    public void setStateIcons(Map<String, NinePatchIcon> stateIcons) {
        this.stateIcons = stateIcons;
        this.updateAll();
    }

    public void addStateIcon(String state, NinePatchIcon ninePatchIcon) {
        this.stateIcons.put(state, ninePatchIcon);
        this.updateAll();
    }

    public void removeStateIcon(String state) {
        this.stateIcons.remove(state);
        this.updateAll();
    }

    public boolean hasStateIcons() {
        return this.stateIcons != null && this.stateIcons.size() > 0;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        if (this.hasStateIcons() && c != null) {
            NinePatchIcon focusIcon;
            NinePatchIcon stateIcon = c instanceof AbstractButton ? this.getButtonBackground((AbstractButton)c) : (c instanceof JToolBar ? this.getToolBarBackground((JToolBar)c) : this.getComponentBackground(c));
            if (stateIcon != null) {
                stateIcon.setComponent((Component)c);
                stateIcon.paintIcon(g2d, bounds);
            }
            if (this.isFocused(c) && (focusIcon = this.getExactStateIcon(ComponentState.focused)) != null) {
                focusIcon.setComponent((Component)c);
                focusIcon.paintIcon(g2d, bounds);
            }
        }
    }

    protected boolean isFocused(E component) {
        return ((Component)component).isFocusOwner();
    }

    protected NinePatchIcon getComponentBackground(E component) {
        return this.getStateIcon(((Component)component).isEnabled() ? ComponentState.normal : ComponentState.disabled);
    }

    protected NinePatchIcon getButtonBackground(AbstractButton button) {
        ButtonModel bm = button.getModel();
        if (bm.isPressed()) {
            return this.getStateIcon(bm.isSelected() ? ComponentState.selectedPressed : ComponentState.pressed);
        }
        if (bm.isSelected()) {
            if (bm.isEnabled()) {
                return this.getStateIcon(bm.isRollover() ? ComponentState.selectedRollover : ComponentState.selected);
            }
            return this.getStateIcon(ComponentState.selectedDisabled);
        }
        if (bm.isEnabled()) {
            return this.getStateIcon(bm.isRollover() ? ComponentState.rollover : ComponentState.normal);
        }
        return this.getStateIcon(ComponentState.disabled);
    }

    protected NinePatchIcon getToolBarBackground(JToolBar toolbar) {
        if (toolbar instanceof WebToolBar && ((WebToolBar)toolbar).isFloating()) {
            return this.getStateIcon(toolbar.isEnabled() ? ComponentState.floating : ComponentState.floatingDisabled);
        }
        return this.getStateIcon(toolbar.isEnabled() ? ComponentState.normal : ComponentState.disabled);
    }

    public NinePatchIcon getExactStateIcon(String state) {
        return this.stateIcons.get(state);
    }

    public NinePatchIcon getStateIcon(String state) {
        if (state.equals(ComponentState.normal)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : null;
        }
        if (state.equals(ComponentState.rollover)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.normal);
        }
        if (state.equals(ComponentState.disabled)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.normal);
        }
        if (state.equals(ComponentState.pressed)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.selected);
        }
        if (state.equals(ComponentState.selected)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.normal);
        }
        if (state.equals(ComponentState.selectedRollover)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.selected);
        }
        if (state.equals(ComponentState.selectedDisabled)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.selected);
        }
        if (state.equals(ComponentState.selectedPressed)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.pressed);
        }
        if (state.equals(ComponentState.focused)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : null;
        }
        if (state.equals(ComponentState.floating)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.normal);
        }
        if (state.equals(ComponentState.floatingDisabled)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(ComponentState.floating);
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize(E c) {
        if (this.hasStateIcons()) {
            Dimension maxDimension = new Dimension(0, 0);
            for (NinePatchIcon npi : this.stateIcons.values()) {
                npi.setComponent((Component)c);
                maxDimension = SwingUtils.max(maxDimension, npi.getPreferredSize());
            }
            return maxDimension;
        }
        return super.getPreferredSize(c);
    }

    @Override
    public Insets getMargin(E c) {
        Insets margin = super.getMargin(c);
        if (this.hasStateIcons()) {
            Insets maxInsets = new Insets(0, 0, 0, 0);
            for (NinePatchIcon npi : this.stateIcons.values()) {
                npi.setComponent((Component)c);
                maxInsets = SwingUtils.max(maxInsets, npi.getMargin());
            }
            return SwingUtils.max(margin, maxInsets);
        }
        return margin;
    }
}

