/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.menu;

import com.alee.extended.menu.DynamicMenuLayout;
import com.alee.extended.menu.DynamicMenuType;
import com.alee.extended.menu.WebDynamicMenuItem;
import com.alee.laf.rootpane.WebWindow;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.utils.GeometryUtils;
import com.alee.utils.swing.WebHeavyWeightPopup;
import com.alee.utils.swing.WindowFollowAdapter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class WebDynamicMenu
extends WebHeavyWeightPopup {
    protected int radius;
    protected double startingAngle;
    protected double angleRange;
    protected DynamicMenuType type;
    protected DynamicMenuType hideType;
    protected boolean clockwise;
    protected List<WebDynamicMenuItem> items = new ArrayList<WebDynamicMenuItem>();
    protected WindowFollowAdapter followAdapter;
    protected int hidingCause = -1;
    protected AWTEventListener mouseListener;
    protected GlobalFocusListener focusListener;

    public WebDynamicMenu() {
        super("transparent", (LayoutManager)new DynamicMenuLayout());
        this.setAnimate(true);
        this.setStepProgress(0.04f);
        this.setWindowOpaque(false);
        this.setWindowOpacity(0.0f);
        this.setFollowInvoker(true);
        this.setCloseOnOuterAction(true);
        this.setRadius(60);
        this.setStartingAngle(0.0);
        this.setAngleRange(360.0);
        this.setType(DynamicMenuType.shutter);
        this.setHideType(null);
        this.setClockwise(true);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public double getStartingAngle() {
        return this.startingAngle;
    }

    public void setStartingAngle(double startingAngle) {
        this.startingAngle = startingAngle;
    }

    public double getAngleRange() {
        return this.angleRange;
    }

    public void setAngleRange(double angleRange) {
        this.angleRange = angleRange;
    }

    public DynamicMenuType getType() {
        return this.type;
    }

    public void setType(DynamicMenuType type) {
        this.type = type;
    }

    public DynamicMenuType getHideType() {
        return this.hideType != null ? this.hideType : this.type;
    }

    public void setHideType(DynamicMenuType hideType) {
        this.hideType = hideType;
    }

    public boolean isClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean clockwise) {
        this.clockwise = clockwise;
    }

    public List<WebDynamicMenuItem> getItems() {
        return this.items;
    }

    public WebDynamicMenuItem addItem(ImageIcon icon) {
        return this.addItem(icon, null);
    }

    public WebDynamicMenuItem addItem(ImageIcon icon, ActionListener action) {
        return this.addItem(new WebDynamicMenuItem(icon, action));
    }

    public WebDynamicMenuItem addItem(final WebDynamicMenuItem menuItem) {
        this.items.add(menuItem);
        menuItem.setEnabled(menuItem.getAction() != null);
        menuItem.setMargin(menuItem.getMargin());
        menuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ActionListener action = menuItem.getAction();
                if (action != null) {
                    action.actionPerformed(new ActionEvent(e.getSource(), 0, "Action performed"));
                }
                WebDynamicMenu.this.hideMenu(WebDynamicMenu.this.getComponentZOrder(menuItem));
            }
        });
        this.add((Component)menuItem);
        return menuItem;
    }

    public int getHidingCause() {
        return this.hidingCause;
    }

    @Override
    public WebDynamicMenu showPopup(Component invoker, int x, int y) {
        this.showMenu(invoker, x, y);
        return this;
    }

    public void showMenu(Component invoker, Point location) {
        this.showMenu(invoker, location.x, location.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMenu(Component invoker, int x, int y) {
        Object object = this.sync;
        synchronized (object) {
            Point displayPoint = this.getActualLayout().getDisplayPoint(this, x, y);
            super.showPopup(invoker, displayPoint.x, displayPoint.y);
        }
    }

    @Override
    protected void showAnimationStepPerformed() {
        this.revalidate();
    }

    @Override
    public WebHeavyWeightPopup hidePopup() {
        this.hideMenu();
        return this;
    }

    public void hideMenu() {
        this.hideMenu(-1);
    }

    public void hideMenu(int index) {
        this.hidingCause = index;
        super.hidePopup();
    }

    @Override
    protected void hideAnimationStepPerformed() {
        if (this.displayProgress > 0.0f) {
            this.revalidate();
        } else {
            this.hidingCause = -1;
            this.revalidate();
            this.fullyHidden();
        }
    }

    public double getItemAngle(Component item) {
        return this.getItemAngle(this.getComponentZOrder(item));
    }

    public double getItemAngle(int index) {
        return GeometryUtils.toDegrees(this.getActualLayout().getItemAngle(this, index));
    }

    public DynamicMenuLayout getActualLayout() {
        return (DynamicMenuLayout)this.getLayout();
    }

    public static boolean isAnyDynamicMenuDisplayed() {
        for (Window window : Window.getWindows()) {
            if (!window.isShowing() || !(window instanceof WebWindow) || !(((WebWindow)window).getContentPane() instanceof WebDynamicMenu)) continue;
            return true;
        }
        return false;
    }

    public static void hideAllDynamicMenus() {
        for (Window window : Window.getWindows()) {
            if (!window.isShowing() || !(window instanceof WebWindow) || !(((WebWindow)window).getContentPane() instanceof WebDynamicMenu)) continue;
            WebDynamicMenu menu = (WebDynamicMenu)((WebWindow)window).getContentPane();
            menu.hideMenu();
        }
    }
}

