/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.menu;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.menu.DynamicMenuType;
import com.alee.extended.menu.WebDynamicMenu;
import com.alee.utils.GeometryUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;

public class DynamicMenuLayout
extends AbstractLayoutManager {
    @Override
    public void layoutContainer(Container parent) {
        DynamicMenuType type;
        WebDynamicMenu menu = (WebDynamicMenu)parent;
        float displayProgress = MathUtils.sqr(menu.getDisplayProgress());
        DynamicMenuType dynamicMenuType = type = !menu.isHiding() ? menu.getType() : menu.getHideType();
        if (type.isRoundMenu()) {
            this.layoutRoundMenu(menu, displayProgress, type);
        } else {
            this.layoutPlainMenu(menu, displayProgress, type);
        }
    }

    protected void layoutPlainMenu(WebDynamicMenu menu, float displayProgress, DynamicMenuType type) {
        Dimension max = SwingUtils.max(menu.getComponents());
        int itemsCount = menu.getComponentCount();
        switch (type) {
            case list: {
                boolean x = false;
                int y = 0;
                for (int i = 0; i < itemsCount; ++i) {
                    this.placePlainElement(menu, i, 0, y);
                    y = (int)((float)y + (float)max.height * displayProgress);
                }
                break;
            }
        }
    }

    protected void placePlainElement(WebDynamicMenu menu, int i, int x, int y) {
        Component menuItem = menu.getComponent(i);
        Dimension ps = menuItem.getPreferredSize();
        menuItem.setBounds(x, y, ps.width, ps.height);
    }

    protected void layoutRoundMenu(WebDynamicMenu menu, float displayProgress, DynamicMenuType type) {
        Dimension max = SwingUtils.max(menu.getComponents());
        Point center = new Point(menu.getRadius(), menu.getRadius());
        int itemSide = Math.max(max.width, max.height);
        int hidingCause = menu.getHidingCause();
        int hidingCauseIndex = hidingCause != -1 ? hidingCause : 0;
        int radius = menu.getRadius() - itemSide / 2;
        double singleComponentSpacing = this.getSingleComponentSpacing(menu);
        double startingAngle = this.getStartingAngle(menu);
        int cwSign = menu.isClockwise() ? 1 : -1;
        int itemsCount = menu.getComponentCount();
        switch (type) {
            case roll: {
                double oneAngle = (double)displayProgress * singleComponentSpacing;
                for (int i = 0; i < itemsCount; ++i) {
                    int ai = hidingCauseIndex + i;
                    int ci = ai < itemsCount ? ai : ai - itemsCount;
                    double angle = startingAngle + (double)hidingCauseIndex * singleComponentSpacing + oneAngle * (double)i * (double)cwSign;
                    int x = (int)Math.round((double)center.x + (double)radius * Math.cos(angle));
                    int y = (int)Math.round((double)center.y + (double)radius * Math.sin(angle));
                    this.placeRoundElement(menu, ci, x, y);
                }
                break;
            }
            case star: {
                int cradius = Math.round((float)radius * displayProgress);
                for (int i = 0; i < itemsCount; ++i) {
                    double angle = startingAngle + singleComponentSpacing * (double)i * (double)cwSign;
                    int r = i == hidingCause ? radius : cradius;
                    int x = (int)Math.round((double)center.x + (double)r * Math.cos(angle));
                    int y = (int)Math.round((double)center.y + (double)r * Math.sin(angle));
                    this.placeRoundElement(menu, i, x, y);
                }
                break;
            }
            case shutter: {
                int cradius = Math.round((float)radius * displayProgress);
                int modSign = menu.isDisplaying() ? -1 : 1;
                double angleMod = GeometryUtils.toRadians((float)(modSign * 90) * (1.0f - displayProgress));
                for (int i = 0; i < itemsCount; ++i) {
                    double mod = i == hidingCause ? 0.0 : angleMod;
                    double angle = startingAngle + (singleComponentSpacing * (double)i + mod) * (double)cwSign;
                    int r = i == hidingCause ? radius : cradius;
                    int x = (int)Math.round((double)center.x + (double)r * Math.cos(angle));
                    int y = (int)Math.round((double)center.y + (double)r * Math.sin(angle));
                    this.placeRoundElement(menu, i, x, y);
                }
                break;
            }
            case fade: {
                for (int i = 0; i < itemsCount; ++i) {
                    double angle = startingAngle + singleComponentSpacing * (double)i * (double)cwSign;
                    int x = (int)Math.round((double)center.x + (double)radius * Math.cos(angle));
                    int y = (int)Math.round((double)center.y + (double)radius * Math.sin(angle));
                    this.placeRoundElement(menu, i, x, y);
                }
                break;
            }
        }
    }

    public double getSingleComponentSpacing(WebDynamicMenu menu) {
        double fullCircle = GeometryUtils.toRadians(Math.min(menu.getAngleRange(), 360.0));
        return fullCircle < Math.PI * 2 ? fullCircle / (double)(menu.getComponentCount() - 1) : fullCircle / (double)menu.getComponentCount();
    }

    public double getStartingAngle(WebDynamicMenu menu) {
        return GeometryUtils.toRadians(menu.getStartingAngle()) - 1.5707963267948966;
    }

    public double getItemAngle(WebDynamicMenu menu, int index) {
        int cwSign = menu.isClockwise() ? 1 : -1;
        switch (menu.getType()) {
            default: 
        }
        double startingAngle = this.getStartingAngle(menu);
        double singleComponentSpacing = this.getSingleComponentSpacing(menu);
        return startingAngle + singleComponentSpacing * (double)index * (double)cwSign;
    }

    protected void placeRoundElement(WebDynamicMenu menu, int i, int x, int y) {
        Component menuItem = menu.getComponent(i);
        Dimension ps = menuItem.getPreferredSize();
        menuItem.setBounds(x - ps.width / 2, y - ps.height / 2, ps.width, ps.height);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        WebDynamicMenu menu = (WebDynamicMenu)parent;
        switch (menu.getType()) {
            case roll: 
            case star: 
            case shutter: 
            case fade: {
                int radius = menu.getRadius();
                return new Dimension(radius * 2, radius * 2);
            }
            case list: {
                Dimension max = SwingUtils.max(menu.getComponents());
                int itemsCount = menu.getComponentCount();
                return new Dimension(max.width, max.height * itemsCount);
            }
        }
        return new Dimension(0, 0);
    }

    public Point getDisplayPoint(WebDynamicMenu menu, int x, int y) {
        switch (menu.getType()) {
            case roll: 
            case star: 
            case shutter: 
            case fade: {
                Dimension size = this.preferredLayoutSize(menu);
                return new Point(x - size.width / 2, y - size.height / 2);
            }
        }
        return new Point(x, y);
    }
}

