/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class StackLayout
extends AbstractLayoutManager {
    public static final String CONTENT = "CONTENT";
    public static final String HIDDEN = "HIDDEN";
    protected Map<Component, String> constraints = new HashMap<Component, String>();

    @Override
    public void addComponent(Component component, Object constraints) {
        String value = (String)constraints;
        if (!(value == null || value.trim().equals("") || value.equals(CONTENT) || value.equals(HIDDEN))) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be null or an empty/'CONTENT'/'HIDDEN' string");
        }
        this.constraints.put(component, value == null || value.trim().equals("") ? CONTENT : value);
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension ps = new Dimension(0, 0);
        for (Component component : parent.getComponents()) {
            if (this.constraints.get(component) != null && this.constraints.get(component).equals(HIDDEN)) continue;
            Dimension cps = component.getPreferredSize();
            ps.width = Math.max(ps.width, cps.width);
            ps.height = Math.max(ps.height, cps.height);
        }
        return new Dimension(insets.left + ps.width + insets.right, insets.top + ps.height + insets.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        for (Component component : parent.getComponents()) {
            if (this.constraints.get(component) != null && this.constraints.get(component).equals(HIDDEN)) continue;
            component.setBounds(insets.left, insets.top, parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom);
        }
    }
}

