/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;

public class MultiLayout
extends AbstractLayoutManager {
    protected List<LayoutManager> layoutManagers = new ArrayList<LayoutManager>(2);

    public List<LayoutManager> getLayoutManagers() {
        return this.layoutManagers;
    }

    public void setLayoutManagers(List<LayoutManager> layoutManagers) {
        this.layoutManagers = layoutManagers;
    }

    public void addLayoutManager(LayoutManager layoutManager) {
        this.layoutManagers.add(layoutManager);
    }

    public void removeLayoutManager(LayoutManager layoutManager) {
        this.layoutManagers.remove(layoutManager);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            if (!(layoutManager instanceof LayoutManager2)) continue;
            ((LayoutManager2)layoutManager).addLayoutComponent(comp, constraints);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            layoutManager.addLayoutComponent(name, comp);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            layoutManager.removeLayoutComponent(comp);
        }
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            if (layoutManager instanceof LayoutManager2) {
                ((LayoutManager2)layoutManager).addLayoutComponent(component, constraints);
                continue;
            }
            layoutManager.addLayoutComponent(constraints == null ? null : constraints.toString(), component);
        }
    }

    @Override
    public void removeComponent(Component component) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            layoutManager.removeLayoutComponent(component);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension ps = new Dimension(0, 0);
        for (LayoutManager layoutManager : this.layoutManagers) {
            ps = SwingUtils.max(ps, layoutManager.preferredLayoutSize(parent));
        }
        return ps;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension ms = new Dimension(0, 0);
        for (LayoutManager layoutManager : this.layoutManagers) {
            ms = SwingUtils.max(ms, layoutManager.minimumLayoutSize(parent));
        }
        return ms;
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        Dimension ms = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (LayoutManager layoutManager : this.layoutManagers) {
            if (!(layoutManager instanceof LayoutManager2)) continue;
            ms = SwingUtils.min(ms, ((LayoutManager2)layoutManager).maximumLayoutSize(parent));
        }
        return ms;
    }

    @Override
    public void invalidateLayout(Container parent) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            if (!(layoutManager instanceof LayoutManager2)) continue;
            ((LayoutManager2)layoutManager).invalidateLayout(parent);
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            layoutManager.layoutContainer(parent);
        }
    }
}

