/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import parser.flightAnalyzer;
import prog.controller;
import prog.lang;
import prog.service;

public class flightLog
implements Runnable {
    public volatile boolean doit;
    public volatile boolean logon;
    public FileOutputStream resultsFile;
    public FileWriter csv;
    public String fileName;
    public flightAnalyzer fA;
    controller xc;
    service xs;
    Calendar c;
    boolean firstAnalyze = true;
    private String climbName;
    private String maneuverName;
    private String rollName;
    private String loadName;
    private BufferedWriter csvWritter;
    private long writeTime;

    void writeLabel(FileWriter fileWriter) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(lang.l1);
        bufferedWriter.write(lang.l2);
        bufferedWriter.write(lang.l3);
        bufferedWriter.write(lang.l4);
        bufferedWriter.write(lang.l5);
        bufferedWriter.write(lang.l6);
        bufferedWriter.write(lang.l7);
        bufferedWriter.write(lang.l8);
        bufferedWriter.write(lang.l9);
        bufferedWriter.write(lang.l10);
        bufferedWriter.write(lang.l11);
        bufferedWriter.write(lang.l12);
        bufferedWriter.write(lang.l13);
        bufferedWriter.write(lang.l14);
        bufferedWriter.write(lang.l15);
        bufferedWriter.write(lang.l16);
        bufferedWriter.write(lang.l17);
        bufferedWriter.write(lang.l18);
        bufferedWriter.write(lang.l19);
        bufferedWriter.write(lang.l20);
        bufferedWriter.write(lang.l21);
        bufferedWriter.write(lang.l22);
        bufferedWriter.write(lang.l23);
        bufferedWriter.write(lang.l24);
        bufferedWriter.write(lang.l25);
        bufferedWriter.write(lang.l26);
        bufferedWriter.write(lang.l27);
        bufferedWriter.write(lang.l28);
        bufferedWriter.write(lang.l29);
        bufferedWriter.write(lang.l30);
        bufferedWriter.write(lang.l31);
        bufferedWriter.write("\n");
        bufferedWriter.flush();
    }

    void writeData(BufferedWriter bufferedWriter) throws IOException {
        String string = "";
        bufferedWriter.write((float)this.xs.elapsedTime / 60000.0f + ",");
        string = this.xs.throttle;
        bufferedWriter.write(string + ",");
        bufferedWriter.write(this.xs.IAS + ",");
        bufferedWriter.write(this.xs.TAS + ",");
        bufferedWriter.write(this.xs.M + ",");
        bufferedWriter.write(this.xs.salt + ",");
        bufferedWriter.write(this.xs.watertemp + ",");
        bufferedWriter.write(this.xs.oiltemp + ",");
        bufferedWriter.write(this.xs.Vy + ",");
        bufferedWriter.write(this.xs.sSEP + ",");
        bufferedWriter.write(this.xs.sState.Ny + ",");
        bufferedWriter.write(this.xs.Wx + ",");
        bufferedWriter.write(this.xs.sTotalHp + ",");
        bufferedWriter.write(this.xs.efficiency[0] + ",");
        bufferedWriter.write(this.xs.sTotalHpEff + ",");
        bufferedWriter.write(this.xs.rpm + ",");
        bufferedWriter.write(this.xs.iTotalThr + ",");
        bufferedWriter.write(this.xs.acceleration + ",");
        bufferedWriter.write(this.xs.RPMthrottle + ",");
        bufferedWriter.write(this.xs.pitch[0] + ",");
        bufferedWriter.write(this.xs.radiator + ",");
        bufferedWriter.write(this.xs.mixture + ",");
        bufferedWriter.write(this.xs.sState.compressorstage + ",");
        bufferedWriter.write(this.xs.sState.magenato + ",");
        bufferedWriter.write(this.xs.manifoldpressure + ",");
        bufferedWriter.write(this.xs.flaps + ",");
        bufferedWriter.write(this.xs.sState.elevator + ",");
        bufferedWriter.write(this.xs.sState.aileron + ",");
        bufferedWriter.write(this.xs.sState.rudder + ",");
        bufferedWriter.write(this.xs.AoA + ",");
        bufferedWriter.write(this.xs.AoS + ",");
        bufferedWriter.write("\n");
    }

    void analyzeData() {
        int n = (int)this.xs.alt / 100;
        if (Math.abs(this.xs.iCheckAlt) > 10) {
            if (this.firstAnalyze) {
                this.fA = new flightAnalyzer();
                this.fA.init(n, this.xs);
                this.firstAnalyze = false;
            } else {
                this.fA.analyze(n);
                this.fA.updateEMChart(this.xs.IASv, this.xs.sState.Ny, (int)Math.abs(this.xs.sState.Wx), this.xs.SEP / (double)9.78f, Math.abs(this.xs.sState.elevator), Math.abs(this.xs.sState.aileron));
            }
        }
    }

    void writeClimbLabel(FileWriter fileWriter) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(lang.fAlt + "/m, ");
        bufferedWriter.write("t/s, ");
        bufferedWriter.write(lang.ePower + "/hp, ");
        bufferedWriter.write(lang.eThurst + "/kgf, ");
        bufferedWriter.write(lang.fSEP + "/m/s");
        bufferedWriter.write("\n");
        bufferedWriter.flush();
    }

    void writeClimbData(FileWriter fileWriter) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        for (int i = 0; i < this.fA.curaltStage; ++i) {
            bufferedWriter.write(i * 100 + ", ");
            bufferedWriter.write(this.fA.time[i] + ", ");
            bufferedWriter.write(this.fA.power[i] + ", ");
            bufferedWriter.write(this.fA.thrust[i] + ", ");
            bufferedWriter.write(this.fA.sep[i] + "\n");
        }
        bufferedWriter.flush();
    }

    public void saveClimbData() {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.climbName, true);
        }
        catch (IOException iOException) {
            controller.notification(lang.lfailCreate);
            iOException.printStackTrace();
            return;
        }
        try {
            this.writeClimbLabel(fileWriter);
            this.writeClimbData(fileWriter);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void writeRollLabel(FileWriter fileWriter) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(lang.fIAS + "/km/h, ");
        bufferedWriter.write(lang.vAileron + "/%, ");
        bufferedWriter.write(lang.fWx + "/Deg/s");
        bufferedWriter.write("\n");
        bufferedWriter.flush();
    }

    void writeRollData(FileWriter fileWriter) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.fA.roll_rate[i] <= 0) continue;
            ++n;
            bufferedWriter.write(i * 10 + ", ");
            bufferedWriter.write(this.fA.roll_alr[i] + ", ");
            bufferedWriter.write(this.fA.roll_rate[i] + "\n");
        }
        bufferedWriter.flush();
    }

    public void saveRollData() {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.rollName, true);
        }
        catch (IOException iOException) {
            controller.notification(lang.lfailCreate);
            iOException.printStackTrace();
            return;
        }
        try {
            this.writeRollLabel(fileWriter);
            this.writeRollData(fileWriter);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void writeNyLabel(FileWriter fileWriter) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(lang.fIAS + "/km/h, ");
        bufferedWriter.write(lang.vElevator + "/%, ");
        bufferedWriter.write(lang.fGL + "/G, ");
        bufferedWriter.write(lang.fSEP + "/m/s");
        bufferedWriter.write("\n");
        bufferedWriter.flush();
    }

    void writeNyData(FileWriter fileWriter) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (!(this.fA.turn_load[i] > 0.0)) continue;
            ++n;
            bufferedWriter.write(i * 10 + ", ");
            bufferedWriter.write(this.fA.turn_elev[i] + ", ");
            bufferedWriter.write(this.fA.turn_load[i] + ", ");
            bufferedWriter.write(this.fA.sep_loss[i] + "\n");
        }
        bufferedWriter.flush();
    }

    public void saveNyData() {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.loadName, true);
        }
        catch (IOException iOException) {
            controller.notification(lang.lfailCreate);
            iOException.printStackTrace();
            return;
        }
        try {
            this.writeNyLabel(fileWriter);
            this.writeNyData(fileWriter);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void init(controller controller2, service service2) {
        this.xc = controller2;
        this.xs = service2;
        this.doit = false;
        this.c = Calendar.getInstance();
        this.c.setTimeInMillis(System.currentTimeMillis());
        String string = service2.sIndic.type.toUpperCase();
        if (string == "NO COCKPIT") {
            string = "Unknown";
        }
        this.fileName = "records/" + string + "_" + (this.c.get(2) + 1) + "_" + this.c.get(5) + "_" + this.c.get(10) + "." + this.c.get(12) + "." + this.c.get(13) + ".csv";
        this.climbName = "records/" + string + "_" + (this.c.get(2) + 1) + "_" + this.c.get(5) + "_" + this.c.get(10) + "." + this.c.get(12) + "." + this.c.get(13) + "_climb.csv";
        this.rollName = "records/" + string + "_" + (this.c.get(2) + 1) + "_" + this.c.get(5) + "_" + this.c.get(10) + "." + this.c.get(12) + "." + this.c.get(13) + "_roll.csv";
        this.loadName = "records/" + string + "_" + (this.c.get(2) + 1) + "_" + this.c.get(5) + "_" + this.c.get(10) + "." + this.c.get(12) + "." + this.c.get(13) + "_ny.csv";
        try {
            this.resultsFile = new FileOutputStream(this.fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            controller.notification(lang.lfailCreate);
            fileNotFoundException.printStackTrace();
            this.xc.logon = false;
        }
        try {
            this.csv = new FileWriter(this.fileName, true);
        }
        catch (IOException iOException) {
            controller.notification(lang.lfailCreate);
            iOException.printStackTrace();
        }
        try {
            this.writeLabel(this.csv);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.csvWritter = new BufferedWriter(this.csv);
        this.logon = true;
    }

    public void close() {
        try {
            this.csvWritter.close();
            this.csv.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.saveClimbData();
        this.saveRollData();
        this.saveNyData();
        this.logon = false;
    }

    public void logTick() {
        try {
            this.analyzeData();
            this.writeData(this.csvWritter);
        }
        catch (IOException iOException) {
            controller.notification(lang.lfailWrite);
            iOException.printStackTrace();
        }
        if (this.writeTime++ % 1024L == 0L) {
            try {
                this.csvWritter.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        while (this.logon) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.doit) {
                this.logTick();
                this.doit = false;
            }
        }
    }
}

