/*
 * Decompiled with CFR 0.152.
 */
package parser;

import prog.app;
import prog.controller;
import prog.lang;
import prog.service;

public class flightAnalyzer {
    public int engineType;
    public String type;
    public static final int maxAltStage = 256;
    public double[] time = new double[256];
    public int[] power = new int[256];
    public int[] thrust = new int[256];
    public int[] eff = new int[256];
    public double[] sep = new double[256];
    public int initaltStage;
    public int curaltStage;
    boolean isInformation;
    service xs;
    int count;
    public static final int maxIASStage = 256;
    public int[] roll_rate = new int[256];
    public int[] roll_alr = new int[256];
    public double[] turn_load = new double[256];
    public int[] turn_elev = new int[256];
    public double[] sep_loss = new double[256];

    void init(int n, service service2) {
        this.xs = service2;
        this.count = 1;
        this.isInformation = Boolean.parseBoolean(service2.c.getconfig("enableAltInformation"));
        this.type = this.xs.sIndic.type;
        this.engineType = this.xs.iEngType;
        this.curaltStage = this.initaltStage = n;
        this.time[this.curaltStage] = (float)this.xs.elapsedTime / 1000.0f;
        this.power[this.curaltStage] = this.xs.iTotalHp;
        this.thrust[this.curaltStage] = this.xs.iTotalThr;
        this.eff[this.curaltStage] = this.xs.iTotalHpEff;
        this.sep[this.curaltStage] = this.xs.SEP;
    }

    void analyze(int n) {
        this.engineType = this.xs.iEngType;
        if (n == this.curaltStage + 1) {
            this.eff[this.curaltStage] = this.eff[this.curaltStage] / this.count;
            this.sep[this.curaltStage] = this.sep[this.curaltStage] / (double)((float)this.count * 9.78f);
            ++this.curaltStage;
            this.time[this.curaltStage] = (float)this.xs.elapsedTime / 1000.0f;
            this.power[this.curaltStage] = this.xs.iTotalHp;
            this.thrust[this.curaltStage] = this.xs.iTotalThr;
            this.eff[this.curaltStage] = this.xs.iTotalHpEff;
            this.sep[this.curaltStage] = this.xs.SEP;
            this.count = 1;
            if (this.isInformation) {
                controller.notification(lang.fA1 + n * 100 + lang.fA2 + (int)this.time[this.curaltStage] + lang.fA3 + (float)((int)((double)((n - this.initaltStage) * 1000) / this.time[this.curaltStage])) / 10.0f + lang.fA4);
            }
        } else {
            this.eff[this.curaltStage] = this.eff[this.curaltStage] + this.xs.iTotalHpEff;
            this.sep[this.curaltStage] = this.sep[this.curaltStage] + this.xs.SEP;
            ++this.count;
        }
    }

    public int getSpeedStage(double d) {
        return (int)Math.round(d / 10.0);
    }

    public void updateEMChart(double d, double d2, int n, double d3, int n2, int n3) {
        int n4 = this.getSpeedStage(d);
        if (n4 >= 0 && n4 < 256) {
            if (n3 > 5 && n > 10 && n3 >= this.roll_alr[n4] && n > this.roll_rate[n4]) {
                this.roll_alr[n4] = n3;
                if (this.isInformation && n - this.roll_rate[n4] > 40) {
                    controller.notification(lang.fA_roll1 + n4 * 10 + lang.fA_roll2 + n + lang.fA_roll3);
                }
                this.roll_rate[n4] = n;
            }
            if (d2 > 1.0 && d3 < 5.0 && n2 >= this.turn_elev[n4]) {
                this.turn_elev[n4] = n2;
                if (this.isInformation && d2 - this.turn_load[n4] > 3.0) {
                    controller.notification(lang.fA_turn1 + n4 * 10 + lang.fA_turn2 + String.format("%.1f", (this.turn_load[n4] + d2) / 2.0) + lang.fA_turn3 + String.format("%.1f", (this.sep_loss[n4] + d3) / 2.0) + lang.fA_turn4);
                }
                this.turn_load[n4] = (this.turn_load[n4] + d2) / 2.0;
                this.sep_loss[n4] = (this.sep_loss[n4] + d3) / 2.0;
            }
        }
    }

    public int getNoZerosNum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            ++n;
        }
        return n;
    }

    public int getNoZerosNum(double[] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            ++n;
        }
        return n;
    }

    public void removeZeroes(double[] dArray, double[] dArray2, int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            dArray[n] = (double)i * 10.0;
            dArray2[n] = (double)(nArray[i - 1] + nArray[i] + nArray[i + 1]) / 3.0;
            ++n;
        }
    }

    public void removeZeroes(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        for (int i = 1; i < dArray3.length - 1; ++i) {
            if (dArray3[i] == 0.0) continue;
            dArray[n] = (double)i * 10.0;
            dArray2[n] = (dArray3[i - 1] + dArray3[i] + dArray3[i + 1]) / 3.0;
            ++n;
        }
    }

    public void removeRollRatesZeroes(double[] dArray, double[] dArray2) {
        this.removeZeroes(dArray, dArray2, this.roll_rate);
    }

    public void removeLoadZeroes(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        for (int i = 1; i < this.turn_load.length - 1; ++i) {
            if (this.turn_load[i] == 0.0) continue;
            dArray[n] = (double)i * 10.0;
            dArray2[n] = (this.turn_load[i - 1] + this.turn_load[i] + this.turn_load[i + 1]) / 3.0;
            dArray3[n] = (this.sep_loss[i - 1] + this.sep_loss[i] + this.sep_loss[i + 1]) / 3.0;
            ++n;
        }
    }

    public void showAllEMChart() {
        app.debugPrint("roll rate:");
        for (int i = 0; i < 256; ++i) {
            System.out.print(this.roll_rate[i] + ",");
        }
    }
}

