# Week 7 – Exploring AI Code Review Using Graphite

## Assignment Overview
In this assignment, you will practice agent-driven development and AI-assisted code review on a more advanced codebase. You will implement the tasks in `week7/docs/TASKS.md`, validate your work with tests and manual review, and compare your own review notes with AI-generated code reviews.

## Get Started with Graphite
1. Sign up for Graphite: https://app.graphite.dev/signup
2. Upon sign up, you can claim your 30-day free trial.
3. After the 30 days, you can use code **CS146S** to claim free Graphite under their education program. 


## What to do
Implement the tasks from `week7/docs/TASKS.md` using an AI coding tool of your choice (e.g. Cursor, Copilot, Claude, etc.).

### For each task:
   1. Create a separate branch.
   2. Implement the task with your AI tool using a 1-shot prompt. 
   3. Manually review the changes line-by-line. Fix issues you notice and add explanatory commit messages where helpful. You may also pair with a classmate to review each other’s code instead of reviewing your own changes.
   4. Open a Pull Request (PR) for the task. Ensure your PRs include:
      - Description of the problem and your approach.
      - Summary of testing performed (include commands and results) and any added/updated tests.
      - Notable tradeoffs, limitations, or follow-ups.
   5. Use Graphite Diamond to generate an AI-assisted code review on the PR.
   6. Document the results of your PR in the `writeup.md`.


## Deliverables
In your `writeup.md`, we are looking for the follwoing:

- Four PRs, one per completed task, each with:
  - Clear PR description
  - Links to relevant commits/issues.
  - Graphite Diamond AI review comments visible on the PR

- A brief reflection addressing the following:
  - The types of comments you typically made in your manual reviews (e.g., correctness, performance, security, naming, test gaps, API shape, UX, docs).
  - A comparison of **your** comments vs. **Graphite’s** AI-generated comments for each PR.
  - When the AI reviews were better/worse than yours (cite specific examples)
  - Your comfort level trusting AI reviews going forward and any heuristics for when to rely on them.

## Evaluation criteria (100 points total)
- 20 points per completed task
  - Technical correctness and completeness of each task.
  - Code quality: readability, naming, structure, error handling, and tests.
  - Thoughtfulness and depth of manual review notes
  - Graphite Diamond AI generated code review
- 20 points for the brief reflection
  - Insightful comparison between your review and Graphite’s AI review
  - Description of your personal comfort level with AI Reviews


## Submission Instructions
1. Make sure you have all changes pushed to your remote repository for grading.
2. Make sure you've added both brentju and febielin as collaborators on your assignment repository.
2. Submit via Gradescope. 
