/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import nicelee.bilibili.util.Logger;
import nicelee.ui.item.MJTitleBar;
import nicelee.ui.item.impl.TextTransferHandler;

public class FrameAbout
extends JFrame
implements HyperlinkListener {
    private static final long serialVersionUID = -5017130575041108799L;
    private static FrameAbout frame;

    private FrameAbout() {
    }

    private void initUI() {
        this.setSize(800, 580);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setTitle("\u7528\u7231\u53d1\u7535 bilibili~~");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        MJTitleBar mJTitleBar = new MJTitleBar(this, true);
        jPanel.add(mJTitleBar);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.putClientProperty("charset", "utf-8");
        jEditorPane.setEditable(false);
        jEditorPane.setTransferHandler(new TextTransferHandler());
        try {
            jEditorPane.setPage(this.getClass().getResource("/resources/about.html"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jEditorPane.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(800, 540));
        jPanel.add(jScrollPane);
        this.setContentPane(jPanel);
    }

    public static void showAbout() {
        if (frame == null) {
            frame = new FrameAbout();
            frame.initUI();
        }
        frame.setVisible(true);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            Logger.println(uRL.toString());
            try {
                Desktop desktop = Desktop.getDesktop();
                if (uRL.getProtocol().startsWith("http")) {
                    desktop.browse(uRL.toURI());
                } else {
                    File file = new File(uRL.toString().substring(7));
                    Logger.println(file.getAbsolutePath());
                    desktop.open(file);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

