/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractBaseParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4PictureParser", note="\u76f8\u7c3f\u89e3\u6790 draw-cos-daily")
public class URL4PictureParser
extends AbstractBaseParser {
    private static final Pattern pattern = Pattern.compile("h\\.bilibili\\.com/([0-9]+)");
    private static final Pattern numberPattern = Pattern.compile("^h[0-9]+$");
    private String hId;

    public URL4PictureParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        boolean bl = this.matcher.find();
        if (bl) {
            this.hId = "h" + this.matcher.group(1);
            System.out.println("\u5339\u914dURL4PictureParser: " + this.hId);
            return true;
        }
        this.matcher = numberPattern.matcher(string);
        bl = this.matcher.find();
        if (bl) {
            this.hId = this.matcher.group();
            System.out.println("\u5339\u914dURL4PictureParser: " + this.hId);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.hId;
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        String string2 = this.hId.replace("h", "");
        System.out.println("URL4PictureParser\u6b63\u5728\u83b7\u53d6\u7ed3\u679c" + this.hId);
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.setVideoId(this.hId);
        String string3 = "https://api.vc.bilibili.com/link_draw/v1/doc/detail?doc_id=" + string2;
        HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders("https://h.bilibili.com");
        String string4 = this.util.getContent(string3, hashMap, HttpCookies.getGlobalCookies());
        Logger.println(string3);
        Logger.println(string4);
        JSONObject jSONObject = new JSONObject(string4).getJSONObject("data");
        JSONObject jSONObject2 = jSONObject.getJSONObject("user");
        JSONObject jSONObject3 = jSONObject.getJSONObject("item");
        JSONArray jSONArray = jSONObject3.getJSONArray("pictures");
        String string5 = jSONObject3.getString("title");
        if (string5.isEmpty() && (string5 = jSONObject3.getString("description")).length() > 15) {
            string5 = string5.substring(0, 15);
        }
        String string6 = jSONObject3.getString("description");
        String string7 = jSONObject2.getString("name");
        String string8 = String.valueOf(jSONObject2.getLong("uid"));
        String string9 = jSONArray.getJSONObject(0).getString("img_src");
        videoInfo.setVideoName(string5);
        videoInfo.setBrief(string6);
        videoInfo.setAuthor(string7);
        videoInfo.setAuthorId(string8);
        videoInfo.setVideoPreview(string9);
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject4 = jSONArray.getJSONObject(i);
            ClipInfo clipInfo = new ClipInfo();
            clipInfo.setAvTitle(videoInfo.getVideoName());
            clipInfo.setAvId(this.hId);
            clipInfo.setcId(i);
            clipInfo.setPage(i);
            clipInfo.setTitle("\u7b2c" + i + "\u5f20");
            clipInfo.setPicPreview(jSONObject4.getString("img_src"));
            clipInfo.setUpName(string7);
            clipInfo.setUpId(string8);
            LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
            linkedHashMap2.put(0, jSONObject4.getString("img_src"));
            clipInfo.setLinks(linkedHashMap2);
            linkedHashMap.put(clipInfo.getcId(), clipInfo);
        }
        videoInfo.setClips(linkedHashMap);
        videoInfo.print();
        return videoInfo;
    }
}

