/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class URL4ChannelSeriesParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("space\\.bilibili\\.com/([0-9]+)/channel/seriesdetail\\?sid=([0-9]+)");
    private String spaceID;
    private String sid;

    public URL4ChannelSeriesParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            System.out.println("\u5339\u914dUP\u4e3b\u5408\u96c6\u548c\u89c6\u9891\u5217\u8868 ...");
            this.spaceID = this.matcher.group(1);
            this.sid = this.matcher.group(2);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim() + "&p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 20;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        int n4 = (Integer)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        try {
            Object object;
            String string;
            String string2;
            HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders("api.bilibili.com");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                string2 = "https://api.bilibili.com/x/series/series?series_id=" + this.sid;
                Logger.println(string2);
                string = this.util.getContent(string2, hashMap);
                object = new JSONObject(string).getJSONObject("data").getJSONObject("meta");
                ((VideoInfo)this.pageQueryResult).setVideoId(this.spaceID + " - " + this.sid);
                ((VideoInfo)this.pageQueryResult).setVideoName(((JSONObject)object).getString("name") + this.paramSetter.getPage());
                ((VideoInfo)this.pageQueryResult).setBrief(((JSONObject)object).getString("description"));
                ((VideoInfo)this.pageQueryResult).setAuthorId(this.spaceID);
            }
            string2 = "https://api.bilibili.com/x/series/archives?mid=%s&series_id=%s&only_normal=true&sort=desc&pn=%d&ps=%d";
            string = String.format(string2, this.spaceID, this.sid, n, this.API_PMAX);
            object = this.util.getContent(string, hashMap);
            Logger.println(string);
            JSONObject jSONObject = new JSONObject((String)object);
            JSONArray jSONArray = jSONObject.getJSONObject("data").getJSONArray("archives");
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            for (int i = n2 - 1; i < jSONArray.length() && i < n3; ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                try {
                    linkedHashMap.putAll(this.convertVideoToClipMap(jSONObject2.getString("bvid"), (n - 1) * this.API_PMAX + i + 1, n4, bl));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private LinkedHashMap<Long, ClipInfo> convertVideoToClipMap(String string, int n, int n2, boolean bl) {
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        VideoInfo videoInfo = this.getAVDetail(string, n2, bl);
        if (((VideoInfo)this.pageQueryResult).getAuthor() == null) {
            ((VideoInfo)this.pageQueryResult).setAuthor(videoInfo.getAuthor());
            ((VideoInfo)this.pageQueryResult).setVideoPreview(videoInfo.getVideoPreview());
        }
        for (ClipInfo clipInfo : videoInfo.getClips().values()) {
            clipInfo.setListName(((VideoInfo)this.pageQueryResult).getVideoName().replaceAll("[/\\\\]", "_"));
            clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
            clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
            clipInfo.setRemark(n);
            linkedHashMap.put(clipInfo.getcId(), clipInfo);
        }
        return linkedHashMap;
    }
}

