/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.item;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nicelee.bilibili.INeedAV;
import nicelee.bilibili.downloaders.Downloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.Global;
import nicelee.ui.TabDownload;
import nicelee.ui.item.JOptionPane;
import nicelee.ui.item.MJButton;
import nicelee.ui.thread.DownloadRunnableInternal;

public class DownloadInfoPanel
extends JPanel
implements ActionListener {
    ClipInfo clipInfo;
    String avTitle;
    String clipTitle;
    String avid;
    String cid;
    int page;
    int remark;
    int qn;
    int realqn;
    public INeedAV iNeedAV;
    public String url;
    public String avid_qn;
    public String formattedTitle;
    public boolean stopOnQueue = false;
    int failCnt = 0;
    long lastCntTime = 0L;
    long lastCnt = 0L;
    private static final long serialVersionUID = -752743062676819402L;
    String path;
    String fileName;
    long totalSize;
    long currentDown;
    boolean isdownloading = true;
    JButton btnRemove;
    JButton btnOpen;
    JButton btnOpenFolder;
    JButton btnControl;
    JLabel lbCurrentStatus;
    JLabel lbDownFile;
    JLabel lbFileName;
    JLabel lbavName;

    public int getFailCnt() {
        return this.failCnt;
    }

    public void setFailCnt(int n) {
        this.failCnt = n;
    }

    public DownloadInfoPanel(ClipInfo clipInfo, int n) {
        this.clipInfo = clipInfo;
        this.avTitle = clipInfo.getAvTitle();
        this.clipTitle = clipInfo.getAvTitle();
        this.avid = clipInfo.getAvId();
        this.cid = Long.toString(clipInfo.getcId());
        this.page = clipInfo.getPage();
        this.remark = clipInfo.getRemark();
        this.qn = n;
        this.path = "D:\\bilibiliDown\\";
        this.fileName = "timg.gif";
        this.totalSize = 0L;
        this.currentDown = 0L;
        this.initUI(this);
    }

    void initUI(DownloadInfoPanel downloadInfoPanel) {
        this.setBorder(BorderFactory.createLineBorder(Color.red));
        this.setPreferredSize(new Dimension(1100, 120));
        this.lbFileName = new JLabel("\u5c1a\u672a\u751f\u6210");
        this.lbFileName.setPreferredSize(new Dimension(600, 45));
        this.lbFileName.setBorder(BorderFactory.createLineBorder(Color.red));
        this.add(this.lbFileName);
        this.btnOpen = new MJButton("\u6253\u5f00\u6587\u4ef6");
        this.btnOpen.setPreferredSize(new Dimension(100, 45));
        this.btnOpen.addActionListener(this);
        this.add(this.btnOpen);
        this.btnOpenFolder = new MJButton("\u6253\u5f00\u6587\u4ef6\u5939");
        this.btnOpenFolder.setPreferredSize(new Dimension(100, 45));
        this.btnOpenFolder.addActionListener(this);
        this.add(this.btnOpenFolder);
        this.btnRemove = new MJButton("\u5220\u9664\u4efb\u52a1");
        this.btnRemove.setPreferredSize(new Dimension(100, 45));
        this.btnRemove.addActionListener(this);
        this.add(this.btnRemove);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(100, 45));
        this.add(jLabel);
        this.lbavName = new JLabel(this.avTitle);
        this.lbavName.setToolTipText(this.avTitle);
        this.lbavName.setPreferredSize(new Dimension(500, 45));
        this.lbavName.setBorder(BorderFactory.createLineBorder(Color.red));
        this.add(this.lbavName);
        this.lbCurrentStatus = new JLabel("\u6b63\u5728\u4e0b\u8f7d...");
        this.lbCurrentStatus.setPreferredSize(new Dimension(200, 45));
        this.lbCurrentStatus.setBorder(BorderFactory.createLineBorder(Color.red));
        this.add(this.lbCurrentStatus);
        this.lbDownFile = new JLabel(this.currentDown + "/" + this.totalSize);
        this.lbDownFile.setPreferredSize(new Dimension(200, 45));
        this.lbDownFile.setBorder(BorderFactory.createLineBorder(Color.red));
        this.add(this.lbDownFile);
        this.setBackground(new Color(204, 255, 255));
        this.btnControl = new MJButton("\u6682\u505c");
        this.btnControl.setPreferredSize(new Dimension(100, 45));
        this.btnControl.addActionListener(this);
        this.add(this.btnControl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block17: {
            if (actionEvent.getSource() == this.btnOpenFolder) {
                File file = new File(this.lbFileName.getText());
                String string = System.getProperty("os.name");
                try {
                    if (file.exists() && string.toLowerCase().startsWith("win")) {
                        String[] stringArray = new String[]{"explorer", "/e,/select,", file.getAbsolutePath()};
                        Runtime.getRuntime().exec(stringArray);
                        break block17;
                    }
                    if (file.exists()) {
                        Desktop desktop = Desktop.getDesktop();
                        desktop.open(file);
                        break block17;
                    }
                    Desktop desktop = Desktop.getDesktop();
                    desktop.open(file.getParentFile());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "\u6253\u5f00\u6587\u4ef6\u5939\u5931\u8d25!", "\u5931\u8d25", 1);
                }
            } else if (actionEvent.getSource() == this.btnOpen) {
                File file = new File(this.lbFileName.getText());
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "\u6253\u5f00\u6587\u4ef6\u5931\u8d25!", "\u5931\u8d25", 1);
                }
            } else if (actionEvent.getSource() == this.btnRemove) {
                if (TabDownload.isStopAll()) {
                    Logger.println("\u505c\u6b62\u4efb\u52a1\u4e2d\uff0c\u8bf7\u8bef\u64cd\u4f5c");
                    return;
                }
                this.removeTask(true);
            } else if (actionEvent.getSource() == this.btnControl) {
                if (TabDownload.isStopAll()) {
                    Logger.println("\u505c\u6b62\u4efb\u52a1\u4e2d\uff0c\u8bf7\u8bef\u64cd\u4f5c");
                    return;
                }
                StatusEnum statusEnum = this.iNeedAV.getDownloader().currentStatus();
                if (statusEnum == StatusEnum.DOWNLOADING) {
                    this.stopTask();
                } else {
                    this.setFailCnt(0);
                    this.continueTask();
                }
            }
        }
    }

    public void initDownloadParams(INeedAV iNeedAV, String string, String string2, String string3, int n) {
        this.iNeedAV = iNeedAV;
        this.avid_qn = string2;
        this.formattedTitle = string3;
        this.url = string;
        this.realqn = n;
        this.lbavName.setText(string3);
        this.lbavName.setToolTipText(string3);
        this.stopOnQueue = false;
    }

    public void stopTask() {
        Downloader downloader = this.iNeedAV.getDownloader();
        downloader.stopTask();
        this.stopOnQueue = true;
    }

    public void continueTask() {
        this.stopOnQueue = false;
        Downloader downloader = this.iNeedAV.getDownloader();
        StatusEnum statusEnum = downloader.currentStatus();
        if (statusEnum != StatusEnum.DOWNLOADING && statusEnum != StatusEnum.SUCCESS && statusEnum != StatusEnum.PROCESSING) {
            downloader.startTask();
            if (!Global.downLoadThreadPool.isShutdown()) {
                Global.downLoadThreadPool.execute(new DownloadRunnableInternal(this, System.currentTimeMillis(), true, this.failCnt));
            }
        }
    }

    public void removeTask(boolean bl) {
        if (bl || this.iNeedAV.getDownloader().currentStatus() == StatusEnum.SUCCESS) {
            this.stopOnQueue = true;
            Global.downloadTaskList.get(this).stopTask();
            Global.downloadTaskList.remove(this);
            Global.downloadTab.getJpContent().remove(this);
            Global.downloadTab.getJpContent().setPreferredSize(new Dimension(1100, 128 * Global.downloadTaskList.size()));
            Global.downloadTab.getJpContent().updateUI();
            Global.downloadTab.getJpContent().repaint();
            File file = new File(this.lbFileName.getText() + ".part");
            if (file.exists()) {
                file.delete();
            }
        }
    }

    public JLabel getLbCurrentStatus() {
        return this.lbCurrentStatus;
    }

    public void setLbCurrentStatus(JLabel jLabel) {
        this.lbCurrentStatus = jLabel;
    }

    public JLabel getLbDownFile() {
        return this.lbDownFile;
    }

    public void setLbDownFile(JLabel jLabel) {
        this.lbDownFile = jLabel;
    }

    public JLabel getLbFileName() {
        return this.lbFileName;
    }

    public void setLbFileName(JLabel jLabel) {
        this.lbFileName = jLabel;
    }

    public JButton getBtnControl() {
        return this.btnControl;
    }

    public void setBtnControl(JButton jButton) {
        this.btnControl = jButton;
    }

    public int hashCode() {
        return (this.avid + this.page).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DownloadInfoPanel) {
            DownloadInfoPanel downloadInfoPanel = (DownloadInfoPanel)object;
            return this.avid.equals(downloadInfoPanel.avid) && this.page == downloadInfoPanel.page;
        }
        return false;
    }

    public long getLastCntTime() {
        return this.lastCntTime;
    }

    public void setLastCntTime(long l) {
        this.lastCntTime = l;
    }

    public long getLastCnt() {
        return this.lastCnt;
    }

    public void setLastCnt(long l) {
        this.lastCnt = l;
    }

    public String getAvid() {
        return this.avid;
    }

    public void setAvid(String string) {
        this.avid = string;
    }

    public String getCid() {
        return this.cid;
    }

    public ClipInfo getClipInfo() {
        return this.clipInfo;
    }

    public int getQn() {
        return this.qn;
    }

    public int getRealqn() {
        return this.realqn;
    }

    public void setRealqn(int n) {
        this.realqn = n;
    }
}

