/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import nicelee.bilibili.annotations.Config;
import nicelee.bilibili.downloaders.IDownloader;
import nicelee.bilibili.enums.DownloadModeEnum;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.net.TrustAllCertSSLUtil;
import nicelee.ui.FrameQRCode;
import nicelee.ui.FrameWaiting;
import nicelee.ui.TabDownload;
import nicelee.ui.TabIndex;
import nicelee.ui.item.DownloadInfoPanel;
import nicelee.ui.thread.DownloadExecutors;

public class Global {
    @Config(key="bilibili.version", defaultValue="v6.40", warning=false)
    public static String version;
    @Config(key="bilibili.time.syncServer", note="\u540c\u6b65\u670d\u52a1\u5668\u7684\u65f6\u95f4", defaultValue="false", valids={"true", "false"})
    public static boolean syncServerTime;
    @Config(key="bilibili.theme", note="\u754c\u9762\u4e3b\u9898", defaultValue="true", eq_true="default", valids={"default", "system"})
    public static boolean themeDefault;
    @Config(key="bilibili.button.style", note="Button\u6837\u5f0f", defaultValue="true", eq_true="design", valids={"design", "default"})
    public static boolean btnStyle;
    @Config(key="bilibili.lockCheck", note="\u9632\u6b62\u591a\u5f00", defaultValue="false", valids={"true", "false"})
    public static boolean lockCheck;
    @Config(key="bilibili.alert.isAlertIfDownloded", note="\u63d0\u4ea4\u5df2\u5b8c\u6210\u7684\u89c6\u9891\u65f6\u662f\u5426\u5f39\u51fa\u63d0\u793a", defaultValue="true", valids={"true", "false"})
    public static boolean isAlertIfDownloded;
    @Config(key="bilibili.alert.maxAlertPrompt", note="\u63d0\u4ea4\u5df2\u5b8c\u6210\u7684\u89c6\u9891\u65f6\u5f39\u51fa\u63d0\u793a\u6846\u7684\u6700\u5927\u6570\u91cf", defaultValue="5")
    public static int maxAlertPrompt;
    @Config(key="bilibili.sysTray.enable", note="\u5f00\u542f\u7cfb\u7edf\u6258\u76d8\u529f\u80fd", defaultValue="true", valids={"true", "false"})
    public static boolean isSysTrayEnabled;
    @Config(key="bilibili.sysTray.minimizeToSystray", note="\u70b9\u51fb\u6700\u5c0f\u5316\u6309\u94ae\u5230\u6258\u76d8", defaultValue="true", valids={"true", "false"})
    public static boolean minimizeToSystray;
    @Config(key="bilibili.sysTray.closeToSystray", note="\u70b9\u51fb\u5173\u95ed\u6309\u94ae\u5230\u6258\u76d8", defaultValue="false", valids={"true", "false"})
    public static boolean closeToSystray;
    @Config(key="bilibili.tab.display.previewPic", note="Tab\u9875\u9762\u81ea\u52a8\u663e\u793a\u4f5c\u54c1\u9884\u89c8\u56fe", defaultValue="on", eq_true="on", valids={"on", "off"})
    public static boolean autoDisplayPreviewPic;
    @Config(key="bilibili.menu.tab.promptBeforeCloseAllTabs", note="\u70b9\u51fb\u3010\u5173\u95ed\u5168\u90e8Tab\u9875\u3011\u540e\uff0c\u5f39\u51fa\u786e\u8ba4\u6846", defaultValue="true", valids={"true", "false"})
    public static boolean promptBeforeCloseAllTabs;
    public static ImageIcon backgroundImg;
    public static FrameWaiting frWaiting;
    public static FrameQRCode qr;
    public static TabIndex index;
    public static final int MP4 = 0;
    public static final int FLV = 1;
    @Config(key="bilibili.download.thumbUp", note="\u4e0b\u8f7d\u5b8c\u6210\u540e\u7ed9\u4f5c\u54c1\u70b9\u8d5e", defaultValue="false", valids={"true", "false"})
    public static volatile boolean thumbUpAfterDownloaded;
    @Config(key="bilibili.download.playSound", note="\u5168\u90e8\u4efb\u52a1\u5b8c\u6210\u540e\u64ad\u653e\u63d0\u793a\u97f3", defaultValue="false", valids={"true", "false"})
    public static boolean playSoundAfterMissionComplete;
    @Config(key="bilibili.download.maxFailRetry", note="\u4e0b\u8f7d\u5931\u8d25\u540e\u91cd\u8bd5\u6b21\u6570", defaultValue="3")
    public static int maxFailRetry;
    @Config(key="bilibili.download.retry.reloadDownloadUrl", note="\u91cd\u8bd5\u65f6\uff0c\u91cd\u65b0\u67e5\u8be2\u4e0b\u8f7d\u94fe\u63a5", defaultValue="false", valids={"true", "false"})
    public static boolean reloadDownloadUrl;
    @Config(key="bilibili.download.urlValidPeriod", note="\u4e0b\u8f7durl\u7684\u6709\u6548\u65f6\u957f(min)", defaultValue="90", multiply=60000)
    public static long urlValidPeriod;
    @Config(key="bilibili.format", defaultValue="0", valids={"0", "1", "2"}, note="\u4f18\u5148\u4e0b\u8f7d\u683c\u5f0f, 0-m4s,1-flv,2-mp4")
    public static int downloadFormat;
    @Config(key="bilibili.dash.download.mode", defaultValue="0", valids={"0", "1", "2"}, note="DASH\u4e0b\u8f7d\u6a21\u5f0f: 0-\u4e0b\u8f7d\u97f3\u89c6\u9891,1-\u4ec5\u89c6\u9891,2-\u4ec5\u97f3\u9891")
    public static DownloadModeEnum downloadMode;
    @Config(key="bilibili.dash.video.codec.priority", defaultValue="7, 12, 13", note="\u89c6\u9891\u7f16\u7801\u4f18\u5148\u7ea7(\u9ed8\u8ba4),AV1:13,HEVC:12,AVC:7,\u968f\u610f-1")
    public static int[] videoCodecPriority;
    @Config(key="bilibili.dash.video.codec.priority.map", defaultValue="80:7, 12, 13| 64:7, 12, 13", note="\u89c6\u9891\u7f16\u7801\u4f18\u5148\u7ea7(\u533a\u5206\u6e05\u6670\u5ea6),AV1:13,HEVC:12,AVC:7,\u968f\u610f-1")
    public static HashMap<Integer, int[]> videoCodecPriorityMap;
    @Config(key="bilibili.dash.audio.quality.priority", defaultValue="30280, 30232, 30216, -1, 30251, 30250", note="\u97f3\u9891\u7f16\u7801\u4f18\u5148\u7ea7,30216:64K, 30232:132K, 30280:192K, \u968f\u610f-1")
    public static int[] audioQualityPriority;
    @Config(key="bilibili.dash.checkUrl", note="\u67e5\u8be2DASH\u65b9\u5f0f\u7684\u4e0b\u8f7d\u94fe\u63a5\u65f6\uff0c\u68c0\u67e5\u94fe\u63a5\u6709\u6548\u6027", defaultValue="false", valids={"true", "false"})
    public static boolean checkDashUrl;
    @Config(key="bilibili.download.forceHttp", note="\u5f3a\u5236\u5c06\u97f3\u89c6\u9891\u4e0b\u8f7d\u5730\u5740\u7684https\u8f6c\u4e3ahttp(PCDN\u9664\u5916)", defaultValue="false", valids={"true", "false"})
    public static boolean forceHttp;
    @Config(key="bilibili.download.host.forceReplace", note="\u5f3a\u5236\u66ff\u6362\u97f3\u89c6\u9891\u4e0b\u8f7d\u670d\u52a1\u5668host", defaultValue="false", valids={"true", "false"})
    public static boolean forceReplaceUposHost;
    @Config(key="bilibili.download.host.forceReplace.pattern", note="\u529f\u80fd\u5f00\u542f\u65f6\uff0c\u5339\u914d\u8be5\u89c4\u5219\u7684\u94fe\u63a5\u4f1a\u88ab\u66ff\u6362host", defaultValue="https?://[^/]+/upgcxcode")
    public static String forceReplaceUrlPattern;
    @Config(key="bilibili.download.host.alternative", note="\u81ea\u5b9a\u4e49\u7684\u4e0b\u8f7d\u670d\u52a1\u5668host", defaultValue="upos-sz-estghw.bilivideo.com")
    public static String altHost;
    @Config(key="bilibili.savePath", note="\u4fdd\u5b58\u8def\u5f84", defaultValue="./download/", pathType="dir")
    public static String savePath;
    @Config(key="bilibili.download.poolSize", note="\u4e0b\u8f7d\u4efb\u52a1\u7ebf\u7a0b\u6c60\u5927\u5c0f", defaultValue="1")
    public static int downloadPoolSize;
    @Config(key="bilibili.download.period.between.download", note="\u6bcf\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u5b8c\u6210\u540e\u7684\u7b49\u5f85\u65f6\u95f4(ms)", defaultValue="0", multiply=1)
    public static long sleepAfterDownloadComplete;
    @Config(key="bilibili.download.period.between.query", note="\u6bcf\u4e2a\u5173\u4e8e\u4e0b\u8f7d\u7684\u67e5\u8be2\u4efb\u52a1\u5b8c\u6210\u540e\u7684\u7b49\u5f85\u65f6\u95f4(ms)", defaultValue="0", multiply=1)
    public static long sleepAfterDownloadQuery;
    public static ExecutorService downLoadThreadPool;
    public static ExecutorService queryThreadPool;
    public static JTabbedPane tabs;
    public static TabDownload downloadTab;
    public static ConcurrentHashMap<DownloadInfoPanel, IDownloader> downloadTaskList;
    @Config(key="bilibili.download.multiThread.count", note="\u5355\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u5f00\u542f\u7ebf\u7a0b\u6570(0,1\u4e3a\u4e0d\u5f00\u542f\u591a\u7ebf\u7a0b)", defaultValue="0")
    public static int multiThreadCnt;
    @Config(key="bilibili.download.multiThread.minFileSize", note="\u6587\u4ef6\u5927\u5c0f\u5c0f\u4e8e\u9608\u503c(\u6574\u6570, \u5355\u4f4dMB)\uff0c\u5219\u4e0d\u5f00\u542f\u591a\u7ebf\u7a0b\u4e0b\u8f7d", defaultValue="0", multiply=0x100000)
    public static long multiThreadMinFileSize;
    @Config(key="bilibili.download.multiThread.singlePattern", note="url\u5339\u914d\u8be5\u6b63\u5219\uff0c\u5219\u4e0d\u5f00\u542f\u591a\u7ebf\u7a0b\u4e0b\u8f7d", defaultValue="github|ffmpeg|\\.jpg|\\.png|\\.webp|\\.xml")
    public static Pattern singleThreadPattern;
    @Config(key="bilibili.repo", note="\u521b\u5efa\u4e0b\u8f7d\u4efb\u52a1\u524d\u5224\u65ad\u662f\u5426\u5df2\u4e0b\u8f7d(\u4f1a\u81ea\u52a8\u4fdd\u5b58\u4e0b\u8f7d\u7684BV\u53f7)", defaultValue="true", eq_true="on", valids={"on", "off"})
    public static boolean useRepo;
    @Config(key="bilibili.repo.save", note="\u5728\u4e0d\u5224\u65ad\u5df2\u4e0b\u8f7d\u65f6\u4ecd\u7136\u4fdd\u5b58\u4e0b\u8f7d\u7684BV\u53f7", defaultValue="true", eq_true="on", valids={"on", "off"})
    public static boolean saveToRepo;
    @Config(key="bilibili.name.format", note="\u81ea\u5b9a\u4e49\u4e0b\u8f7d\u6587\u4ef6\u540d\u79f0", defaultValue="(:listName listName-)avTitle-pDisplay-clipTitle-qn")
    public static String formatStr;
    @Config(key="bilibili.name.format.clipTitle.allowNull", note="\u81ea\u5b9a\u4e49\u4e0b\u8f7d\u540d\u79f0\u65f6\uff0c\u82e5avTitle\u7b49\u4e8eclipTitle\uff0c\u5c06clipTitle\u7f6e\u7a7a", defaultValue="false", eq_true="true", valids={"true", "false"})
    public static boolean ctFormatAllowNull;
    @Config(key="bilibili.name.date.favTime.pattern", note="\u6536\u85cf\u65f6\u95f4\u683c\u5f0f\u5316", defaultValue="yyMMdd")
    public static String favTimeFormat;
    @Config(key="bilibili.name.date.cTime.pattern", note="\u53d1\u5e03/\u66f4\u65b0\u65f6\u95f4\u683c\u5f0f\u5316", defaultValue="yyMMdd")
    public static String cTimeFormat;
    @Config(key="bilibili.name.doAfterComplete", note="\u4e0b\u8f7d\u5b8c\u6210\u540e\u81ea\u52a8\u91cd\u547d\u540d", defaultValue="true", valids={"true", "false"})
    public static boolean doRenameAfterComplete;
    @Config(key="bilibili.name.autoNumber", note="\u9047\u5230\u540c\u540d\u6587\u4ef6\u81ea\u52a8\u6dfb\u52a0\u5e8f\u53f7", defaultValue="true", valids={"true", "false"})
    public static boolean autoNumberWhenFileExists;
    @Config(key="bilibili.repo.definitionStrictMode", note="\u662f\u5426\u5c06\u540c\u4e00\u89c6\u9891\u4e0d\u540c\u6e05\u6670\u5ea6\u770b\u4f5c\u4e0d\u540c\u4efb\u52a1", defaultValue="false", eq_true="on", valids={"on", "off"})
    public static boolean repoInDefinitionStrictMode;
    @Config(key="bilibili.download.push.type", note="\u63a8\u9001\u6d88\u606f\u5668\u7684\u7c7b\u578b", defaultValue="Print")
    public static String msgPushType;
    @Config(key="bilibili.download.push.account", note="\u63a8\u9001\u6d88\u606f\u9700\u8981\u7684\u8d26\u6237", defaultValue="")
    public static String msgPushAccount;
    @Config(key="bilibili.download.push.token", note="\u63a8\u9001\u6d88\u606f\u9700\u8981\u7684\u5bc6\u7801\u6216\u8005\u51ed\u8bc1", defaultValue="")
    public static String msgPushToken;
    @Config(key="bilibili.download.batch.plan", note="\u6309\u8ba1\u5212\u5206\u914d\u6bcf\u6b21\u4e00\u952e\u4e0b\u8f7d\u4efb\u52a1\u4e4b\u95f4\u7684\u95f4\u9694", defaultValue="06:00~02:00=>r(300,480); 02:00~06:00=>~06:00+r(0,360); 00:00~00:00=>r(600,600)")
    public static String batchDownloadPlan;
    @Config(key="bilibili.download.batch.plan.runOnStartup", note="\u5728\u7a0b\u5e8f\u542f\u52a8\u65f6\uff0c\u6309\u8ba1\u5212\u8fdb\u884c\u5468\u671f\u6027\u6279\u91cf\u4e0b\u8f7d", defaultValue="false", valids={"true", "false"})
    public static boolean batchDownloadRbyRRunOnStartup;
    @Config(key="bilibili.download.batch.config.name", note="\u4e00\u952e\u4e0b\u8f7d\u914d\u7f6e\u7684\u9ed8\u8ba4\u540d\u79f0", defaultValue="batchDownload.config")
    public static String batchDownloadConfigName;
    @Config(key="bilibili.download.batch.config.name.pattern", note="\u4e00\u952e\u4e0b\u8f7d\u914d\u7f6e\u540d\u79f0\u7684\u5339\u914d\u6b63\u5219\u8868\u8fbe\u5f0f", defaultValue="^batchDownload.*\\.config$")
    public static Pattern batchDownloadConfigNamePattern;
    @Config(key="bilibili.login.cookie.tryRefreshOnStartup", note="\u6bcf\u6b21\u7a0b\u5e8f\u6253\u5f00\u65f6\u5c1d\u8bd5\u5237\u65b0Cookie", defaultValue="false", valids={"true", "false"})
    public static boolean tryRefreshCookieOnStartup;
    @Config(key="bilibili.login.cookie.refresh.runWASMinBrowser", defaultValue="false", valids={"true", "false"})
    public static boolean runWASMinBrowser;
    @Config(key="bilibili.server.port", note="http server\u76d1\u542c\u7aef\u53e3\uff0c\u7528\u4e8e\u6781\u9a8c\u6821\u9a8c", defaultValue="8787")
    public static int serverPort;
    @Config(key="bilibili.user.userName", defaultValue="", warning=false)
    public static String userName;
    @Config(key="bilibili.user.password", defaultValue="", warning=false)
    public static String password;
    @Config(key="bilibili.user.delete", defaultValue="true", valids={"true", "false"})
    public static boolean deleteUserFile;
    @Config(key="bilibili.user.login", note="\u767b\u5f55\u65b9\u5f0f qr/pwd/sms", defaultValue="qr", valids={"pwd", "qr", "sms"})
    public static String loginType;
    public static boolean needToLogin;
    public static boolean isLogin;
    @Config(key="bilibili.pageSize", note="\u5206\u9875\u67e5\u8be2\u65f6\uff0c\u6bcf\u9875\u663e\u793aav\u4e2a\u6570(\u5355\u4e2aav\u53ef\u80fd\u4e0d\u6b62\u4e00\u4e2a\u89c6\u9891)", defaultValue="5")
    public static int pageSize;
    @Config(key="bilibili.pageDisplay", defaultValue="listAll")
    public static String pageDisplay;
    @Config(key="bilibili.info.query.strategy", note="\u67e5\u8be2\u53ef\u7528\u6e05\u6670\u5ea6\u65f6\uff0c\u4f7f\u7528\u7684\u7b56\u7565", defaultValue="returnFixedValue", valids={"tryNormalTypeFirst", "judgeTypeFirst", "returnFixedValue"})
    public static String infoQueryStrategy;
    @Config(key="bilibili.restrictTempMode", defaultValue="true", eq_true="on", valids={"on", "off"})
    public static boolean restrictTempMode;
    @Config(key="bilibili.download.update.sources", defaultValue="Github")
    public static String updateSourceAvailable;
    @Config(key="bilibili.download.update.sources.active", note="\u751f\u6548\u7684\u66f4\u65b0\u6e90", defaultValue="Github")
    public static String updateSourceActive;
    @Config(key="bilibili.download.ffmpeg.sources", defaultValue="Github")
    public static String ffmpegSourceAvailable;
    @Config(key="bilibili.download.ffmpeg.sources.active", note="\u751f\u6548\u7684ffmpeg\u6e90", defaultValue="Github")
    public static String ffmpegSourceActive;
    @Config(key="bilibili.ffmpegPath", note="ffmpeg\u8def\u5f84", defaultValue="ffmpeg", pathType="file")
    public static String ffmpegPath;
    @Config(key="bilibili.dash.ffmpeg.command.merge", note="ffmpeg\u97f3\u89c6\u9891\u5408\u5e76\u547d\u4ee4", defaultValue="{FFmpeg}, -i, {SavePath}{VideoName}, -i, {SavePath}{AudioName}, -c, copy, {SavePath}{DstName}")
    public static String[] ffmpegCmd4Merge;
    @Config(key="bilibili.dash.ffmpeg.command.transAudioOnly", note="ffmpeg\u97f3\u9891\u8f6c\u6362\u547d\u4ee4", defaultValue="{FFmpeg}, -y, -i, {SavePath}{AudioName}, -vn, -c:a, copy, {SavePath}{DstName}")
    public static String[] ffmpegCmd4AudioOnly;
    @Config(key="bilibili.dash.suffix4AudioOnly", note="\u4ec5\u4e0b\u8f7d\u97f3\u9891\u65f6\u7684\u540e\u7f00\u540d\u79f0(\u5e26.)", defaultValue=".mp4")
    public static String suffix4AudioOnly;
    @Config(key="bilibili.flv.ffmpeg", note="FLV\u5408\u5e76\u65f6\u662f\u5426\u8c03\u7528ffmpeg", defaultValue="false", valids={"true", "false"})
    public static boolean flvUseFFmpeg;
    @Config(key="bilibili.alert.ffmpegFail", note="ffmpeg\u5408\u5e76\u5931\u8d25\u662f\u5426\u629b\u51fa\u5f02\u5e38", defaultValue="true", valids={"true", "false"})
    public static boolean alertIfFFmpegFail;
    @Config(key="bilibili.cmd.debug", note="\u8c03\u7528\u5916\u90e8\u547d\u4ee4\u65f6\u662f\u5426\u663e\u793a\u8f93\u51fa", defaultValue="false", valids={"true", "false"})
    public static boolean debugCmd;
    @Config(key="bilibili.menu.download.plan", defaultValue="1")
    public static int menu_plan;
    @Config(key="bilibili.menu.download.qn", note="\u83dc\u5355\u680f\u4e0b\u8f7d\u65f6\u7684\u4f18\u5148\u6e05\u6670\u5ea6", defaultValue="1080P")
    public static String menu_qn;
    @Config(key="bilibili.tab.download.qn", note="\u6807\u7b7e\u9875\u4e0b\u8f7d\u65f6\u7684\u4f18\u5148\u6e05\u6670\u5ea6", defaultValue="1080P")
    public static String tab_qn;
    @Config(key="bilibili.alert.qualityUnexpected", note="\u5f53\u9047\u5230\u4e0d\u671f\u671b\u7684480P\u89c6\u9891\u65f6\u662f\u5426\u629b\u51fa\u5f02\u5e38", defaultValue="true", valids={"true", "false"})
    public static boolean alertIfQualityUnexpected;
    @Config(key="bilibili.cc.lang", note="CC\u5b57\u5e55\u4f18\u5148\u8bed\u79cd", defaultValue="zh-CN")
    public static String cc_lang;
    @Config(key="proxyHost", note="HTTP/HTTPS\u4ee3\u7406Host", defaultValue="", warning=false)
    private static String proxyHost;
    @Config(key="proxyPort", note="HTTP/HTTPS\u4ee3\u7406Port", defaultValue="", warning=false)
    private static String proxyPort;
    @Config(key="socksProxyHost", note="SOCKS \u4ee3\u7406Host", defaultValue="", warning=false)
    private static String socksProxyHost;
    @Config(key="socksProxyPort", note="SOCKS \u4ee3\u7406Port", defaultValue="", warning=false)
    private static String socksProxyPort;
    @Config(key="bilibili.https.allowInsecure", note="\u8df3\u8fc7\u8bc1\u4e66\u9a8c\u8bc1", defaultValue="false", valids={"true", "false"})
    private static boolean allowInsecure;
    @Config(key="bilibili.userAgent.pc", note="HTTP\u8bf7\u6c42\u4f7f\u7528\u7684UserAgent(PC Web)", defaultValue="Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:93.0) Gecko/20100101 Firefox/93.0")
    public static String userAgent;
    @Config(key="bilibili.userAgent.pc.fingerprint", note="\u6d4f\u89c8\u5668\u6307\u7eb9(\u53d6\u81eacookie buvid_fp)", defaultValue="a8bad806241b0b0f7add1024fbd701fa")
    public static String userAgentFingerprint;
    @Config(key="bilibili.userAgent.pc.payload", note="\u622a\u53d6\u81eaapi\u8bf7\u6c42https://api.bilibili.com/x/internal/gaia-gateway/ExClimbWuzhi", defaultValue="")
    public static String userAgentPayload;
    @Config(key="bilibili.github.token", note="Github API\u9274\u6743token", defaultValue="", warning=false)
    public static String githubToken;
    public static final HashMap<String, String> settings;
    public static final HashSet<String> settingsMustCreateManualy;

    /*
     * WARNING - void declaration
     */
    public static void init() {
        String[] stringArray;
        String[] stringArray2;
        File file;
        void object2;
        Object object = Global.class.getDeclaredFields();
        int n = ((Field[])object).length;
        boolean bl = false;
        while (object2 < n) {
            Field field = object[object2];
            Config config = field.getAnnotation(Config.class);
            if (config != null) {
                String string = settings.get(config.key());
                if (Global.checkValid(string, config.valids())) {
                    Global.setValue(field, string, false, config);
                } else {
                    if (config.warning()) {
                        System.err.printf("%s \u503c\u4e3a %s, \u4e0d\u5728\u5408\u6cd5\u8303\u56f4\u5185 %s, \u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c\n", config.key(), string, Arrays.asList(config.valids()));
                    }
                    Global.setValue(field, config.defaultValue(), true, config);
                }
            }
            ++object2;
        }
        downLoadThreadPool = DownloadExecutors.newPriorityFixedThreadPool(downloadPoolSize);
        object = ResourcesUtil.resolve(savePath);
        if (((String)object).endsWith("\\")) {
            object = ((String)object).substring(0, ((String)object).length() - 1) + "/";
        } else if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        System.out.println("savePath: " + (String)object);
        savePath = object;
        boolean bl2 = saveToRepo = useRepo || saveToRepo;
        if (deleteUserFile && (file = ResourcesUtil.search("config/user.config")) != null) {
            file.delete();
        }
        for (String string : stringArray2 = new String[]{".png", ".jpg"}) {
            stringArray = ResourcesUtil.search("config/background" + string);
            if (stringArray == null) continue;
            backgroundImg = new ImageIcon(stringArray.getPath());
            break;
        }
        if (backgroundImg == null) {
            backgroundImg = new ImageIcon(Global.class.getResource("/resources/background.png"));
        }
        if (proxyHost != null && proxyPort != null) {
            System.setProperty("proxyHost", proxyHost);
            System.setProperty("proxyPort", proxyPort);
        }
        if (socksProxyHost != null && socksProxyPort != null) {
            System.setProperty("socksProxyHost", socksProxyHost);
            System.setProperty("socksProxyPort", socksProxyPort);
        }
        try {
            System.out.println("allowInsecure:" + allowInsecure);
            if (allowInsecure) {
                HttpsURLConnection.setDefaultSSLSocketFactory(TrustAllCertSSLUtil.getFactory());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = "bilibili.system.properties.jre" + System.getProperty("java.specification.version");
        String string2 = settings.get(string);
        if (string2 != null) {
            String string3 = settings.getOrDefault(string + ".override", "false");
            boolean bl3 = "true".equalsIgnoreCase(string3);
            for (String string4 : stringArray = string2.split("-D")) {
                String[] stringArray3 = string4.split("=", 2);
                if (stringArray3.length != 2 || !bl3 && System.getProperty(stringArray3[0]) != null) continue;
                if ("null".equalsIgnoreCase(stringArray3[1].trim())) {
                    System.clearProperty(stringArray3[0]);
                    continue;
                }
                System.setProperty(stringArray3[0], stringArray3[1].trim());
            }
        }
    }

    private static boolean checkValid(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray.length == 0) {
            return true;
        }
        for (String string2 : stringArray) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static void setValue(Field field, String string, boolean bl, Config config) {
        try {
            if (string.contains("\uff0c") || string.contains("\uff1a")) {
                System.err.printf("%s \u914d\u7f6e\u542b\u6709\u975e\u6cd5\u5b57\u7b26\uff0c\u8bf7\u6ce8\u610f\u5168\u534a\u89d2\n", config.key());
            }
            if (field.getType().equals(String.class)) {
                if (bl && string.isEmpty()) {
                    field.set(null, null);
                } else {
                    field.set(null, string);
                }
            } else if (field.getType().equals(String[].class)) {
                String[] stringArray = string.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].trim();
                }
                field.set(null, stringArray);
            } else if (field.getType().equals(HashMap.class)) {
                String[] stringArray = string.split("\\|");
                HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
                for (String string2 : stringArray) {
                    String[] stringArray2 = string2.split(":");
                    Integer n = Integer.parseInt(stringArray2[0].trim());
                    String[] stringArray3 = stringArray2[1].split(",");
                    int[] nArray = new int[stringArray3.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = Integer.parseInt(stringArray3[i].trim());
                    }
                    hashMap.put(n, nArray);
                }
                field.set(null, hashMap);
            } else if (field.getType().equals(int[].class)) {
                String[] stringArray = string.split(",");
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray[i].trim());
                }
                field.set(null, nArray);
            } else if (field.getType().equals(Integer.TYPE) || field.getType().equals(Long.TYPE)) {
                field.set(null, Integer.parseInt(string) * config.multiply());
            } else if (field.getType().equals(Boolean.TYPE)) {
                if (bl) {
                    field.set(null, "true".equalsIgnoreCase(string));
                } else {
                    field.set(null, config.eq_true().equalsIgnoreCase(string));
                }
            } else if (field.getType().equals(Pattern.class)) {
                field.set(null, Pattern.compile(string));
            } else if (field.getType().equals(DownloadModeEnum.class)) {
                int n = Integer.parseInt(string);
                field.set(null, (Object)DownloadModeEnum.getModeEnum(n));
            } else {
                System.err.println(config.key() + " \u914d\u7f6e\u672a\u80fd\u751f\u6548!!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        btnStyle = true;
        lockCheck = false;
        maxAlertPrompt = 5;
        downloadFormat = 0;
        downloadMode = DownloadModeEnum.All;
        videoCodecPriority = new int[]{7, 12, 13};
        audioQualityPriority = new int[]{30280, 30232, 30216, -1};
        checkDashUrl = false;
        forceHttp = false;
        forceReplaceUposHost = false;
        forceReplaceUrlPattern = "^https?://[^/]+/upgcxcode";
        altHost = "upos-sz-mirror08c.bilivideo.com";
        savePath = "./download/";
        queryThreadPool = Executors.newFixedThreadPool(1);
        downloadTaskList = new ConcurrentHashMap();
        doRenameAfterComplete = true;
        autoNumberWhenFileExists = true;
        serverPort = 8787;
        needToLogin = false;
        isLogin = false;
        pageSize = 5;
        pageDisplay = "listAll";
        flvUseFFmpeg = false;
        alertIfFFmpegFail = true;
        userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:93.0) Gecko/20100101 Firefox/93.0";
        userAgentFingerprint = "";
        userAgentPayload = "";
        settings = new LinkedHashMap<String, String>();
        settingsMustCreateManualy = new HashSet();
        settingsMustCreateManualy.add("bilibili.user.delete");
        settingsMustCreateManualy.add("bilibili.menu.download.plan");
        settingsMustCreateManualy.add("bilibili.system.properties.jre11.override");
        settingsMustCreateManualy.add("bilibili.system.properties.jre11");
        settingsMustCreateManualy.add("bilibili.download.update.sources");
        settingsMustCreateManualy.add("bilibili.download.update.patterns.Cloudinary");
        settingsMustCreateManualy.add("bilibili.download.update.patterns.Supabase");
        settingsMustCreateManualy.add("bilibili.download.update.patterns.Twicpics");
        settingsMustCreateManualy.add("bilibili.download.update.patterns.Github");
        settingsMustCreateManualy.add("bilibili.download.update.patterns.Bitbucket");
        settingsMustCreateManualy.add("bilibili.download.ffmpeg.sources");
        settingsMustCreateManualy.add("bilibili.download.ffmpeg.url.Cloudinary");
        settingsMustCreateManualy.add("bilibili.download.ffmpeg.url.Supabase");
        settingsMustCreateManualy.add("bilibili.download.ffmpeg.url.Twicpics");
        settingsMustCreateManualy.add("bilibili.download.ffmpeg.url.Github");
        settingsMustCreateManualy.add("bilibili.download.ffmpeg.url.Bitbucket");
        settingsMustCreateManualy.add("bilibili.download.ffmpeg.url.Imagekit");
        settingsMustCreateManualy.add("bilibili.dash.download.mode");
    }
}

