/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.API;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4UPAllParser", ifLoad="listAll", note="\u4e2a\u4eba\u4e0a\u4f20\u7684\u89c6\u9891\u5217\u8868", weight=69)
public class URL4UPAllParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("space\\.bilibili\\.com/([0-9]+)(/video|/search/video\\?|/? *$|\\?)");
    private static final Pattern patternTid = Pattern.compile("(tid|order|keyword)=([^=&]+)");
    private String spaceID;
    private HashMap<String, String> params;

    public URL4UPAllParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            System.out.println("\u5339\u914dUP\u4e3b\u4e3b\u9875\u5168\u90e8\u89c6\u9891 URL4UPAllParser");
            this.spaceID = this.matcher.group(1);
            this.params = new HashMap();
            this.params.put("tid", "0");
            this.params.put("order", "pubdate");
            this.params.put("keyword", "");
            Matcher matcher = patternTid.matcher(string);
            while (matcher.find()) {
                this.params.put(matcher.group(1), matcher.group(2).trim());
            }
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return string.trim() + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 20;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        int n4 = (Integer)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        try {
            Object object;
            int n5;
            String string = "https://api.bilibili.com/x/space/wbi/arc/search?mid=%s&ps=%d&tid=%s&pn=%d&keyword=%s&order=%s&platform=web";
            String string2 = API.encodeURL(this.params.get("keyword"));
            String string3 = String.format(string, this.spaceID, this.API_PMAX, this.params.get("tid"), n, string2, this.params.get("order"));
            string3 = string3 + API.genDmImgParams();
            string3 = API.encWbi(string3);
            HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders("api.bilibili.com");
            hashMap.put("Referer", "https://space.bilibili.com/");
            hashMap.put("Origin", "https://space.bilibili.com/");
            String string4 = this.util.getContent(string3, hashMap, HttpCookies.globalCookiesWithFingerprint());
            Logger.println(string3);
            Logger.println(string4);
            JSONObject jSONObject = new JSONObject(string4);
            JSONArray jSONArray = jSONObject.getJSONObject("data").getJSONObject("list").getJSONArray("vlist");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                ((VideoInfo)this.pageQueryResult).setVideoId(this.spaceID);
                ((VideoInfo)this.pageQueryResult).setAuthor(jSONArray.getJSONObject(0).getString("author"));
                int n6 = jSONArray.getJSONObject(0).optInt("is_union_video", 0);
                for (n5 = 1; n6 == 1 && n5 < jSONArray.length(); ++n5) {
                    ((VideoInfo)this.pageQueryResult).setAuthor(jSONArray.getJSONObject(n5).getString("author"));
                    n6 = jSONArray.getJSONObject(n5).optInt("is_union_video", 0);
                }
                ((VideoInfo)this.pageQueryResult).setVideoName(((VideoInfo)this.pageQueryResult).getAuthor() + "\u7684\u89c6\u9891\u5217\u8868");
                object = jSONArray.getJSONObject(0).getString("pic");
                if (((String)object).startsWith("//")) {
                    object = "http:" + (String)object;
                }
                ((VideoInfo)this.pageQueryResult).setVideoPreview((String)object);
                ((VideoInfo)this.pageQueryResult).setAuthorId(this.spaceID);
                ((VideoInfo)this.pageQueryResult).setBrief("\u89c6\u9891\u5217\u8868 - " + this.paramSetter.getPage());
            }
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            for (n5 = n2 - 1; n5 < jSONArray.length() && n5 < n3; ++n5) {
                object = jSONArray.getJSONObject(n5);
                String string5 = ((JSONObject)object).optString("jump_url", "");
                if (string5.startsWith("https://www.bilibili.com/cheese/")) continue;
                linkedHashMap.putAll(this.convertVideoToClipMap(((JSONObject)object).getString("bvid"), (n - 1) * this.API_PMAX + n5 + 1, n4, bl));
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private LinkedHashMap<Long, ClipInfo> convertVideoToClipMap(String string, int n, int n2, boolean bl) {
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        VideoInfo videoInfo = this.getAVDetail(string, n2, bl);
        for (ClipInfo clipInfo : videoInfo.getClips().values()) {
            clipInfo.setListName(((VideoInfo)this.pageQueryResult).getVideoName().replaceAll("[/\\\\]", "_"));
            clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
            clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
            clipInfo.setRemark(n);
            linkedHashMap.put(clipInfo.getcId(), clipInfo);
        }
        return linkedHashMap;
    }
}

