/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.downloaders.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.downloaders.IDownloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.ui.Global;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="ClosedCaption-downloader", type="downloader", note="\u5b57\u5e55\u4e0b\u8f7d")
public class CCDownloader
implements IDownloader {
    protected HttpRequestUtil util;
    protected File file = null;
    protected StatusEnum status = StatusEnum.NONE;
    long sumTotalFileSize = 0L;

    @Override
    public boolean matches(String string) {
        return string.contains("subtitle") || string.endsWith(".json");
    }

    @Override
    public boolean download(String string, String string2, int n, int n2) {
        boolean bl;
        this.status = StatusEnum.DOWNLOADING;
        String string3 = String.format("%s-%d-p%d.srt", string2, n, n2);
        if (this.file == null) {
            this.file = new File(Global.savePath, string3);
        }
        if (bl = this.save2srt(string, this.file)) {
            this.status = StatusEnum.SUCCESS;
            this.sumTotalFileSize = this.file.length();
            return true;
        }
        this.status = StatusEnum.FAIL;
        return false;
    }

    @Override
    public void init(HttpRequestUtil httpRequestUtil) {
        this.util = httpRequestUtil;
    }

    @Override
    public void startTask() {
    }

    @Override
    public void stopTask() {
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public StatusEnum currentStatus() {
        return this.status;
    }

    @Override
    public int totalTaskCount() {
        return 1;
    }

    @Override
    public int currentTask() {
        return 1;
    }

    @Override
    public long sumTotalFileSize() {
        return this.sumTotalFileSize;
    }

    @Override
    public long sumDownloadedFileSize() {
        return this.sumTotalFileSize;
    }

    @Override
    public long currentFileDownloadedSize() {
        if (this.file != null && this.file.exists()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public long currentFileTotalSize() {
        if (this.file != null && this.file.exists()) {
            return this.file.length();
        }
        return 0L;
    }

    public boolean save2srt(String string, File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            String string2 = this.util.getContent(string, new HashMap<String, String>());
            JSONArray jSONArray = new JSONObject(string2).getJSONArray("body");
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                bufferedWriter.append("" + i);
                bufferedWriter.newLine();
                bufferedWriter.append(this.formatTime(jSONObject.getDouble("from")));
                bufferedWriter.append(" --> ");
                bufferedWriter.append(this.formatTime(jSONObject.getDouble("to")));
                bufferedWriter.newLine();
                bufferedWriter.append(jSONObject.getString("content"));
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String formatTime(double d) {
        int n = (int)d;
        double d2 = d - (double)n;
        int n2 = n / 60;
        int n3 = n2 / 60;
        return String.format("%02d:%02d:%.2f", n3, n2 %= 60, d2 += (double)(n %= 60));
    }
}

