/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.downloaders.impl;

import java.io.File;
import java.util.HashMap;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.downloaders.impl.FLVDownloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.ui.Global;

@Bilibili(name="AudioDownloader", type="downloader", note="\u97f3\u9891\u4e0b\u8f7d")
public class AudioDownloader
extends FLVDownloader {
    private String format;

    @Override
    public boolean matches(String string) {
        if (string.contains(".m4a")) {
            this.format = "m4a";
            return true;
        }
        if (string.contains(".flac")) {
            this.format = "flac";
            return true;
        }
        return false;
    }

    @Override
    public boolean download(String string, String string2, int n, int n2) {
        this.convertingStatus = StatusEnum.NONE;
        this.currentTask = 1;
        String string3 = String.format("%s-%d-p%d.%s", string2, n, n2, this.format);
        if (this.file == null) {
            this.file = new File(Global.savePath, string3);
        }
        HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders();
        hashMap.put("Accept", "audio/webm,audio/ogg,audio/wav,audio/*;q=0.9,application/ogg;q=0.7,video/*;q=0.6,*/*;q=0.5");
        hashMap.put("Referer", "https://www.bilibili.com/");
        boolean bl = this.util.download(string, string3, hashMap);
        if (bl) {
            this.sumSuccessDownloaded += this.util.getTotalFileSize();
            this.util.reset();
        }
        return bl;
    }
}

