/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.annotations.Controller;
import nicelee.bilibili.plugin.CustomClassLoader;
import nicelee.bilibili.plugin.Plugin;
import nicelee.bilibili.util.ResourcesUtil;

public abstract class PackageScanLoader {
    private ClassLoader classLoader;
    private List<Class<?>> validClazzList;
    public static List<Class<?>> validPusherClasses = new ArrayList();
    public static List<Class<?>> validParserClasses = new ArrayList();
    public static List<Class<?>> validDownloaderClasses = new ArrayList();
    public static List<Class<?>> controllerClazzes;

    private static void loadTargetFolder(Plugin plugin, CustomClassLoader customClassLoader, File file, File file2) {
        if (file2.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "utf-8"));
                String string = bufferedReader.readLine();
                while (string != null) {
                    PackageScanLoader.compileAndLoad(plugin, customClassLoader, string);
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (file.exists()) {
            for (File file3 : file.listFiles()) {
                String string = file3.getName();
                if (!string.endsWith(".java")) continue;
                String string2 = string.substring(0, string.length() - 5);
                PackageScanLoader.compileAndLoad(plugin, customClassLoader, string2);
            }
        }
    }

    private static void compileAndLoad(Plugin plugin, CustomClassLoader customClassLoader, String string) {
        if (plugin.isToCompile(string)) {
            plugin.compile(string);
        }
        try {
            System.out.printf("\u5c1d\u8bd5\u52a0\u8f7d\u81ea\u5b9a\u4e49\u7c7b: %s\r\n", string);
            Class<?> clazz = plugin.loadClass(customClassLoader, string);
            Bilibili bilibili = clazz.getAnnotation(Bilibili.class);
            if (null != bilibili) {
                if ("parser".equals(bilibili.type())) {
                    validParserClasses.add(clazz);
                } else if ("pusher".equals(bilibili.type())) {
                    validPusherClasses.add(clazz);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract boolean isValid(Class<?> var1);

    public List<Class<?>> scanRoot(String string) {
        this.validClazzList = new ArrayList();
        this.classLoader = this.getClass().getClassLoader();
        String string2 = string.replace("\\", "/").replace(".", "/");
        string = string.replace("/", ".");
        try {
            Enumeration<URL> enumeration = this.classLoader.getResources(string2);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                String string3 = uRL.getProtocol();
                if (string3.equals("jar")) {
                    this.dealWithJar(uRL, string2);
                    continue;
                }
                if (string3.equals("file")) {
                    File file = new File(uRL.toURI());
                    if (file.isDirectory()) {
                        this.dealWithFolder(string, file);
                        continue;
                    }
                    if (!file.getName().endsWith(".class")) continue;
                    this.deaWithJavaClazzFile(string, file);
                    continue;
                }
                if (!string3.equals("mem")) continue;
                this.dealWithMemoryJar(uRL, string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return this.validClazzList;
    }

    private void dealWithFolder(String string, File file) {
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    this.dealWithFolder(string + "." + file2.getName(), file2);
                    continue;
                }
                String string2 = file2.getName();
                if (!string2.contains(".class")) continue;
                this.deaWithJavaClazzFile(string, file2);
            }
        } else {
            return;
        }
    }

    private void deaWithJavaClazzFile(String string, File file) {
        int n = file.getName().lastIndexOf(".class");
        String string2 = file.getName().substring(0, n);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string + "." + string2);
            if (this.isValid(clazz)) {
                this.validClazzList.add(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private void dealWithJar(URL uRL, String string) {
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                String string2;
                String string3;
                Class<?> clazz;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class") || !jarEntry.getName().startsWith(string) || !this.isValid(clazz = Class.forName(string3 = (string2 = jarEntry.getName()).substring(0, n = string2.indexOf(".class")).replace("/", ".")))) continue;
                this.validClazzList.add(clazz);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private void dealWithMemoryJar(URL uRL, String string) {
        try {
            JarInputStream jarInputStream = (JarInputStream)uRL.openStream();
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                int n;
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class") || !jarEntry.getName().startsWith(string)) {
                    jarEntry = jarInputStream.getNextJarEntry();
                    continue;
                }
                String string2 = jarEntry.getName();
                String string3 = string2.substring(0, n = string2.indexOf(".class")).replace("/", ".");
                Class<?> clazz = Class.forName(string3, true, this.classLoader);
                if (this.isValid(clazz)) {
                    this.validClazzList.add(clazz);
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
            jarInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    static {
        Plugin plugin = new Plugin("parsers", "nicelee.bilibili.parsers.impl");
        CustomClassLoader customClassLoader = new CustomClassLoader();
        File file = new File(ResourcesUtil.baseDirectory(), "parsers");
        File file2 = new File(file, "parsers.ini");
        PackageScanLoader.loadTargetFolder(plugin, customClassLoader, file, file2);
        Plugin plugin2 = new Plugin("pushers", "nicelee.bilibili.pushers.impl");
        File file3 = new File(ResourcesUtil.baseDirectory(), "pushers");
        File file4 = new File(file3, "pushers.ini");
        PackageScanLoader.loadTargetFolder(plugin2, customClassLoader, file3, file4);
        PackageScanLoader packageScanLoader = new PackageScanLoader(){

            @Override
            public boolean isValid(Class<?> clazz) {
                Bilibili bilibili = clazz.getAnnotation(Bilibili.class);
                if (null != bilibili) {
                    if ("parser".equals(bilibili.type())) {
                        validParserClasses.add(clazz);
                    } else if ("downloader".equals(bilibili.type())) {
                        validDownloaderClasses.add(clazz);
                    } else if ("pusher".equals(bilibili.type())) {
                        validPusherClasses.add(clazz);
                    }
                }
                return false;
            }
        };
        packageScanLoader.scanRoot("nicelee.bilibili");
        Comparator comparator = new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> clazz, Class<?> clazz2) {
                int n = clazz == null ? 0 : clazz.getAnnotation(Bilibili.class).weight();
                int n2 = clazz2 == null ? 0 : clazz2.getAnnotation(Bilibili.class).weight();
                return n2 - n;
            }
        };
        Collections.sort(validPusherClasses, comparator);
        Collections.sort(validParserClasses, comparator);
        Collections.sort(validDownloaderClasses, comparator);
        controllerClazzes = new ArrayList();
        packageScanLoader = new PackageScanLoader(){

            @Override
            public boolean isValid(Class<?> clazz) {
                if (clazz.getAnnotation(Controller.class) != null) {
                    controllerClazzes.add(clazz);
                }
                return true;
            }
        };
        packageScanLoader.scanRoot("nicelee.server.controller");
    }
}

