/*
 * Decompiled with CFR 0.152.
 */
package nicelee.memory.classloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import nicelee.memory.url.MemoryURLHandler;

public class MemoryClassLoader
extends ClassLoader {
    private static boolean DEBUG = false;
    private final ProtectionDomain defaultPd;

    public MemoryClassLoader() {
        this(MemoryClassLoader.class.getProtectionDomain());
    }

    public MemoryClassLoader(ProtectionDomain protectionDomain) {
        this.defaultPd = protectionDomain;
    }

    @Override
    protected URL findResource(String string) {
        if (DEBUG) {
            System.out.printf("findResource: %s%n", string);
        }
        try {
            URL uRL = this.getParent().getResource(string);
            if (uRL == null) {
                if (DEBUG) {
                    System.out.printf("try findResource from mem: %s%n", string);
                }
                String string2 = "mem://file/" + string;
                uRL = new URL(null, string2, new MemoryURLHandler());
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        Object object;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            object = "mem://search/" + string;
            arrayList.add(new URL(null, (String)object, new MemoryURLHandler()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        object = this.getParent().getResources(string);
        while (object.hasMoreElements()) {
            arrayList.add((URL)object.nextElement());
        }
        return Collections.enumeration(arrayList);
    }

    @Override
    protected String findLibrary(String string) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            return this.findMemoryClass(string);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("No such class in memory", iOException);
        }
    }

    private Class<?> findMemoryClass(String string) throws IOException {
        String string2 = "mem://file/" + string.replace('.', '/') + ".class";
        byte[] byArray = this.readAllBytes(new URL(null, string2, new MemoryURLHandler()));
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length, this.defaultPd);
        return clazz;
    }

    private byte[] readAllBytes(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray);
        while (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

