"""
Task Coach - Your friendly task manager
Copyright (C) 2004-2016 Task Coach developers <developers@taskcoach.org>

Task Coach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Coach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from .notebook import Notebook, BookPage, ScrolledBookPage
from .frame import AuiManagedFrameWithDynamicCenterPane
from .dialog import Dialog, NotebookDialog, HTMLDialog, AttachmentSelector
from .itemctrl import Column
from .listctrl import VirtualListCtrl
from .checklistbox import CheckListBox
from .treectrl import CheckTreeCtrl, TreeListCtrl
try:
    from .tcsquaremap import TcSquareMap
except ImportError:
    TcSquareMap = None  # squaremap not installed
from .timeline import Timeline
from .maskedtimectrl import (
    DurationCtrl as MaskedDurationCtrl,
    DurationCtrlVerbose as MaskedDurationCtrlVerbose,
    TimeCtrl as MaskedTimeCtrl,
    TimeWithSecondsCtrl as MaskedTimeWithSecondsCtrl,
    DateCtrl,
    DateComboCustomCtrl,
    DateComboRouterCtrl,
    DateTimeComboCtrl,
    EVT_VALUE_CHANGED,
)
from .textctrl import (
    SingleLineTextCtrl,
    MultiLineTextCtrl,
    StaticTextWithToolTip,
)
from .panel import PanelWithBoxSizer, BoxWithFlexGridSizer, BoxWithBoxSizer
from .searchctrl import SearchCtrl
from .spinctrl import SpinCtrl
from .tooltip import ToolTipMixin, SimpleToolTip
from .dirchooser import DirectoryChooser
from .fontpicker import FontPickerCtrl
from .colourpicker import ColourPickerCtrl
from .iconpicker import IconPicker
from .calendarwidget import Calendar
from .calendarconfig import CalendarConfigDialog
from .password import GetPassword
from .hcalendar import HierarchicalCalendar
from .hcalendarconfig import HierarchicalCalendarConfigDialog
from .numericctrl import NumericCtrl
from .currencyctrl import CurrencyCtrl
from . import masked
from wx.lib import sized_controls
import wx


def _install_dialog_cursor_fix():
    """Prevent cursor seep-through from main window behind dialogs.

    Dialogs with empty areas (no controls) let EVT_SET_CURSOR propagate
    to the parent window, causing sash resize cursors to show through.
    This patch makes all dialogs handle EVT_SET_CURSOR with a standard
    cursor, preventing propagation - same pattern controls use.
    """
    _original_dialog_init = wx.Dialog.__init__

    def _patched_dialog_init(self, *args, **kwargs):
        _original_dialog_init(self, *args, **kwargs)
        self.Bind(wx.EVT_SET_CURSOR, _on_set_cursor_standard)

    def _on_set_cursor_standard(event):
        # Set standard arrow cursor - prevents seep-through from parent
        event.SetCursor(wx.Cursor(wx.CURSOR_ARROW))

    wx.Dialog.__init__ = _patched_dialog_init


_install_dialog_cursor_fix()
