You want to contribute to _metadata-extractor_? Great!

The easiest way to contribute is to provide test images for the [image database]
(https://github.com/drewnoakes/metadata-extractor-images/wiki).

Check the [issues list](https://github.com/drewnoakes/metadata-extractor/issues)
for tasks that need attention. If you have something else in mind, that's great too.
If you want to have your pull request merged, it's probably best to discuss the idea on
the mailing list first.

There are a few simple but important guidelines for pull requests. Code not meeting
these guidelines will need to be amended before being accepted.

* **Keep your commits short and sweet.** Only change one thing at a time, and clearly
  identify the change in the commit message. See the recent project history for an
  idea of what this means.

* **Keep your PRs short and sweet.** If you have several features you wish to contribute,
  split them out into separate PRs.

* **Match the existing code style.** This include things like brace placement, indentation
  (spaces not tabs), naming conventions and so on.
  
* **Use JDK 1.5.** This library has extensive backwards compatibility.
  
* **No 'churn'.** If your IDE changes lots of code automatically, turn that feature off or
  use a more friendly IDE. If you think a wide-sweeping change should be applied to
  the codebase, please discuss that on the mailing list and, if agreed, it will be
  made in a single commit to all code.

* **Run the regression tests.** The process is [described here](https://github.com/drewnoakes/metadata-extractor/wiki/Working-with-test-images).

The goal of these guidelines is to make your contribution clearer to read and review for
all, both now and in the future.
