/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.build.AbstractOrigin$InputStreamOrigin;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.BoundedInputStream$Builder;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream$Builder;

public abstract class IOUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static void checkFromIndexSize(byte[] byArray, int n, int n2) {
        int n3 = Objects.requireNonNull(byArray, "byte array").length;
        if ((n | n2 | n3) >= 0 && n3 - n2 >= n) {
            return;
        }
        Integer n4 = n;
        Integer n5 = n2;
        Integer n6 = n3;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n4;
        objectArray[1] = n5;
        objectArray[2] = n6;
        throw new IndexOutOfBoundsException(String.format("Range [%s, %<s + %s) out of bounds for length %s", objectArray2));
    }

    public static void closeQ(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] toByteArray(InputStream inputStream) {
        int n;
        int n2;
        int n3;
        BoundedInputStream boundedInputStream;
        BoundedInputStream$Builder boundedInputStream$Builder;
        UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream;
        AbstractStreamBuilder abstractStreamBuilder = (UnsynchronizedByteArrayOutputStream$Builder)new UnsynchronizedByteArrayOutputStream$Builder().setBufferSize();
        UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream2 = unsynchronizedByteArrayOutputStream;
        unsynchronizedByteArrayOutputStream = new UnsynchronizedByteArrayOutputStream((UnsynchronizedByteArrayOutputStream$Builder)abstractStreamBuilder);
        abstractStreamBuilder = boundedInputStream$Builder;
        new BoundedInputStream$Builder().maxCount = Math.max(-1L, 0x7FFFFFF8L);
        new BoundedInputStream$Builder().propagateClose = false;
        new BoundedInputStream$Builder().origin = new AbstractOrigin$InputStreamOrigin(inputStream);
        inputStream = boundedInputStream;
        UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream3 = unsynchronizedByteArrayOutputStream2;
        ((BoundedInputStream)inputStream)((BoundedInputStream$Builder)abstractStreamBuilder);
        int n4 = unsynchronizedByteArrayOutputStream3.count - unsynchronizedByteArrayOutputStream2.filledBufferSum;
        byte[] byArray = unsynchronizedByteArrayOutputStream3.currentBuffer;
        int n5 = unsynchronizedByteArrayOutputStream3.currentBuffer.length;
        try {
            n3 = boundedInputStream.read(byArray, n4, n5 - n4);
        }
        catch (Throwable throwable) {
            block19: {
                if (!((BoundedInputStream)inputStream).propagateClose) break block19;
                try {
                    ((BoundedInputStream)inputStream).close$org$apache$commons$io$input$ProxyInputStream();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        while ((n2 = n3) != -1) {
            block18: {
                n4 += n2;
                UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream4 = unsynchronizedByteArrayOutputStream2;
                UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream5 = unsynchronizedByteArrayOutputStream4;
                UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream6 = unsynchronizedByteArrayOutputStream4;
                int n6 = unsynchronizedByteArrayOutputStream4.count;
                unsynchronizedByteArrayOutputStream6.count = n6 + n2;
                byte[] byArray2 = unsynchronizedByteArrayOutputStream5.currentBuffer;
                if (n4 != unsynchronizedByteArrayOutputStream5.currentBuffer.length) break block18;
                unsynchronizedByteArrayOutputStream2.needNewBuffer(byArray2.length);
                n4 = 0;
            }
            InputStream inputStream2 = inputStream;
            byte[] byArray3 = unsynchronizedByteArrayOutputStream2.currentBuffer;
            int n7 = unsynchronizedByteArrayOutputStream2.currentBuffer.length;
            n3 = ((BoundedInputStream)inputStream2).read(byArray3, n4, n7 - n4);
        }
        if (((BoundedInputStream)inputStream).propagateClose) {
            ((BoundedInputStream)inputStream).close$org$apache$commons$io$input$ProxyInputStream();
        }
        if ((n = unsynchronizedByteArrayOutputStream2.count) <= 0x7FFFFFF7) {
            if (n == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] byArray4 = new byte[n];
            int n8 = 0;
            Iterator iterator = unsynchronizedByteArrayOutputStream2.buffers.iterator();
            while (iterator.hasNext()) {
                int n9 = n;
                byte[] byArray5 = (byte[])iterator.next();
                n = Math.min(byArray5.length, n);
                System.arraycopy(byArray5, 0, byArray4, n8, n);
                n8 += n;
                if ((n = n9 - n) != 0) continue;
            }
            return byArray4;
        }
        Integer n10 = 0x7FFFFFF7;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n10;
        throw new IOException(String.format("Cannot read more than %,d into a byte array", objectArray2));
    }

    static {
        System.lineSeparator();
        ((Object)((Object)StandardLineSeparator.LF)).getClass();
        ((Object)((Object)StandardLineSeparator.CRLF)).getClass();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[8192];
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
        }
    }
}

