/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators$ArrayItr;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.Spliterators;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class RegularImmutableList
extends ImmutableList {
    public static final RegularImmutableList EMPTY = new RegularImmutableList(new Object[0]);
    public final transient Object[] array;

    public RegularImmutableList(Object[] objectArray) {
        this.array = objectArray;
    }

    @Override
    public final int size() {
        return this.array.length;
    }

    @Override
    public final boolean isPartialView() {
        return false;
    }

    @Override
    public final Object[] internalArray() {
        return this.array;
    }

    @Override
    public final int internalArrayStart() {
        return 0;
    }

    @Override
    public final int internalArrayEnd() {
        return this.array.length;
    }

    @Override
    public final int copyIntoArray(Object[] objectArray) {
        RegularImmutableList regularImmutableList = this;
        int n = regularImmutableList.array.length;
        System.arraycopy(regularImmutableList.array, 0, objectArray, 0, n);
        return regularImmutableList.array.length;
    }

    public final Object get(int n) {
        return this.array[n];
    }

    @Override
    public final AbstractIndexedListIterator listIterator(int n) {
        Object[] objectArray = objectArray.array;
        if (objectArray.array.length == 0) {
            Preconditions.checkPositionIndex(n, objectArray.length);
            return Iterators$ArrayItr.EMPTY;
        }
        return new Iterators$ArrayItr(objectArray, n);
    }

    @Override
    public final Spliterator spliterator() {
        return Spliterators.spliterator(this.array, 1296);
    }

    @Override
    public final ListIterator listIterator(int n) {
        Object[] objectArray = objectArray.array;
        if (objectArray.array.length == 0) {
            Preconditions.checkPositionIndex(n, objectArray.length);
            return Iterators$ArrayItr.EMPTY;
        }
        return new Iterators$ArrayItr(objectArray, n);
    }
}

