/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.instruction;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.instruction.DexBackedArrayPayload$1;
import com.android.tools.smali.dexlib2.dexbacked.instruction.DexBackedArrayPayload$2;
import com.android.tools.smali.dexlib2.dexbacked.instruction.DexBackedArrayPayload$3;
import com.android.tools.smali.dexlib2.dexbacked.instruction.DexBackedArrayPayload$4;
import com.android.tools.smali.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.formats.ArrayPayload;
import com.android.tools.smali.util.ExceptionWithContext;
import java.util.Collections;
import java.util.List;

public final class DexBackedArrayPayload
extends DexBackedInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    public final int elementWidth;
    public final int elementCount;

    public DexBackedArrayPayload(DexBackedDexFile dexBackedDexFile, int n) {
        super(dexBackedDexFile, OPCODE, n);
        int n2;
        int n3 = dexBackedDexFile.dataBuffer.readUshort(n + 2);
        if (n3 == 0) {
            DexBackedArrayPayload dexBackedArrayPayload = this;
            dexBackedArrayPayload.elementWidth = 1;
            dexBackedArrayPayload.elementCount = 0;
            return;
        }
        this.elementWidth = n3;
        this.elementCount = n2 = dexBackedDexFile.dataBuffer.readSmallUint(n + 4);
        if ((long)n3 * (long)n2 <= Integer.MAX_VALUE) {
            return;
        }
        Object[] objectArray = new Object[]{};
        throw new ExceptionWithContext(null, "Invalid array-payload instruction: element width*count overflows", objectArray);
    }

    @Override
    public final int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    public final List getArrayElements() {
        DexBackedArrayPayload dexBackedArrayPayload = n3;
        int n = dexBackedArrayPayload.instructionStart + 8;
        if (dexBackedArrayPayload.elementCount == 0) {
            return Collections.EMPTY_LIST;
        }
        int n2 = ((DexBackedArrayPayload)((Object)n3)).elementWidth;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    if (n2 == 8) {
                        return new DexBackedArrayPayload$4((DexBackedArrayPayload)((Object)n3), n);
                    }
                    Integer n3 = n2;
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = n3;
                    throw new ExceptionWithContext(null, "Invalid element width: %d", objectArray2);
                }
                return new DexBackedArrayPayload$3((DexBackedArrayPayload)((Object)n3), n);
            }
            return new DexBackedArrayPayload$2((DexBackedArrayPayload)((Object)n3), n);
        }
        return new DexBackedArrayPayload$1((DexBackedArrayPayload)((Object)n3), n);
    }

    @Override
    public final int getCodeUnits() {
        return (this.elementWidth * this.elementCount + 1) / 2 + 4;
    }
}

