/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public final class BinaryDataInputStream
extends FilterInputStream
implements DataInput {
    public final ByteOrder mByteOrder;
    public final long mLimit;
    public long mPosition;
    public long mMark;

    public final String readUtf16(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (true) {
            char c;
            int n3 = n;
            n = n3 + -1;
            if (n3 <= 0 || (c = (char)this.readUnsignedShort()) == '\u0000') break;
            int n4 = n2 + 1;
            cArray[n2] = c;
            n2 = n4;
        }
        if (n > 0) {
            this.skip(n * 2);
        }
        return new String(cArray, 0, n2);
    }

    @Override
    public final void readFully(byte[] byArray) {
        int n = byArray.length;
        ByteStreams.readFully(this, byArray, 0, n);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) {
        ByteStreams.readFully(this, byArray, n, n2);
    }

    @Override
    public final int skipBytes(int n) {
        return (int)this.skip(n);
    }

    @Override
    public final boolean readBoolean() {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public final byte readByte() {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public final int readUnsignedByte() {
        int n = this.read();
        if (n != -1) {
            return n;
        }
        throw new EOFException();
    }

    @Override
    public final short readShort() {
        return (short)this.readUnsignedShort();
    }

    @Override
    public final int readUnsignedShort() {
        BinaryDataInputStream binaryDataInputStream = this;
        byte by = (byte)binaryDataInputStream.readUnsignedByte();
        byte by2 = (byte)binaryDataInputStream.readUnsignedByte();
        if (binaryDataInputStream.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
            return Ints.fromBytes((byte)0, (byte)0, by2, by);
        }
        return Ints.fromBytes(by, by2, (byte)0, (byte)0);
    }

    @Override
    public final char readChar() {
        return (char)this.readUnsignedShort();
    }

    @Override
    public final int readInt() {
        BinaryDataInputStream binaryDataInputStream = this;
        byte by = (byte)binaryDataInputStream.readUnsignedByte();
        byte by2 = (byte)binaryDataInputStream.readUnsignedByte();
        byte by3 = (byte)binaryDataInputStream.readUnsignedByte();
        byte by4 = (byte)binaryDataInputStream.readUnsignedByte();
        if (binaryDataInputStream.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
            return Ints.fromBytes(by4, by3, by2, by);
        }
        return Ints.fromBytes(by, by2, by3, by4);
    }

    @Override
    public final long readLong() {
        BinaryDataInputStream binaryDataInputStream = this;
        byte by = (byte)binaryDataInputStream.readUnsignedByte();
        byte by2 = (byte)binaryDataInputStream.readUnsignedByte();
        byte by3 = (byte)binaryDataInputStream.readUnsignedByte();
        byte by4 = (byte)binaryDataInputStream.readUnsignedByte();
        byte by5 = (byte)binaryDataInputStream.readUnsignedByte();
        byte by6 = (byte)binaryDataInputStream.readUnsignedByte();
        byte by7 = (byte)binaryDataInputStream.readUnsignedByte();
        byte by8 = (byte)binaryDataInputStream.readUnsignedByte();
        if (binaryDataInputStream.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
            return Longs.fromBytes(by8, by7, by6, by5, by4, by3, by2, by);
        }
        return Longs.fromBytes(by, by2, by3, by4, by5, by6, by7, by8);
    }

    @Override
    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String readUTF() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int read() {
        if (this.mLimit - this.mPosition == 0L) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            ++this.mPosition;
            return n;
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) {
        int n3;
        long l = this.mLimit - this.mPosition;
        if (l == 0L) {
            return -1;
        }
        if ((long)n2 > l) {
            n2 = (int)l;
        }
        if ((n3 = this.in.read(byArray, n, n2)) > 0) {
            this.mPosition += (long)n3;
            return n3;
        }
        return n3;
    }

    @Override
    public final long skip(long l) {
        long l2;
        long l3 = this.mLimit - this.mPosition;
        if (l3 == 0L) {
            return 0L;
        }
        if (l > l3) {
            l = l3;
        }
        for (l3 = 0L; l3 < l && (l2 = this.in.skip(l - l3)) > 0L; l3 += l2) {
        }
        this.mPosition += l3;
        return l3;
    }

    @Override
    public final int available() {
        return (int)Math.min((long)this.in.available(), this.mLimit - this.mPosition);
    }

    @Override
    public final synchronized void mark(int n) {
        BinaryDataInputStream binaryDataInputStream = this;
        binaryDataInputStream.in.mark(n);
        binaryDataInputStream.mMark = binaryDataInputStream.mPosition;
    }

    @Override
    public final synchronized void reset() {
        if (((InputStream)this).markSupported()) {
            if (this.mMark != -1L) {
                BinaryDataInputStream binaryDataInputStream = this;
                binaryDataInputStream.in.reset();
                binaryDataInputStream.mPosition = binaryDataInputStream.mMark;
                return;
            }
            throw new IOException("Mark not set");
        }
        throw new IOException("Mark not supported");
    }

    public final void jumpTo(long l) {
        StringBuilder stringBuilder;
        long l2 = ((BinaryDataInputStream)this).mPosition;
        long l3 = l - l2;
        if (l3 == 0L) {
            return;
        }
        if (l3 >= 0L) {
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3;
            long l4 = ((BinaryDataInputStream)this).skip(l3);
            if (l4 == l3) {
                return;
            }
            StringBuilder stringBuilder4 = stringBuilder3 = stringBuilder2;
            stringBuilder3("Jump failed: skipped ");
            stringBuilder4.append(l4);
            stringBuilder4.append(" bytes (expected: ");
            stringBuilder2.append(l3);
            stringBuilder2.append(")");
            throw new IOException(stringBuilder2.toString());
        }
        Object object = this = stringBuilder;
        ((StringBuilder)this)("Illegal backwards jump from ");
        ((StringBuilder)object).append(l2);
        ((StringBuilder)object).append(" to ");
        stringBuilder.append(l);
        throw new IOException(stringBuilder.toString());
    }

    public BinaryDataInputStream(InputStream inputStream, ByteOrder byteOrder, long l) {
        super(inputStream);
        this.mByteOrder = byteOrder;
        this.mLimit = l;
        this.mMark = -1L;
    }

    public BinaryDataInputStream(byte[] byArray) {
        BinaryDataInputStream binaryDataInputStream = byteOrder;
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        long l = byArray.length;
        binaryDataInputStream(new ByteArrayInputStream(byArray), byteOrder, l);
    }
}

