/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.res.table.ResConfig;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResAttribute;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResStyle$Item;
import brut.androlib.res.table.value.ResValue;
import brut.androlib.res.xml.ResXmlSerializer;
import brut.common.Log;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Level;

public final class ResStyle
extends ResBag {
    public static final String TAG = ResStyle.class.getName();
    public final ResStyle$Item[] mItems;

    public ResStyle(ResReference resReference, ResStyle$Item[] resStyle$ItemArray) {
        super(resReference);
        this.mItems = resStyle$ItemArray;
    }

    @Override
    public final void resolveKeys() {
        ResPackage resPackage = resStyle$ItemArray.mParent.mPackage;
        boolean bl = resPackage.mGroup.mTable.mConfig.mDecodeResolve == 3;
        ResStyle$Item[] resStyle$ItemArray = resStyle$ItemArray.mItems;
        int n = resStyle$ItemArray.mItems.length;
        for (int i = 0; i < n; ++i) {
            Object object = resStyle$ItemArray[i];
            ResReference resReference = ((ResStyle$Item)object).mKey;
            if (resReference.resolveEntry() != null) continue;
            Object object2 = resReference.mResId;
            if (!bl && ((ResId)object2).pkgId() == resPackage.mGroup.mId) {
                Object object3 = object2;
                int n2 = ((ResId)object3).typeId();
                int n3 = ((ResId)object3).mId & 0xFFFF;
                resPackage.addEntrySpec("APKTOOL_DUMMY_" + object2, n2, n3);
                resPackage.addEntry(((ResId)object2).typeId(), ((ResId)object2).mId & 0xFFFF, ResConfig.DEFAULT, ResAttribute.DEFAULT);
                continue;
            }
            ResStyle$Item resStyle$Item = object;
            object = TAG;
            object2 = resStyle$Item.mValue;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = resReference;
            objectArray[1] = object2;
            Log.log(Level.WARNING, (String)object, "Unresolved style reference: key=%s, value=%s", objectArray2);
        }
    }

    @Override
    public final void serializeToValuesXml(ResXmlSerializer resXmlSerializer, ResEntry object) {
        HashSet hashSet;
        String string = "style";
        resXmlSerializer.startTag(null, string);
        Object object2 = ((ResEntry)object).mSpec.mName;
        resXmlSerializer.attribute(null, "name", (String)object2);
        if (((ResBag)((Object)resPackage)).mParent.resolve() != null) {
            object = ((ResBag)((Object)resPackage)).mParent.toXmlTextValue();
            resXmlSerializer.attribute(null, "parent", (String)object);
        } else if (((ResEntry)object).mSpec.mName.indexOf(46) != -1) {
            resXmlSerializer.attribute(null, "parent", "");
        }
        ResStyle resStyle = resPackage;
        ResPackage resPackage = resStyle.mParent.mPackage;
        boolean bl = resPackage.mGroup.mTable.mConfig.mAnalysisMode;
        object2 = hashSet;
        hashSet = new HashSet();
        ResStyle$Item[] resStyle$ItemArray = resStyle.mItems;
        int n = resStyle.mItems.length;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder;
            Object object3 = resStyle$ItemArray[i];
            Object object4 = ((ResStyle$Item)object3).mKey;
            Object object5 = ((ResReference)object4).resolveEntry();
            if (object5 == null) continue;
            object4 = ((ResReference)object4).mResId;
            if (!bl && ((HashSet)object2).contains(object4)) continue;
            ((HashSet)object2).add(object4);
            object4 = stringBuilder;
            stringBuilder = new StringBuilder();
            Object object6 = resPackage.mGroup != ((ResEntry)object5).mType.mSpec.mPackage.mGroup ? ((ResEntry)object5).mType.mSpec.mPackage.mGroup.mName.concat(":") : "";
            ResStyle$Item resStyle$Item = object3;
            object3 = ((StringBuilder)object4).append((String)object6).append(((ResEntry)object5).mSpec.mName).toString();
            object4 = resStyle$Item.mValue;
            object6 = ((ResEntry)object5).mValue;
            if (object6 instanceof ResAttribute) {
                object4 = ((ResAttribute)object6).formatValue((ResItem)object4, false);
            } else {
                object5 = "Unexpected style item key: " + object5;
                Log.log(Level.WARNING, TAG, (String)object5);
                object4 = ResAttribute.DEFAULT.formatValue((ResItem)object4, false);
            }
            ResXmlSerializer resXmlSerializer2 = resXmlSerializer;
            resXmlSerializer2.startTag(null, "item");
            resXmlSerializer2.attribute(null, "name", (String)object3);
            resXmlSerializer2.text((String)object4);
            resXmlSerializer2.endTag(null, "item");
        }
        resXmlSerializer.endTag(null, string);
    }

    public final String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        ResStyle resStyle = resValue;
        ResValue resValue = resStyle.mParent;
        String string = Arrays.toString(resStyle.mItems);
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        stringBuilder2("ResStyle{parent=");
        stringBuilder3.append(resValue);
        stringBuilder3.append(", items=");
        stringBuilder.append(string);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ResStyle) {
            object = (ResStyle)object;
            return this.mParent.equals(((ResBag)object).mParent) && Arrays.equals(this.mItems, ((ResStyle)object).mItems);
        }
        return false;
    }

    public final int hashCode() {
        ResStyle resStyle = resValue;
        ResValue resValue = resStyle.mParent;
        Integer n = Arrays.hashCode(resStyle.mItems);
        return Objects.hash(resValue, n);
    }
}

