/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResTypeSpec;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.xml.ResXmlSerializer;
import java.util.Objects;

public final class ResReference
extends ResItem {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final ResPackage mPackage;
    public final ResId mResId;
    public final boolean mAsAttr;

    public ResReference(ResPackage resPackage, ResId resId, boolean bl) {
        int n = bl ? 2 : 1;
        super(n);
        if (!($assertionsDisabled || resPackage != null && resId != null)) {
            throw new AssertionError();
        }
        ResReference resReference = this;
        resReference.mPackage = resPackage;
        resReference.mResId = resId;
        resReference.mAsAttr = bl;
    }

    static {
        $assertionsDisabled = ResReference.class.desiredAssertionStatus() ^ true;
    }

    public final ResEntrySpec resolve() {
        ResId resId;
        if (this.mPackage != null && (resId = this.mResId) != ResId.NULL) {
            int n;
            if (resId.pkgId() == 0 && (n = this.mPackage.mGroup.mId) != 0) {
                resId = ResId.of(n, resId.typeId(), resId.mId & 0xFFFF);
            }
            try {
                return this.mPackage.mGroup.mTable.resolve(resId);
            }
            catch (UndefinedResObjectException undefinedResObjectException) {}
        }
        return null;
    }

    public final ResEntry resolveEntry() {
        ResId resId;
        if (this.mPackage != null && (resId = this.mResId) != ResId.NULL) {
            int n;
            if (resId.pkgId() == 0 && (n = this.mPackage.mGroup.mId) != 0) {
                resId = ResId.of(n, resId.typeId(), resId.mId & 0xFFFF);
            }
            try {
                return this.mPackage.mGroup.mTable.resolveEntry(resId);
            }
            catch (UndefinedResObjectException undefinedResObjectException) {}
        }
        return null;
    }

    @Override
    public final String toXmlTextValue() {
        StringBuilder stringBuilder;
        ResEntrySpec resEntrySpec = ((ResReference)object).resolve();
        if (resEntrySpec == null) {
            return "@null";
        }
        ResTypeSpec resTypeSpec = resEntrySpec.mTypeSpec;
        boolean bl = ((ResReference)object).mPackage.mGroup != resTypeSpec.mPackage.mGroup;
        boolean bl2 = !((ResReference)object).mAsAttr || !resTypeSpec.mName.equals("attr");
        ResReference resReference = object;
        Object object = stringBuilder;
        stringBuilder = new StringBuilder();
        String string = resReference.mAsAttr ? "?" : "@";
        object = ((StringBuilder)object).append(string);
        String string2 = bl ? resEntrySpec.mTypeSpec.mPackage.mGroup.mName.concat(":") : "";
        object = ((StringBuilder)object).append(string2);
        String string3 = bl2 ? resEntrySpec.mTypeSpec.mName + "/" : "";
        return ((StringBuilder)object).append(string3).append(resEntrySpec.mName).toString();
    }

    @Override
    public final void serializeToValuesXml(ResXmlSerializer resXmlSerializer, ResEntry object) {
        String string = ((ResEntry)object).mType.mSpec.mName;
        string.getClass();
        int n = -1;
        switch (string.hashCode()) {
            default: {
                break;
            }
            case 109780401: {
                if (!string.equals("style")) break;
                n = 4;
                break;
            }
            case 93090393: {
                if (!string.equals("array")) break;
                n = 3;
                break;
            }
            case 3004913: {
                if (!string.equals("attr")) break;
                n = 2;
                break;
            }
            case -475309713: {
                if (!string.equals("plurals")) break;
                n = 1;
                break;
            }
            case -576469755: {
                if (!string.equals("^attr-private")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                n = 0;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n = 1;
            }
        }
        boolean bl = this.resolve() != null || string.equals("string");
        String string2 = n != 0 ? "item" : string;
        resXmlSerializer.startTag(null, string2);
        if (n != 0) {
            resXmlSerializer.attribute(null, "type", string);
        }
        object = ((ResEntry)object).mSpec.mName;
        resXmlSerializer.attribute(null, "name", (String)object);
        if (bl) {
            resXmlSerializer.text(this.toXmlTextValue());
        }
        resXmlSerializer.endTag(null, string2);
    }

    public final String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        ResReference resReference = resPackage;
        ResPackage resPackage = resReference.mPackage;
        ResId resId = resReference.mResId;
        String string = resReference.mAsAttr ? "attr" : "ref";
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder2("ResReference{pkg=");
        stringBuilder4.append(resPackage);
        stringBuilder4.append(", id=");
        stringBuilder3.append(resId);
        stringBuilder3.append(", type=");
        stringBuilder.append(string);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ResReference) {
            object = (ResReference)object;
            return this.mPackage.equals(((ResReference)object).mPackage) && this.mResId == ((ResReference)object).mResId && this.mAsAttr == ((ResReference)object).mAsAttr;
        }
        return false;
    }

    public final int hashCode() {
        ResReference resReference = resPackage;
        ResPackage resPackage = resReference.mPackage;
        ResId resId = resReference.mResId;
        Boolean bl = resReference.mAsAttr;
        return Objects.hash(resPackage, resId, bl);
    }
}

