/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.xml.ResXmlSerializer;
import brut.common.Log;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;

public final class ResPrimitive
extends ResItem {
    public static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    public static final ResPrimitive NULL = new ResPrimitive(0, 0);
    public static final ResPrimitive EMPTY = new ResPrimitive(0, 1);
    public final int mData;

    public ResPrimitive(int n, int n2) {
        super(n);
        this.mData = n2;
    }

    @Override
    public final String toXmlTextValue() {
        int n = ((ResItem)object).mType;
        if (n != 0) {
            if (n != 18) {
                switch (n) {
                    default: {
                        Object object;
                        if (n >= 28 && n <= 31) {
                            switch (n) {
                                default: {
                                    object = ((ResPrimitive)object).mData;
                                    Object[] objectArray = new Object[1];
                                    Object[] objectArray2 = objectArray;
                                    objectArray[0] = object;
                                    return String.format("#%08x", objectArray2);
                                }
                                case 31: {
                                    ResPrimitive resPrimitive = object;
                                    object = resPrimitive.mData >>> 20 & 0xF;
                                    Integer n2 = resPrimitive.mData >>> 12 & 0xF;
                                    Integer n3 = resPrimitive.mData >>> 4 & 0xF;
                                    Object[] objectArray = new Object[3];
                                    Object[] objectArray3 = objectArray;
                                    objectArray[0] = object;
                                    objectArray[1] = n2;
                                    objectArray[2] = n3;
                                    return String.format("#%x%x%x", objectArray3);
                                }
                                case 30: {
                                    ResPrimitive resPrimitive = object;
                                    object = resPrimitive.mData >>> 28 & 0xF;
                                    Integer n4 = resPrimitive.mData >>> 20 & 0xF;
                                    Integer n5 = resPrimitive.mData >>> 12 & 0xF;
                                    Integer n6 = resPrimitive.mData >>> 4 & 0xF;
                                    Object[] objectArray = new Object[4];
                                    Object[] objectArray4 = objectArray;
                                    objectArray[0] = object;
                                    objectArray[1] = n4;
                                    objectArray[2] = n5;
                                    objectArray[3] = n6;
                                    return String.format("#%x%x%x%x", objectArray4);
                                }
                                case 29: 
                            }
                            object = ((ResPrimitive)object).mData & 0xFFFFFF;
                            Object[] objectArray = new Object[1];
                            Object[] objectArray5 = objectArray;
                            objectArray[0] = object;
                            return String.format("#%06x", objectArray5);
                        }
                        if (n >= 16 && n <= 31) {
                            int n7 = ((ResPrimitive)object).mData;
                            if (n != 17) {
                                return Integer.toString(n7);
                            }
                            Integer n8 = n7;
                            Object[] objectArray = new Object[1];
                            Object[] objectArray6 = objectArray;
                            objectArray[0] = n8;
                            return String.format("0x%x", objectArray6);
                        }
                        object = n;
                        Object[] objectArray = new Object[1];
                        Object[] objectArray7 = objectArray;
                        objectArray[0] = object;
                        Log.log(Level.WARNING, "brut.androlib.res.table.value.ResPrimitive", "Unexpected value type: 0x%02x", objectArray7);
                        return "";
                    }
                    case 6: {
                        Object object;
                        n = ((ResPrimitive)object).mData;
                        float f = (float)(n & 0xFFFFFF00) * RADIX_MULTS[n >> 4 & 3] * 100.0f;
                        if (f == (float)((long)f)) {
                            object = Float.valueOf(f);
                            Object[] objectArray = new Object[1];
                            Object[] objectArray8 = objectArray;
                            objectArray[0] = object;
                            object = String.format(Locale.ROOT, "%.1f", objectArray8);
                        } else {
                            object = Float.toString(f);
                        }
                        int n9 = ((ResPrimitive)object).mData & 0xF;
                        if (n9 != 0) {
                            if (n9 != 1) {
                                String string = "Unexpected value unit: " + n9;
                                Log.log(Level.WARNING, "brut.androlib.res.table.value.ResPrimitive", string);
                                return (String)object + "??";
                            }
                            return (String)object + "%p";
                        }
                        return (String)object + "%";
                    }
                    case 5: {
                        Object object;
                        n = ((ResPrimitive)object).mData;
                        float f = (float)(n & 0xFFFFFF00) * RADIX_MULTS[n >> 4 & 3];
                        if (f == (float)((long)f)) {
                            object = Float.valueOf(f);
                            Object[] objectArray = new Object[1];
                            Object[] objectArray9 = objectArray;
                            objectArray[0] = object;
                            object = String.format(Locale.ROOT, "%.1f", objectArray9);
                        } else {
                            object = Float.toString(f);
                        }
                        int n10 = ((ResPrimitive)object).mData & 0xF;
                        switch (n10) {
                            default: {
                                String string = "Unexpected value unit: " + n10;
                                Log.log(Level.WARNING, "brut.androlib.res.table.value.ResPrimitive", string);
                                return (String)object + "??";
                            }
                            case 5: {
                                return (String)object + "mm";
                            }
                            case 4: {
                                return (String)object + "in";
                            }
                            case 3: {
                                return (String)object + "pt";
                            }
                            case 2: {
                                return (String)object + "sp";
                            }
                            case 1: {
                                return (String)object + "dp";
                            }
                            case 0: 
                        }
                        return (String)object + "px";
                    }
                    case 4: 
                }
                float f = Float.intBitsToFloat(((ResPrimitive)object).mData);
                if (f == (float)((long)f)) {
                    Float f2 = Float.valueOf(f);
                    Object[] objectArray = new Object[1];
                    Object[] objectArray10 = objectArray;
                    objectArray[0] = f2;
                    return String.format(Locale.ROOT, "%.1f", objectArray10);
                }
                return Float.toString(f);
            }
            if (((ResPrimitive)object).mData != 0) {
                return "true";
            }
            return "false";
        }
        if (((ResPrimitive)object).mData == 1) {
            return "@empty";
        }
        return "@null";
    }

    @Override
    public final void serializeToValuesXml(ResXmlSerializer resXmlSerializer, ResEntry object) {
        String string = ((ResEntry)object).mType.mSpec.mName;
        Set set = (Set)ResItem.STANDARD_TYPE_FORMATS.get(string);
        String string2 = set != null ? this.getFormat() : null;
        boolean bl = string2 != null && !set.contains(string2);
        String string3 = bl ? "item" : string;
        resXmlSerializer.startTag(null, string3);
        if (bl) {
            resXmlSerializer.attribute(null, "type", string);
        }
        object = ((ResEntry)object).mSpec.mName;
        resXmlSerializer.attribute(null, "name", (String)object);
        if (bl) {
            resXmlSerializer.attribute(null, "format", string2);
        }
        ResXmlSerializer resXmlSerializer2 = resXmlSerializer;
        resXmlSerializer2.text(this.toXmlTextValue());
        resXmlSerializer2.endTag(null, string3);
    }

    public final String toString() {
        ResPrimitive resPrimitive = n;
        Integer n = resPrimitive.mType;
        Integer n2 = resPrimitive.mData;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n;
        objectArray[1] = n2;
        return String.format("ResPrimitive{type=0x%02x, data=0x%08x}", objectArray2);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ResPrimitive) {
            object = (ResPrimitive)object;
            return this.mType == ((ResItem)object).mType && this.mData == ((ResPrimitive)object).mData;
        }
        return false;
    }

    public final int hashCode() {
        ResPrimitive resPrimitive = n;
        Integer n = resPrimitive.mType;
        Integer n2 = resPrimitive.mData;
        return Objects.hash(n, n2);
    }
}

