/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.data.ResChunkHeader;
import brut.util.BinaryDataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;

public final class ResChunkPullParser {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final BinaryDataInputStream mIn;
    public final long mOffset;
    public final int mSize;
    public long mChunkOffset;
    public ResChunkHeader mChunkHeader;

    public ResChunkPullParser(BinaryDataInputStream binaryDataInputStream, int n) {
        if (!$assertionsDisabled && binaryDataInputStream.mByteOrder != ByteOrder.LITTLE_ENDIAN) {
            throw new AssertionError();
        }
        this.mIn = binaryDataInputStream;
        this.mOffset = binaryDataInputStream.mPosition;
        this.mSize = n;
    }

    static {
        $assertionsDisabled = ResChunkPullParser.class.desiredAssertionStatus() ^ true;
    }

    public final long chunkStart() {
        if (this.mChunkHeader != null) {
            return this.mChunkOffset;
        }
        throw new IllegalStateException();
    }

    public final int chunkType() {
        ResChunkHeader resChunkHeader = ((ResChunkPullParser)((Object)resChunkHeader)).mChunkHeader;
        if (resChunkHeader != null) {
            return resChunkHeader.type;
        }
        throw new IllegalStateException();
    }

    public final String chunkName() {
        ResChunkHeader resChunkHeader = ((ResChunkPullParser)((Object)resChunkHeader)).mChunkHeader;
        if (resChunkHeader != null) {
            int n = resChunkHeader.type;
            if (n != 384) {
                switch (n) {
                    default: {
                        switch (n) {
                            default: {
                                switch (n) {
                                    default: {
                                        Integer n2 = n;
                                        Object[] objectArray = new Object[1];
                                        Object[] objectArray2 = objectArray;
                                        objectArray[0] = n2;
                                        return String.format("0x%04x", objectArray2);
                                    }
                                    case 518: {
                                        return "RES_TABLE_STAGED_ALIAS_TYPE";
                                    }
                                    case 517: {
                                        return "RES_TABLE_OVERLAYABLE_POLICY_TYPE";
                                    }
                                    case 516: {
                                        return "RES_TABLE_OVERLAYABLE_TYPE";
                                    }
                                    case 515: {
                                        return "RES_TABLE_LIBRARY_TYPE";
                                    }
                                    case 514: {
                                        return "RES_TABLE_TYPE_SPEC_TYPE";
                                    }
                                    case 513: {
                                        return "RES_TABLE_TYPE_TYPE";
                                    }
                                    case 512: 
                                }
                                return "RES_TABLE_PACKAGE_TYPE";
                            }
                            case 260: {
                                return "RES_XML_CDATA_TYPE";
                            }
                            case 259: {
                                return "RES_XML_END_ELEMENT_TYPE";
                            }
                            case 258: {
                                return "RES_XML_START_ELEMENT_TYPE";
                            }
                            case 257: {
                                return "RES_XML_END_NAMESPACE_TYPE";
                            }
                            case 256: 
                        }
                        return "RES_XML_START_NAMESPACE_TYPE";
                    }
                    case 3: {
                        return "RES_XML_TYPE";
                    }
                    case 2: {
                        return "RES_TABLE_TYPE";
                    }
                    case 1: {
                        return "RES_STRING_POOL_TYPE";
                    }
                    case 0: 
                }
                return "RES_NULL_TYPE";
            }
            return "RES_XML_RESOURCE_MAP_TYPE";
        }
        throw new IllegalStateException();
    }

    public final int chunkSize() {
        ResChunkHeader resChunkHeader = ((ResChunkPullParser)((Object)resChunkHeader)).mChunkHeader;
        if (resChunkHeader != null) {
            return resChunkHeader.size;
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean next() {
        int n;
        int n2;
        int n3;
        block9: {
            ResChunkHeader resChunkHeader;
            if (this.mChunkOffset == -1L) {
                return false;
            }
            if (this.mChunkHeader != null) {
                this.skipChunk();
                this.mChunkHeader = null;
            }
            BinaryDataInputStream binaryDataInputStream = this.mIn;
            long l = binaryDataInputStream.mPosition;
            if (l >= this.mOffset + (long)this.mSize) {
                this.mChunkOffset = -1L;
                return false;
            }
            BinaryDataInputStream binaryDataInputStream2 = binaryDataInputStream;
            this.mChunkOffset = l;
            n3 = binaryDataInputStream2.readUnsignedShort();
            n2 = binaryDataInputStream2.readUnsignedShort();
            n = binaryDataInputStream.readInt();
            ResChunkHeader resChunkHeader2 = resChunkHeader;
            resChunkHeader = new ResChunkHeader(n3, n2, n);
            if (n2 < 8 || n < n2) break block9;
            this.mChunkHeader = resChunkHeader2;
            return true;
        }
        try {
            Integer n4 = n3;
            Integer n5 = n2;
            Integer n6 = n;
            throw new IOException(String.format("Invalid chunk header: type=0x%04x, headerSize=%s, size=%s", n4, n5, n6));
        }
        catch (IOException iOException) {
            throw new IOException("Error while reading chunk header.", iOException);
        }
        catch (EOFException eOFException) {}
        this.mChunkOffset = -1L;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int skipChunk() {
        block7: {
            ResChunkHeader resChunkHeader = this.mChunkHeader;
            if (resChunkHeader == null) throw new IllegalStateException();
            BinaryDataInputStream binaryDataInputStream = this.mIn;
            long l = binaryDataInputStream.mPosition;
            if (resChunkHeader == null) throw new IllegalStateException();
            long l2 = this.mChunkOffset + (long)resChunkHeader.size;
            if (l == l2) {
                return 0;
            }
            if (l > l2) break block7;
            return (int)binaryDataInputStream.skip((int)(l2 - l));
        }
        try {
            throw new IOException("Stream advanced past chunk end.");
        }
        catch (IOException iOException) {
            throw new IOException("Error while skipping chunk.", iOException);
        }
        catch (EOFException eOFException) {
            throw new EOFException("Unexpected EOF while skipping chunk.");
        }
    }
}

