/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.res.data.ResChunkHeader;
import brut.androlib.res.data.StyledString;
import brut.androlib.res.data.StyledString$Span;
import brut.androlib.res.decoder.ResChunkPullParser;
import brut.common.Log;
import brut.util.BinaryDataInputStream;
import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;

public final class ResStringPool {
    public static final CharsetDecoder UTF16LE_DECODER = StandardCharsets.UTF_16LE.newDecoder();
    public static final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();
    public static final CharsetDecoder CESU8_DECODER = Charset.forName("CESU8").newDecoder();
    public final int[] mStringOffsets;
    public final byte[] mStrings;
    public final int[] mStyleOffsets;
    public final int[] mStyles;
    public final boolean mIsUtf8;

    public ResStringPool(int[] nArray, byte[] byArray, int[] nArray2, int[] nArray3, boolean bl) {
        this.mStringOffsets = nArray;
        this.mStrings = byArray;
        this.mStyleOffsets = nArray2;
        this.mStyles = nArray3;
        this.mIsUtf8 = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResStringPool parse(ResChunkPullParser resChunkPullParser) {
        boolean bl;
        int[] nArray;
        int n;
        int[] nArray2;
        long l;
        long l2;
        Object[] objectArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        BinaryDataInputStream binaryDataInputStream;
        block20: {
            block19: {
                int n7;
                block18: {
                    ResChunkPullParser resChunkPullParser2 = resChunkPullParser;
                    binaryDataInputStream = resChunkPullParser2.mIn;
                    n6 = binaryDataInputStream.readInt();
                    n5 = binaryDataInputStream.readInt();
                    n4 = binaryDataInputStream.readInt();
                    n3 = binaryDataInputStream.readInt();
                    n2 = binaryDataInputStream.readInt();
                    ResChunkHeader resChunkHeader = resChunkPullParser2.mChunkHeader;
                    if (resChunkHeader == null) throw new IllegalStateException();
                    objectArray = resChunkPullParser.mIn;
                    long l3 = objectArray.mPosition;
                    l2 = resChunkPullParser.mChunkOffset + (long)resChunkHeader.headerSize;
                    if (l3 == l2) {
                        n7 = 0;
                        break block18;
                    }
                    if (l3 > l2) break block19;
                    n7 = (int)objectArray.skip((int)(l2 - l3));
                }
                if (n7 > 0) {
                    Integer n8 = n7;
                    objectArray = resChunkPullParser.chunkName();
                    Object[] objectArray2 = new Object[2];
                    Object[] objectArray3 = objectArray2;
                    objectArray2[0] = n8;
                    objectArray2[1] = objectArray;
                    Log.log(Level.FINE, "brut.androlib.res.data.ResStringPool", "Skipped unknown %s bytes at end of %s chunk header.", objectArray3);
                }
                l = resChunkPullParser.chunkStart() + (long)n3;
                nArray2 = new int[n6];
                break block20;
            }
            try {
                throw new IOException("Stream advanced past chunk header end.");
            }
            catch (IOException iOException) {
                throw new IOException("Error while skipping chunk header.", iOException);
            }
            catch (EOFException eOFException) {
                throw new EOFException("Unexpected EOF while skipping chunk header.");
            }
        }
        for (n = 0; n < n6; ++n) {
            l2 = binaryDataInputStream.mPosition;
            if (l2 >= l) {
                Long l4 = l2;
                Long l5 = l;
                Object[] objectArray4 = new Object[2];
                objectArray = objectArray4;
                objectArray4[0] = l4;
                objectArray4[1] = l5;
                Log.log(Level.FINE, "brut.androlib.res.data.ResStringPool", "Bad string block: string entry is at %s, past end at %s", objectArray);
                break;
            }
            nArray2[n] = binaryDataInputStream.readInt();
        }
        long l6 = resChunkPullParser.chunkStart() + (long)n2;
        int[] nArray3 = new int[n5];
        for (n = 0; n < n5; ++n) {
            l2 = binaryDataInputStream.mPosition;
            if (l2 >= l6) {
                Long l7 = l2;
                objectArray = l6;
                Object[] objectArray5 = new Object[2];
                Object[] objectArray6 = objectArray5;
                objectArray5[0] = l7;
                objectArray5[1] = objectArray;
                Log.log(Level.FINE, "brut.androlib.res.data.ResStringPool", "Bad string block: string entry is at %s, past end at %s", objectArray6);
                break;
            }
            nArray3[n] = binaryDataInputStream.readInt();
        }
        int n9 = resChunkPullParser.chunkSize() - n3;
        if (n5 > 0) {
            n9 = n2 - n3;
        }
        byte[] byArray = new byte[n9];
        ByteStreams.readFully(binaryDataInputStream, byArray, 0, n9);
        if (n2 > 0 && n5 > 0) {
            n9 = resChunkPullParser.chunkSize() - n2;
            int n10 = n9 / 4;
            nArray = new int[n10];
            for (n2 = 0; n2 < n10; ++n2) {
                nArray[n2] = binaryDataInputStream.readInt();
            }
        } else {
            nArray = new int[]{};
        }
        binaryDataInputStream.skip(n9 % 4);
        if ((n4 & 0x100) != 0) {
            bl = true;
            return new ResStringPool(nArray2, byArray, nArray3, nArray, bl);
        }
        bl = false;
        return new ResStringPool(nArray2, byArray, nArray3, nArray, bl);
    }

    /*
     * Unable to fully structure code
     */
    public final CharSequence getText(int var1_1) {
        var2_3 = this.getString(var1_1);
        if (var2_3 == null) {
            return null;
        }
        if (var1_1 < 0) ** GOTO lbl-1000
        var3_4 = this.mStyleOffsets;
        if (var1_1 >= this.mStyleOffsets.length || this.mStyles.length == 0) ** GOTO lbl-1000
        var1_1 = var3_4[var1_1] / 4;
        var3_5 = 0;
        var4_7 = var1_1;
        while (true) {
            var5_9 = (StyledString$Span[])this.mStyles;
            if (var4_7 + 2 >= this.mStyles.length || var5_9[var4_7] < 0) break;
            ++var3_5;
            var4_7 += 3;
        }
        if (var3_5 == 0) lbl-1000:
        // 3 sources

        {
            var1_2 = null;
        } else {
            var4_8 = new int[var3_5 *= 3];
            System.arraycopy(var5_9, var1_1, var4_8, 0, var3_5);
            var1_2 = var4_8;
        }
        if (var1_2 == null) {
            return var2_3;
        }
        var3_6 = var2_3.length();
        var4_7 = var1_2.length / 3;
        var5_9 = new StyledString$Span[var4_7];
        var6_10 = 0;
        for (var7_11 = 0; var7_11 < var1_2.length; var7_11 += 3) {
            var8_12 = this.getString((int)var1_2[var7_11]);
            var9_13 = var1_2[var7_11 + 1];
            var10_14 = var1_2[var7_11 + 2];
            if (var9_13 < 0 || var9_13 > var3_6 || var10_14 > var3_6) continue;
            var11_15 = var6_10 + 1;
            var12_16 = v0;
            v0 = new StyledString$Span(var8_12, (int)var9_13, (int)var10_14);
            var5_9[var6_10] = var12_16;
            var6_10 = var11_15;
        }
        if (var6_10 < var4_7) {
            var5_9 = Arrays.copyOf(var5_9, var6_10);
        }
        return new StyledString(var2_3, var5_9);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getString(int n) {
        int n2;
        int n3;
        block16: {
            Object object;
            block15: {
                CharsetDecoder charsetDecoder;
                int[] nArray;
                if (n < 0) return null;
                int[] nArray2 = ((ResStringPool)object).mStringOffsets;
                if (n >= ((ResStringPool)object).mStringOffsets.length) return null;
                Object object2 = ((ResStringPool)object).mStrings;
                if (((ResStringPool)object).mStrings.length == 0) {
                    return null;
                }
                n = nArray2[n];
                if (((ResStringPool)object).mIsUtf8) {
                    n = (object2[n] & 0x80) != 0 ? (n += 2) : ++n;
                    n3 = object2[n];
                    int n4 = n + 1;
                    if ((n3 & 0x80) != 0) {
                        int n5 = n3;
                        n3 = object2[n4] & 0xFF;
                        n3 = ((n5 & 0x7F) << 8) + n3;
                        n4 = n + 2;
                    }
                    int[] nArray3 = new int[2];
                    nArray = nArray3;
                    nArray3[0] = n4;
                    nArray3[1] = n3;
                    n3 = nArray3[0];
                } else {
                    int[] nArray4;
                    int[] nArray5;
                    int n6 = (object2[n + 1] & 0xFF) << 8 | object2[n] & 0xFF;
                    if ((n6 & 0x8000) != 0) {
                        int n7 = n6;
                        n6 = (object2[n + 3] & 0xFF) << 8;
                        int n8 = object2[n + 2] & 0xFF;
                        n6 = (((n7 & Short.MAX_VALUE) << 16) + n6 + n8) * 2;
                        int[] nArray6 = new int[2];
                        nArray5 = nArray6;
                        nArray6[0] = 4;
                        nArray6[1] = n6;
                        nArray4 = nArray5;
                    } else {
                        int[] nArray7 = new int[2];
                        nArray5 = nArray7;
                        nArray7[0] = 2;
                        nArray7[1] = n6 *= 2;
                        nArray4 = nArray5;
                    }
                    n3 = n += nArray4[0];
                    nArray = nArray4;
                }
                n2 = nArray[1];
                try {
                    object2 = ByteBuffer.wrap(object2, n3, n2);
                    if (!((ResStringPool)object).mIsUtf8) {
                        charsetDecoder = UTF16LE_DECODER;
                    }
                    charsetDecoder = UTF8_DECODER;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (CharacterCodingException characterCodingException) {
                    break block15;
                }
                CharsetDecoder charsetDecoder2 = charsetDecoder;
                return charsetDecoder2.decode((ByteBuffer)object2).toString();
                if (!((ResStringPool)object).mIsUtf8) {
                    object = n3;
                    Integer n9 = n2;
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = object;
                    objectArray[1] = n9;
                    Log.log(Level.WARNING, "brut.androlib.res.data.ResStringPool", "String extends outside of pool at %s of length %s", objectArray2);
                    return null;
                }
                break block16;
            }
            if (!((ResStringPool)object).mIsUtf8) {
                object = n3;
                Integer n10 = n2;
                Object[] objectArray = new Object[2];
                Object[] objectArray3 = objectArray;
                objectArray[0] = object;
                objectArray[1] = n10;
                Log.log(Level.WARNING, "brut.androlib.res.data.ResStringPool", "Failed to decode a string at offset %s of length %s", objectArray3);
                return null;
            }
        }
        try {
            return CESU8_DECODER.decode(ByteBuffer.wrap(((ResStringPool)object).mStrings, n3, n2)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            Log.log(Level.WARNING, "brut.androlib.res.data.ResStringPool", "Failed to decode a string with CESU-8 decoder.");
            return null;
        }
    }
}

