import type { RefObject } from 'react'
import type { Viewport } from 'reactflow'
import type { BeforeRunFormProps } from '@/app/components/workflow/nodes/_base/components/before-run-form'
import type { ErrorHandleTypeEnum } from '@/app/components/workflow/nodes/_base/components/error-handle/types'
import type { FormInputItem, UserAction } from '@/app/components/workflow/nodes/human-input/types'
import type { SpecialResultPanelProps } from '@/app/components/workflow/run/special-result-panel'
import type {
  BlockEnum,
  CommonNodeType,
  ConversationVariable,
  Edge,
  EnvironmentVariable,
  InputVar,
  Node,
  ValueSelector,
  Variable,
  VarType,
  WorkflowRunningStatus,
} from '@/app/components/workflow/types'
import type { RAGPipelineVariables } from '@/models/pipeline'
import type { TransferMethod } from '@/types/app'

export type AgentLogItem = {
  node_execution_id: string
  message_id: string
  node_id: string
  parent_id?: string
  label: string
  data: object // debug data
  error?: string
  status: string
  metadata?: {
    elapsed_time?: number
    provider?: string
    icon?: string
  }
}

export type AgentLogItemWithChildren = AgentLogItem & {
  hasCircle?: boolean
  children: AgentLogItemWithChildren[]
}

export type IconObject = {
  background: string
  content: string
}

export type LLMGenerationItem = {
  id: string
  type: 'model' | 'tool' | 'thought' | 'text'
  thoughtCompleted?: boolean
  thoughtOutput?: string

  toolName?: string
  toolProvider?: string
  toolIcon?: string | IconObject
  toolIconDark?: string | IconObject
  toolArguments?: string
  toolOutput?: Record<string, any> | string
  toolFiles?: string[]
  toolError?: string
  toolDuration?: number

  modelName?: string
  modelProvider?: string
  modelOutput?: Record<string, any> | string
  modelDuration?: number
  modelIcon?: string | IconObject
  modelIconDark?: string | IconObject

  text?: string
  textCompleted?: boolean
  isError?: boolean
}

export type ToolCallDetail = {
  id: string
  name: string
  arguments: string
  output: string
  files: string[]
  error: string
  elapsed_time?: number
  status: string
}
export type SequenceSegment
  = | { type: 'context', start: number, end: number }
    | { type: 'reasoning', index: number }
    | { type: 'tool_call', index: number }

export type LLMLogItem = {
  reasoning_content: string[]
  tool_calls: ToolCallDetail[]
  sequence: SequenceSegment[]
}

export type LLMTraceItem = {
  type: 'model' | 'tool'
  duration: number
  output: Record<string, any>
  provider?: string
  name: string
  icon?: string | IconObject
  icon_dark?: string | IconObject
  error?: string
  status?: 'success' | 'error'
}

export type NodeTracing = {
  id: string
  index: number
  predecessor_node_id: string
  node_id: string
  iteration_id?: string
  loop_id?: string
  node_type: BlockEnum
  title: string
  inputs: any
  inputs_truncated: boolean
  process_data: any
  process_data_truncated: boolean
  outputs?: Record<string, any>
  outputs_truncated: boolean
  outputs_full_content?: {
    download_url: string
  }
  status: string
  parallel_run_id?: string
  error?: string
  elapsed_time: number
  execution_metadata?: {
    total_tokens: number
    total_price: number
    currency: string
    iteration_id?: string
    iteration_index?: number
    loop_id?: string
    loop_index?: number
    parallel_id?: string
    parallel_start_node_id?: string
    parent_parallel_id?: string
    parent_parallel_start_node_id?: string
    parallel_mode_run_id?: string
    iteration_duration_map?: IterationDurationMap
    loop_duration_map?: LoopDurationMap
    error_strategy?: ErrorHandleTypeEnum
    agent_log?: AgentLogItem[]
    tool_info?: {
      agent_strategy?: string
      icon?: string
    }
    loop_variable_map?: Record<string, any>
    llm_trace?: LLMTraceItem[]
  }
  metadata: {
    iterator_length: number
    iterator_index: number
    loop_length: number
    loop_index: number
  }
  created_at: number
  created_by: {
    id: string
    name: string
    email: string
  }
  iterDurationMap?: IterationDurationMap
  loopDurationMap?: LoopDurationMap
  finished_at: number
  extras?: any
  expand?: boolean // for UI
  details?: NodeTracing[][] // iteration or loop detail
  retryDetail?: NodeTracing[] // retry detail
  retry_index?: number
  parallelDetail?: { // parallel detail. if is in parallel, this field will be set
    isParallelStartNode?: boolean
    parallelTitle?: string
    branchTitle?: string
    children?: NodeTracing[]
  }
  parallel_id?: string
  parallel_start_node_id?: string
  parent_parallel_id?: string
  parent_parallel_start_node_id?: string
  agentLog?: AgentLogItemWithChildren[] // agent log
  generation_detail?: LLMLogItem
}

export type FetchWorkflowDraftResponse = {
  id: string
  graph: {
    nodes: Node[]
    edges: Edge[]
    viewport?: Viewport
  }
  features?: any
  created_at: number
  created_by: {
    id: string
    name: string
    email: string
  }
  hash: string
  updated_at: number
  updated_by: {
    id: string
    name: string
    email: string
  }
  tool_published: boolean
  environment_variables?: EnvironmentVariable[]
  conversation_variables?: ConversationVariable[]
  rag_pipeline_variables?: RAGPipelineVariables
  version: string
  marked_name: string
  marked_comment: string
}

export type NestedNodeParameterSchema = {
  name: string
  type: string
  description?: string
}

export type NestedNodeGraphPayload = {
  parent_node_id: string
  parameter_key: string
  context_source: ValueSelector
  parameter_schema: NestedNodeParameterSchema
}

export type NestedNodeGraphResponse = {
  graph: {
    nodes: Node[]
    edges: Edge[]
    viewport?: Viewport
  }
}

export type VersionHistory = FetchWorkflowDraftResponse

export type FetchWorkflowDraftPageParams = {
  url: string
  initialPage: number
  limit: number
  userId?: string
  namedOnly?: boolean
}

export type FetchWorkflowDraftPageResponse = {
  items: VersionHistory[]
  has_more: boolean
  page: number
}

export type NodeTracingListResponse = {
  data: NodeTracing[]
}

export type WorkflowStartedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: {
    id: string
    workflow_id: string
    created_at: number
  }
  conversation_id?: string // only in chatflow
  message_id?: string // only in chatflow
}

export type WorkflowPausedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: {
    outputs: any // todo: remove any
    paused_nodes: string[]
    reasons: any[] // todo: remove any
    workflow_run_id: string
  }
}

export type WorkflowFinishedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: {
    id: string
    workflow_id: string
    status: string
    outputs: any
    error: string
    elapsed_time: number
    total_tokens: number
    total_steps: number
    created_at: number
    created_by: {
      id: string
      name: string
      email: string
    }
    finished_at: number
    files?: FileResponse[]
  }
}

export type NodeStartedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type FileResponse = {
  related_id: string
  extension: string
  filename: string
  size: number
  mime_type: string
  transfer_method: TransferMethod
  type: string
  url: string
  upload_file_id: string
  remote_url: string
}

export type NodeFinishedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type IterationStartedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type IterationNextResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type IterationFinishedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type LoopStartedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type LoopNextResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type LoopFinishedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type ParallelBranchStartedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type ParallelBranchFinishedResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: NodeTracing
}

export type TextChunkResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: {
    text: string
    chunk_type?: 'text' | 'tool_call' | 'tool_result' | 'thought' | 'thought_start' | 'thought_end'
    tool_call_id?: string
    tool_name?: string
    tool_arguments?: string
    tool_icon?: string | IconObject
    tool_icon_dark?: string | IconObject

    tool_files?: string[]
    tool_error?: string
    tool_elapsed_time?: number
  }
}

export type TextReplaceResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: {
    text: string
  }
}

export type AgentLogResponse = {
  task_id: string
  event: string
  data: AgentLogItemWithChildren
}

export type HumanInputFormData = {
  form_id: string
  node_id: string
  node_title: string
  form_content: string
  inputs: FormInputItem[]
  actions: UserAction[]
  form_token: string
  resolved_default_values: Record<string, string>
  display_in_ui: boolean
  expiration_time: number
}

export type HumanInputRequiredResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: HumanInputFormData
}

export type HumanInputFilledFormData = {
  node_id: string
  node_title: string
  rendered_content: string
  action_id: string
  action_text: string
}

export type HumanInputFormFilledResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: HumanInputFilledFormData
}

export type HumanInputFormTimeoutData = {
  node_id: string
  node_title: string
  expiration_time: number
}

export type HumanInputFormTimeoutResponse = {
  task_id: string
  workflow_run_id: string
  event: string
  data: HumanInputFormTimeoutData
}

export type WorkflowRunHistory = {
  id: string
  version: string
  conversation_id?: string
  message_id?: string
  graph: {
    nodes: Node[]
    edges: Edge[]
    viewport?: Viewport
  }
  inputs: Record<string, string>
  status: WorkflowRunningStatus
  outputs: Record<string, any>
  error?: string
  elapsed_time: number
  total_tokens: number
  total_steps: number
  created_at: number
  finished_at: number
  created_by_account: {
    id: string
    name: string
    email: string
  }
}
export type WorkflowRunHistoryResponse = {
  data: WorkflowRunHistory[]
}

export type ChatRunHistoryResponse = {
  data: WorkflowRunHistory[]
}

export type NodesDefaultConfigsResponse = {
  type: string
  config: any
}[]

export type ConversationVariableResponse = {
  data: (ConversationVariable & { updated_at: number, created_at: number })[]
  has_more: boolean
  limit: number
  total: number
  page: number
}

export type IterationDurationMap = Record<string, number>
export type LoopDurationMap = Record<string, number>
export type LoopVariableMap = Record<string, any>

export type WorkflowConfigResponse = {
  parallel_depth_limit: number
}

export type PublishWorkflowParams = {
  url: string
  title: string
  releaseNotes: string
}

export type UpdateWorkflowParams = {
  url: string
  title: string
  releaseNotes: string
}

export type PanelExposedType = {
  singleRunParams: Pick<BeforeRunFormProps, 'forms'> & Partial<SpecialResultPanelProps>
}

export type PanelProps = {
  getInputVars: (textList: string[]) => InputVar[]
  toVarInputs: (variables: Variable[]) => InputVar[]
  runInputData: Record<string, any>
  runInputDataRef: RefObject<Record<string, any>>
  setRunInputData: (data: Record<string, any>) => void
  runResult: any
}

export type NodeRunResult = NodeTracing

// Var Inspect
export enum VarInInspectType {
  conversation = 'conversation',
  environment = 'env',
  node = 'node',
  system = 'sys',
}

export type FullContent = {
  size_bytes: number
  download_url: string
}

export type VarInInspectAliasMeta = {
  extractorNodeId: string
  outputSelector: string[]
  sourceVarId: string
}

export type VarInInspect = {
  id: string
  type: VarInInspectType
  name: string
  description: string
  selector: ValueSelector // can get node id from selector[0]
  value_type: VarType
  value: any
  edited: boolean
  visible: boolean
  is_truncated: boolean
  full_content: FullContent
  schemaType?: string
  aliasMeta?: VarInInspectAliasMeta
}

export type NodeWithVar = {
  nodeId: string
  nodePayload: CommonNodeType
  nodeType: BlockEnum
  title: string
  vars: VarInInspect[]
  isSingRunRunning?: boolean
  isValueFetched?: boolean
  isHidden?: boolean
}
