// AUTO-GENERATED — DO NOT EDIT
// Source: https://github.com/anthropics/skills
import type { SkillTemplateNode } from '../types'

const children: SkillTemplateNode[] = [
  {
    "name": "SKILL.md",
    "node_type": "file",
    "content": "---\nname: doc-coauthoring\ndescription: Guide users through a structured workflow for co-authoring documentation. Use when user wants to write documentation, proposals, technical specs, decision docs, or similar structured content. This workflow helps users efficiently transfer context, refine content through iteration, and verify the doc works for readers. Trigger when user mentions writing docs, creating proposals, drafting specs, or similar documentation tasks.\n---\n\n# Doc Co-Authoring Workflow\n\nThis skill provides a structured workflow for guiding users through collaborative document creation. Act as an active guide, walking users through three stages: Context Gathering, Refinement & Structure, and Reader Testing.\n\n## When to Offer This Workflow\n\n**Trigger conditions:**\n- User mentions writing documentation: \"write a doc\", \"draft a proposal\", \"create a spec\", \"write up\"\n- User mentions specific doc types: \"PRD\", \"design doc\", \"decision doc\", \"RFC\"\n- User seems to be starting a substantial writing task\n\n**Initial offer:**\nOffer the user a structured workflow for co-authoring the document. Explain the three stages:\n\n1. **Context Gathering**: User provides all relevant context while Claude asks clarifying questions\n2. **Refinement & Structure**: Iteratively build each section through brainstorming and editing\n3. **Reader Testing**: Test the doc with a fresh Claude (no context) to catch blind spots before others read it\n\nExplain that this approach helps ensure the doc works well when others read it (including when they paste it into Claude). Ask if they want to try this workflow or prefer to work freeform.\n\nIf user declines, work freeform. If user accepts, proceed to Stage 1.\n\n## Stage 1: Context Gathering\n\n**Goal:** Close the gap between what the user knows and what Claude knows, enabling smart guidance later.\n\n### Initial Questions\n\nStart by asking the user for meta-context about the document:\n\n1. What type of document is this? (e.g., technical spec, decision doc, proposal)\n2. Who's the primary audience?\n3. What's the desired impact when someone reads this?\n4. Is there a template or specific format to follow?\n5. Any other constraints or context to know?\n\nInform them they can answer in shorthand or dump information however works best for them.\n\n**If user provides a template or mentions a doc type:**\n- Ask if they have a template document to share\n- If they provide a link to a shared document, use the appropriate integration to fetch it\n- If they provide a file, read it\n\n**If user mentions editing an existing shared document:**\n- Use the appropriate integration to read the current state\n- Check for images without alt-text\n- If images exist without alt-text, explain that when others use Claude to understand the doc, Claude won't be able to see them. Ask if they want alt-text generated. If so, request they paste each image into chat for descriptive alt-text generation.\n\n### Info Dumping\n\nOnce initial questions are answered, encourage the user to dump all the context they have. Request information such as:\n- Background on the project/problem\n- Related team discussions or shared documents\n- Why alternative solutions aren't being used\n- Organizational context (team dynamics, past incidents, politics)\n- Timeline pressures or constraints\n- Technical architecture or dependencies\n- Stakeholder concerns\n\nAdvise them not to worry about organizing it - just get it all out. Offer multiple ways to provide context:\n- Info dump stream-of-consciousness\n- Point to team channels or threads to read\n- Link to shared documents\n\n**If integrations are available** (e.g., Slack, Teams, Google Drive, SharePoint, or other MCP servers), mention that these can be used to pull in context directly.\n\n**If no integrations are detected and in Claude.ai or Claude app:** Suggest they can enable connectors in their Claude settings to allow pulling context from messaging apps and document storage directly.\n\nInform them clarifying questions will be asked once they've done their initial dump.\n\n**During context gathering:**\n\n- If user mentions team channels or shared documents:\n  - If integrations available: Inform them the content will be read now, then use the appropriate integration\n  - If integrations not available: Explain lack of access. Suggest they enable connectors in Claude settings, or paste the relevant content directly.\n\n- If user mentions entities/projects that are unknown:\n  - Ask if connected tools should be searched to learn more\n  - Wait for user confirmation before searching\n\n- As user provides context, track what's being learned and what's still unclear\n\n**Asking clarifying questions:**\n\nWhen user signals they've done their initial dump (or after substantial context provided), ask clarifying questions to ensure understanding:\n\nGenerate 5-10 numbered questions based on gaps in the context.\n\nInform them they can use shorthand to answer (e.g., \"1: yes, 2: see #channel, 3: no because backwards compat\"), link to more docs, point to channels to read, or just keep info-dumping. Whatever's most efficient for them.\n\n**Exit condition:**\nSufficient context has been gathered when questions show understanding - when edge cases and trade-offs can be asked about without needing basics explained.\n\n**Transition:**\nAsk if there's any more context they want to provide at this stage, or if it's time to move on to drafting the document.\n\nIf user wants to add more, let them. When ready, proceed to Stage 2.\n\n## Stage 2: Refinement & Structure\n\n**Goal:** Build the document section by section through brainstorming, curation, and iterative refinement.\n\n**Instructions to user:**\nExplain that the document will be built section by section. For each section:\n1. Clarifying questions will be asked about what to include\n2. 5-20 options will be brainstormed\n3. User will indicate what to keep/remove/combine\n4. The section will be drafted\n5. It will be refined through surgical edits\n\nStart with whichever section has the most unknowns (usually the core decision/proposal), then work through the rest.\n\n**Section ordering:**\n\nIf the document structure is clear:\nAsk which section they'd like to start with.\n\nSuggest starting with whichever section has the most unknowns. For decision docs, that's usually the core proposal. For specs, it's typically the technical approach. Summary sections are best left for last.\n\nIf user doesn't know what sections they need:\nBased on the type of document and template, suggest 3-5 sections appropriate for the doc type.\n\nAsk if this structure works, or if they want to adjust it.\n\n**Once structure is agreed:**\n\nCreate the initial document structure with placeholder text for all sections.\n\n**If access to artifacts is available:**\nUse `create_file` to create an artifact. This gives both Claude and the user a scaffold to work from.\n\nInform them that the initial structure with placeholders for all sections will be created.\n\nCreate artifact with all section headers and brief placeholder text like \"[To be written]\" or \"[Content here]\".\n\nProvide the scaffold link and indicate it's time to fill in each section.\n\n**If no access to artifacts:**\nCreate a markdown file in the working directory. Name it appropriately (e.g., `decision-doc.md`, `technical-spec.md`).\n\nInform them that the initial structure with placeholders for all sections will be created.\n\nCreate file with all section headers and placeholder text.\n\nConfirm the filename has been created and indicate it's time to fill in each section.\n\n**For each section:**\n\n### Step 1: Clarifying Questions\n\nAnnounce work will begin on the [SECTION NAME] section. Ask 5-10 clarifying questions about what should be included:\n\nGenerate 5-10 specific questions based on context and section purpose.\n\nInform them they can answer in shorthand or just indicate what's important to cover.\n\n### Step 2: Brainstorming\n\nFor the [SECTION NAME] section, brainstorm [5-20] things that might be included, depending on the section's complexity. Look for:\n- Context shared that might have been forgotten\n- Angles or considerations not yet mentioned\n\nGenerate 5-20 numbered options based on section complexity. At the end, offer to brainstorm more if they want additional options.\n\n### Step 3: Curation\n\nAsk which points should be kept, removed, or combined. Request brief justifications to help learn priorities for the next sections.\n\nProvide examples:\n- \"Keep 1,4,7,9\"\n- \"Remove 3 (duplicates 1)\"\n- \"Remove 6 (audience already knows this)\"\n- \"Combine 11 and 12\"\n\n**If user gives freeform feedback** (e.g., \"looks good\" or \"I like most of it but...\") instead of numbered selections, extract their preferences and proceed. Parse what they want kept/removed/changed and apply it.\n\n### Step 4: Gap Check\n\nBased on what they've selected, ask if there's anything important missing for the [SECTION NAME] section.\n\n### Step 5: Drafting\n\nUse `str_replace` to replace the placeholder text for this section with the actual drafted content.\n\nAnnounce the [SECTION NAME] section will be drafted now based on what they've selected.\n\n**If using artifacts:**\nAfter drafting, provide a link to the artifact.\n\nAsk them to read through it and indicate what to change. Note that being specific helps learning for the next sections.\n\n**If using a file (no artifacts):**\nAfter drafting, confirm completion.\n\nInform them the [SECTION NAME] section has been drafted in [filename]. Ask them to read through it and indicate what to change. Note that being specific helps learning for the next sections.\n\n**Key instruction for user (include when drafting the first section):**\nProvide a note: Instead of editing the doc directly, ask them to indicate what to change. This helps learning of their style for future sections. For example: \"Remove the X bullet - already covered by Y\" or \"Make the third paragraph more concise\".\n\n### Step 6: Iterative Refinement\n\nAs user provides feedback:\n- Use `str_replace` to make edits (never reprint the whole doc)\n- **If using artifacts:** Provide link to artifact after each edit\n- **If using files:** Just confirm edits are complete\n- If user edits doc directly and asks to read it: mentally note the changes they made and keep them in mind for future sections (this shows their preferences)\n\n**Continue iterating** until user is satisfied with the section.\n\n### Quality Checking\n\nAfter 3 consecutive iterations with no substantial changes, ask if anything can be removed without losing important information.\n\nWhen section is done, confirm [SECTION NAME] is complete. Ask if ready to move to the next section.\n\n**Repeat for all sections.**\n\n### Near Completion\n\nAs approaching completion (80%+ of sections done), announce intention to re-read the entire document and check for:\n- Flow and consistency across sections\n- Redundancy or contradictions\n- Anything that feels like \"slop\" or generic filler\n- Whether every sentence carries weight\n\nRead entire document and provide feedback.\n\n**When all sections are drafted and refined:**\nAnnounce all sections are drafted. Indicate intention to review the complete document one more time.\n\nReview for overall coherence, flow, completeness.\n\nProvide any final suggestions.\n\nAsk if ready to move to Reader Testing, or if they want to refine anything else.\n\n## Stage 3: Reader Testing\n\n**Goal:** Test the document with a fresh Claude (no context bleed) to verify it works for readers.\n\n**Instructions to user:**\nExplain that testing will now occur to see if the document actually works for readers. This catches blind spots - things that make sense to the authors but might confuse others.\n\n### Testing Approach\n\n**If access to sub-agents is available (e.g., in Claude Code):**\n\nPerform the testing directly without user involvement.\n\n### Step 1: Predict Reader Questions\n\nAnnounce intention to predict what questions readers might ask when trying to discover this document.\n\nGenerate 5-10 questions that readers would realistically ask.\n\n### Step 2: Test with Sub-Agent\n\nAnnounce that these questions will be tested with a fresh Claude instance (no context from this conversation).\n\nFor each question, invoke a sub-agent with just the document content and the question.\n\nSummarize what Reader Claude got right/wrong for each question.\n\n### Step 3: Run Additional Checks\n\nAnnounce additional checks will be performed.\n\nInvoke sub-agent to check for ambiguity, false assumptions, contradictions.\n\nSummarize any issues found.\n\n### Step 4: Report and Fix\n\nIf issues found:\nReport that Reader Claude struggled with specific issues.\n\nList the specific issues.\n\nIndicate intention to fix these gaps.\n\nLoop back to refinement for problematic sections.\n\n---\n\n**If no access to sub-agents (e.g., claude.ai web interface):**\n\nThe user will need to do the testing manually.\n\n### Step 1: Predict Reader Questions\n\nAsk what questions people might ask when trying to discover this document. What would they type into Claude.ai?\n\nGenerate 5-10 questions that readers would realistically ask.\n\n### Step 2: Setup Testing\n\nProvide testing instructions:\n1. Open a fresh Claude conversation: https://claude.ai\n2. Paste or share the document content (if using a shared doc platform with connectors enabled, provide the link)\n3. Ask Reader Claude the generated questions\n\nFor each question, instruct Reader Claude to provide:\n- The answer\n- Whether anything was ambiguous or unclear\n- What knowledge/context the doc assumes is already known\n\nCheck if Reader Claude gives correct answers or misinterprets anything.\n\n### Step 3: Additional Checks\n\nAlso ask Reader Claude:\n- \"What in this doc might be ambiguous or unclear to readers?\"\n- \"What knowledge or context does this doc assume readers already have?\"\n- \"Are there any internal contradictions or inconsistencies?\"\n\n### Step 4: Iterate Based on Results\n\nAsk what Reader Claude got wrong or struggled with. Indicate intention to fix those gaps.\n\nLoop back to refinement for any problematic sections.\n\n---\n\n### Exit Condition (Both Approaches)\n\nWhen Reader Claude consistently answers questions correctly and doesn't surface new gaps or ambiguities, the doc is ready.\n\n## Final Review\n\nWhen Reader Testing passes:\nAnnounce the doc has passed Reader Claude testing. Before completion:\n\n1. Recommend they do a final read-through themselves - they own this document and are responsible for its quality\n2. Suggest double-checking any facts, links, or technical details\n3. Ask them to verify it achieves the impact they wanted\n\nAsk if they want one more review, or if the work is done.\n\n**If user wants final review, provide it. Otherwise:**\nAnnounce document completion. Provide a few final tips:\n- Consider linking this conversation in an appendix so readers can see how the doc was developed\n- Use appendices to provide depth without bloating the main doc\n- Update the doc as feedback is received from real readers\n\n## Tips for Effective Guidance\n\n**Tone:**\n- Be direct and procedural\n- Explain rationale briefly when it affects user behavior\n- Don't try to \"sell\" the approach - just execute it\n\n**Handling Deviations:**\n- If user wants to skip a stage: Ask if they want to skip this and write freeform\n- If user seems frustrated: Acknowledge this is taking longer than expected. Suggest ways to move faster\n- Always give user agency to adjust the process\n\n**Context Management:**\n- Throughout, if context is missing on something mentioned, proactively ask\n- Don't let gaps accumulate - address them as they come up\n\n**Artifact Management:**\n- Use `create_file` for drafting full sections\n- Use `str_replace` for all edits\n- Provide artifact link after every change\n- Never use artifacts for brainstorming lists - that's just conversation\n\n**Quality over Speed:**\n- Don't rush through stages\n- Each iteration should make meaningful improvements\n- The goal is a document that actually works for readers\n"
  }
]

export default children
