'use client'
import * as React from 'react'
import { useTranslation } from 'react-i18next'
import Textarea from '@/app/components/base/textarea'

type Props = {
  data?: any
  value: string
  onChange: (value: string) => void
}

const MCPServerParamItem = ({
  data,
  value,
  onChange,
}: Props) => {
  const { t } = useTranslation()

  return (
    <div className="space-y-0.5">
      <div className="flex h-6 items-center gap-2">
        <div className="text-text-secondary system-xs-medium">{data.label}</div>
        <div className="text-text-quaternary system-xs-medium">·</div>
        <div className="text-text-secondary system-xs-medium">{data.variable}</div>
        <div className="text-text-tertiary system-xs-medium">{data.type}</div>
      </div>
      <Textarea
        className="h-8 resize-none"
        value={value}
        placeholder={t('mcp.server.modal.parametersPlaceholder', { ns: 'tools' })}
        onChange={e => onChange(e.target.value)}
      >
      </Textarea>
    </div>
  )
}

export default MCPServerParamItem
