"""Add workflow comments table

Revision ID: 227822d22895
Revises: aab323465866
Create Date: 2026-02-09 17:26:15.255980

"""

from alembic import op
import models as models
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "227822d22895"
down_revision = "aab323465866"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "workflow_comments",
        sa.Column("id", models.types.StringUUID(), server_default=sa.text("uuidv7()"), nullable=False),
        sa.Column("tenant_id", models.types.StringUUID(), nullable=False),
        sa.Column("app_id", models.types.StringUUID(), nullable=False),
        sa.Column("position_x", sa.Float(), nullable=False),
        sa.Column("position_y", sa.Float(), nullable=False),
        sa.Column("content", sa.Text(), nullable=False),
        sa.Column("created_by", models.types.StringUUID(), nullable=False),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("resolved", sa.Boolean(), server_default=sa.text("false"), nullable=False),
        sa.Column("resolved_at", sa.DateTime(), nullable=True),
        sa.Column("resolved_by", models.types.StringUUID(), nullable=True),
        sa.PrimaryKeyConstraint("id", name="workflow_comments_pkey"),
    )
    with op.batch_alter_table("workflow_comments", schema=None) as batch_op:
        batch_op.create_index("workflow_comments_app_idx", ["tenant_id", "app_id"], unique=False)
        batch_op.create_index("workflow_comments_created_at_idx", ["created_at"], unique=False)

    op.create_table(
        "workflow_comment_replies",
        sa.Column("id", models.types.StringUUID(), server_default=sa.text("uuidv7()"), nullable=False),
        sa.Column("comment_id", models.types.StringUUID(), nullable=False),
        sa.Column("content", sa.Text(), nullable=False),
        sa.Column("created_by", models.types.StringUUID(), nullable=False),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.ForeignKeyConstraint(
            ["comment_id"],
            ["workflow_comments.id"],
            name=op.f("workflow_comment_replies_comment_id_fkey"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name="workflow_comment_replies_pkey"),
    )
    with op.batch_alter_table("workflow_comment_replies", schema=None) as batch_op:
        batch_op.create_index("comment_replies_comment_idx", ["comment_id"], unique=False)
        batch_op.create_index("comment_replies_created_at_idx", ["created_at"], unique=False)

    op.create_table(
        "workflow_comment_mentions",
        sa.Column("id", models.types.StringUUID(), server_default=sa.text("uuidv7()"), nullable=False),
        sa.Column("comment_id", models.types.StringUUID(), nullable=False),
        sa.Column("reply_id", models.types.StringUUID(), nullable=True),
        sa.Column("mentioned_user_id", models.types.StringUUID(), nullable=False),
        sa.ForeignKeyConstraint(
            ["comment_id"],
            ["workflow_comments.id"],
            name=op.f("workflow_comment_mentions_comment_id_fkey"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["reply_id"],
            ["workflow_comment_replies.id"],
            name=op.f("workflow_comment_mentions_reply_id_fkey"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name="workflow_comment_mentions_pkey"),
    )
    with op.batch_alter_table("workflow_comment_mentions", schema=None) as batch_op:
        batch_op.create_index("comment_mentions_comment_idx", ["comment_id"], unique=False)
        batch_op.create_index("comment_mentions_reply_idx", ["reply_id"], unique=False)
        batch_op.create_index("comment_mentions_user_idx", ["mentioned_user_id"], unique=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("workflow_comment_mentions", schema=None) as batch_op:
        batch_op.drop_index("comment_mentions_user_idx")
        batch_op.drop_index("comment_mentions_reply_idx")
        batch_op.drop_index("comment_mentions_comment_idx")

    op.drop_table("workflow_comment_mentions")
    with op.batch_alter_table("workflow_comment_replies", schema=None) as batch_op:
        batch_op.drop_index("comment_replies_created_at_idx")
        batch_op.drop_index("comment_replies_comment_idx")

    op.drop_table("workflow_comment_replies")
    with op.batch_alter_table("workflow_comments", schema=None) as batch_op:
        batch_op.drop_index("workflow_comments_created_at_idx")
        batch_op.drop_index("workflow_comments_app_idx")

    op.drop_table("workflow_comments")
    # ### end Alembic commands ###
