"""increase max model_name length

Revision ID: eeb2e349e6ac
Revises: 53bf8af60645
Create Date: 2024-07-26 12:02:00.750358

"""
import sqlalchemy as sa
from alembic import op

import models as models


def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = 'eeb2e349e6ac'
down_revision = '53bf8af60645'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    with op.batch_alter_table('dataset_collection_bindings', schema=None) as batch_op:
        batch_op.alter_column('model_name',
               existing_type=sa.VARCHAR(length=40),
               type_=sa.String(length=255),
               existing_nullable=False)

    if _is_pg(conn):
        with op.batch_alter_table('embeddings', schema=None) as batch_op:
            batch_op.alter_column('model_name',
                   existing_type=sa.VARCHAR(length=40),
                   type_=sa.String(length=255),
                   existing_nullable=False,
                   existing_server_default=sa.text("'text-embedding-ada-002'::character varying"))
    else:
        with op.batch_alter_table('embeddings', schema=None) as batch_op:
            batch_op.alter_column('model_name',
                   existing_type=sa.VARCHAR(length=40),
                   type_=sa.String(length=255),
                   existing_nullable=False,
                   existing_server_default=sa.text("'text-embedding-ada-002'"))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        with op.batch_alter_table('embeddings', schema=None) as batch_op:
            batch_op.alter_column('model_name',
                   existing_type=sa.String(length=255),
                   type_=sa.VARCHAR(length=40),
                   existing_nullable=False,
                   existing_server_default=sa.text("'text-embedding-ada-002'::character varying"))
    else:
        with op.batch_alter_table('embeddings', schema=None) as batch_op:
            batch_op.alter_column('model_name',
                   existing_type=sa.String(length=255),
                   type_=sa.VARCHAR(length=40),
                   existing_nullable=False,
                   existing_server_default=sa.text("'text-embedding-ada-002'"))

    with op.batch_alter_table('dataset_collection_bindings', schema=None) as batch_op:
        batch_op.alter_column('model_name',
               existing_type=sa.String(length=255),
               type_=sa.VARCHAR(length=40),
               existing_nullable=False)

    # ### end Alembic commands ###
