"""add table explore banner and trial

Revision ID: f9f6d18a37f9
Revises: 9e6fa5cbcd80
Create Date: 2026-01-017 11:10:18.079355

"""
from alembic import op
import models as models
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'f9f6d18a37f9'
down_revision = '9e6fa5cbcd80'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('account_trial_app_records',
    sa.Column('id', models.types.StringUUID(), nullable=False),
    sa.Column('account_id', models.types.StringUUID(), nullable=False),
    sa.Column('app_id', models.types.StringUUID(), nullable=False),
    sa.Column('count', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
    sa.PrimaryKeyConstraint('id', name='user_trial_app_pkey'),
    sa.UniqueConstraint('account_id', 'app_id', name='unique_account_trial_app_record')
    )
    with op.batch_alter_table('account_trial_app_records', schema=None) as batch_op:
        batch_op.create_index('account_trial_app_record_account_id_idx', ['account_id'], unique=False)
        batch_op.create_index('account_trial_app_record_app_id_idx', ['app_id'], unique=False)

    op.create_table('exporle_banners',
    sa.Column('id', models.types.StringUUID(), nullable=False),
    sa.Column('content', sa.JSON(), nullable=False),
    sa.Column('link', sa.String(length=255), nullable=False),
    sa.Column('sort', sa.Integer(), nullable=False),
    sa.Column('status', sa.String(length=255), server_default=sa.text("'enabled'"), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
    sa.Column('language', sa.String(length=255), server_default=sa.text("'en-US'"), nullable=False),
    sa.PrimaryKeyConstraint('id', name='exporler_banner_pkey')
    )
    op.create_table('trial_apps',
    sa.Column('id', models.types.StringUUID(), nullable=False),
    sa.Column('app_id', models.types.StringUUID(), nullable=False),
    sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
    sa.Column('trial_limit', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('id', name='trial_app_pkey'),
    sa.UniqueConstraint('app_id', name='unique_trail_app_id')
    )
    with op.batch_alter_table('trial_apps', schema=None) as batch_op:
        batch_op.create_index('trial_app_app_id_idx', ['app_id'], unique=False)
        batch_op.create_index('trial_app_tenant_id_idx', ['tenant_id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('trial_apps', schema=None) as batch_op:
        batch_op.drop_index('trial_app_tenant_id_idx')
        batch_op.drop_index('trial_app_app_id_idx')

    op.drop_table('trial_apps')
    op.drop_table('exporle_banners')
    with op.batch_alter_table('account_trial_app_records', schema=None) as batch_op:
        batch_op.drop_index('account_trial_app_record_app_id_idx')
        batch_op.drop_index('account_trial_app_record_account_id_idx')

    op.drop_table('account_trial_app_records')
    # ### end Alembic commands ###
