# 驗證指令

對目前程式碼庫狀態執行全面驗證。

## 說明

按此確切順序執行驗證：

1. **建置檢查**
   - 執行此專案的建置指令
   - 如果失敗，報告錯誤並停止

2. **型別檢查**
   - 執行 TypeScript/型別檢查器
   - 報告所有錯誤，包含 檔案:行號

3. **Lint 檢查**
   - 執行 linter
   - 報告警告和錯誤

4. **測試套件**
   - 執行所有測試
   - 報告通過/失敗數量
   - 報告覆蓋率百分比

5. **Console.log 稽核**
   - 在原始檔案中搜尋 console.log
   - 報告位置

6. **Git 狀態**
   - 顯示未提交的變更
   - 顯示上次提交後修改的檔案

## 輸出

產生簡潔的驗證報告：

```
驗證：[通過/失敗]

建置：    [OK/失敗]
型別：    [OK/X 個錯誤]
Lint：    [OK/X 個問題]
測試：    [X/Y 通過，Z% 覆蓋率]
密鑰：    [OK/找到 X 個]
日誌：    [OK/X 個 console.logs]

準備好建立 PR：[是/否]
```

如果有任何關鍵問題，列出它們並提供修復建議。

## 參數

$ARGUMENTS 可以是：
- `quick` - 只檢查建置 + 型別
- `full` - 所有檢查（預設）
- `pre-commit` - 與提交相關的檢查
- `pre-pr` - 完整檢查加上安全性掃描
