# 编码风格

## 不可变性（关键）

始终创建新对象，绝不改变现有对象：

```
// Pseudocode
WRONG:  modify(original, field, value) → changes original in-place
CORRECT: update(original, field, value) → returns new copy with change
```

理由：不可变数据可以防止隐藏的副作用，使调试更容易，并支持安全的并发。

## 文件组织

多个小文件 > 少数大文件：

* 高内聚，低耦合
* 通常 200-400 行，最多 800 行
* 从大型模块中提取实用工具
* 按功能/领域组织，而不是按类型组织

## 错误处理

始终全面处理错误：

* 在每个层级明确处理错误
* 在面向用户的代码中提供用户友好的错误消息
* 在服务器端记录详细的错误上下文
* 绝不默默地忽略错误

## 输入验证

始终在系统边界处进行验证：

* 在处理前验证所有用户输入
* 在可用时使用基于模式的验证
* 快速失败并提供清晰的错误消息
* 绝不信任外部数据（API 响应、用户输入、文件内容）

## 代码质量检查清单

在标记工作完成之前：

* \[ ] 代码可读且命名良好
* \[ ] 函数短小（<50 行）
* \[ ] 文件专注（<800 行）
* \[ ] 没有深度嵌套（>4 层）
* \[ ] 正确的错误处理
* \[ ] 没有硬编码的值（使用常量或配置）
* \[ ] 没有突变（使用不可变模式）
