# セキュリティガイドライン

## 必須セキュリティチェック

すべてのコミット前:
- [ ] ハードコードされたシークレットなし（API キー、パスワード、トークン）
- [ ] すべてのユーザー入力が検証済み
- [ ] SQL インジェクション防止（パラメータ化クエリ）
- [ ] XSS 防止（サニタイズされた HTML）
- [ ] CSRF 保護が有効
- [ ] 認証/認可が検証済み
- [ ] すべてのエンドポイントにレート制限
- [ ] エラーメッセージが機密データを漏らさない

## シークレット管理

- ソースコードにシークレットをハードコードしない
- 常に環境変数またはシークレットマネージャーを使用
- 起動時に必要なシークレットが存在することを検証
- 露出した可能性のあるシークレットをローテーション

## セキュリティ対応プロトコル

セキュリティ問題が見つかった場合:
1. 直ちに停止
2. **security-reviewer** agent を使用
3. 継続前に CRITICAL 問題を修正
4. 露出したシークレットをローテーション
5. 同様の問題がないかコードベース全体をレビュー
