# パフォーマンス最適化

## モデル選択戦略

**Haiku 4.5**（Sonnet 機能の 90%、コスト 3 分の 1）:
- 頻繁に呼び出される軽量 agent
- ペアプログラミングとコード生成
- マルチ agent システムのワーカー agent

**Sonnet 4.5**（最高のコーディングモデル）:
- メイン開発作業
- マルチ agent ワークフローのオーケストレーション
- 複雑なコーディングタスク

**Opus 4.5**（最も深い推論）:
- 複雑なアーキテクチャの意思決定
- 最大限の推論要件
- 調査と分析タスク

## コンテキストウィンドウ管理

次の場合はコンテキストウィンドウの最後の 20% を避ける:
- 大規模なリファクタリング
- 複数ファイルにまたがる機能実装
- 複雑な相互作用のデバッグ

コンテキスト感度の低いタスク:
- 単一ファイルの編集
- 独立したユーティリティの作成
- ドキュメントの更新
- 単純なバグ修正

## 拡張思考 + プランモード

拡張思考はデフォルトで有効で、内部推論用に最大 31,999 トークンを予約します。

拡張思考の制御:
- **トグル**: Option+T（macOS）/ Alt+T（Windows/Linux）
- **設定**: `~/.claude/settings.json` で `alwaysThinkingEnabled` を設定
- **予算上限**: `export MAX_THINKING_TOKENS=10000`
- **詳細モード**: Ctrl+O で思考出力を表示

深い推論を必要とする複雑なタスクの場合:
1. 拡張思考が有効であることを確認（デフォルトで有効）
2. 構造化されたアプローチのために **プランモード** を有効化
3. 徹底的な分析のために複数の批評ラウンドを使用
4. 多様な視点のために役割分担したサブ agent を使用

## ビルドトラブルシューティング

ビルドが失敗した場合:
1. **build-error-resolver** agent を使用
2. エラーメッセージを分析
3. 段階的に修正
4. 各修正後に検証
