# 共通パターン

## スケルトンプロジェクト

新しい機能を実装する際:
1. 実戦テスト済みのスケルトンプロジェクトを検索
2. 並列 agent を使用してオプションを評価:
   - セキュリティ評価
   - 拡張性分析
   - 関連性スコアリング
   - 実装計画
3. 最適なものを基盤としてクローン
4. 実証済みの構造内で反復

## 設計パターン

### Repository パターン

一貫したインターフェースの背後にデータアクセスをカプセル化:
- 標準操作を定義: findAll, findById, create, update, delete
- 具象実装がストレージの詳細を処理（データベース、API、ファイルなど）
- ビジネスロジックはストレージメカニズムではなく、抽象インターフェースに依存
- データソースの簡単な交換を可能にし、モックによるテストを簡素化

### API レスポンスフォーマット

すべての API レスポンスに一貫したエンベロープを使用:
- 成功/ステータスインジケーターを含める
- データペイロードを含める（エラー時は null）
- エラーメッセージフィールドを含める（成功時は null）
- ページネーションされたレスポンスにメタデータを含める（total, page, limit）
