# ユーザーレベル CLAUDE.md の例

これはユーザーレベル CLAUDE.md ファイルの例です。`~/.claude/CLAUDE.md` に配置してください。

ユーザーレベルの設定はすべてのプロジェクトに全体的に適用されます。以下の用途に使用します:
- 個人のコーディング設定
- 常に適用したいユニバーサルルール
- モジュール化されたルールへのリンク

---

## コア哲学

あなたはClaude Codeです。私は複雑なタスクに特化したエージェントとスキルを使用します。

**主要原則:**
1. **エージェント優先**: 複雑な作業は専門エージェントに委譲する
2. **並列実行**: 可能な限り複数のエージェントでTaskツールを使用する
3. **計画してから実行**: 複雑な操作にはPlan Modeを使用する
4. **テスト駆動**: 実装前にテストを書く
5. **セキュリティ優先**: セキュリティに妥協しない

---

## モジュール化されたルール

詳細なガイドラインは `~/.claude/rules/` にあります:

| ルールファイル | 内容 |
|-----------|----------|
| security.md | セキュリティチェック、機密情報管理 |
| coding-style.md | 不変性、ファイル構成、エラーハンドリング |
| testing.md | TDDワークフロー、80%カバレッジ要件 |
| git-workflow.md | コミット形式、PRワークフロー |
| agents.md | エージェントオーケストレーション、どのエージェントをいつ使用するか |
| patterns.md | APIレスポンス、リポジトリパターン |
| performance.md | モデル選択、コンテキスト管理 |
| hooks.md | フックシステム |

---

## 利用可能なエージェント

`~/.claude/agents/` に配置:

| エージェント | 目的 |
|-------|---------|
| planner | 機能実装の計画 |
| architect | システム設計とアーキテクチャ |
| tdd-guide | テスト駆動開発 |
| code-reviewer | 品質/セキュリティのコードレビュー |
| security-reviewer | セキュリティ脆弱性分析 |
| build-error-resolver | ビルドエラーの解決 |
| e2e-runner | Playwright E2Eテスト |
| refactor-cleaner | デッドコードのクリーンアップ |
| doc-updater | ドキュメントの更新 |

---

## 個人設定

### プライバシー
- 常にログを編集する; 機密情報(APIキー/トークン/パスワード/JWT)を貼り付けない
- 共有前に出力をレビューする - すべての機密データを削除

### コードスタイル
- コード、コメント、ドキュメントに絵文字を使用しない
- 不変性を優先 - オブジェクトや配列を決して変更しない
- 少数の大きなファイルよりも多数の小さなファイル
- 通常200-400行、ファイルごとに最大800行

### Git
- Conventional Commits: `feat:`, `fix:`, `refactor:`, `docs:`, `test:`
- コミット前に常にローカルでテスト
- 小さく焦点を絞ったコミット

### テスト
- TDD: 最初にテストを書く
- 最低80%のカバレッジ
- 重要なフローにはユニット + 統合 + E2Eテスト

---

## エディタ統合

主要エディタとしてZedを使用:
- ファイル追跡用のエージェントパネル
- コマンドパレット用のCMD+Shift+R
- Vimモード有効化

---

## 成功指標

以下の場合に成功です:
- すべてのテストが合格 (80%以上のカバレッジ)
- セキュリティ脆弱性なし
- コードが読みやすく保守可能
- ユーザー要件を満たしている

---

**哲学**: エージェント優先設計、並列実行、行動前に計画、コード前にテスト、常にセキュリティ。
