# /learn - 再利用可能なパターンの抽出

現在のセッションを分析し、スキルとして保存する価値のあるパターンを抽出します。

## トリガー

非自明な問題を解決したときに、セッション中の任意の時点で `/learn` を実行します。

## 抽出する内容

以下を探します:

1. **エラー解決パターン**
   - どのようなエラーが発生したか
   - 根本原因は何か
   - 何が修正したか
   - 類似のエラーに対して再利用可能か

2. **デバッグ技術**
   - 自明ではないデバッグ手順
   - うまく機能したツールの組み合わせ
   - 診断パターン

3. **回避策**
   - ライブラリの癖
   - APIの制限
   - バージョン固有の修正

4. **プロジェクト固有のパターン**
   - 発見されたコードベースの規約
   - 行われたアーキテクチャの決定
   - 統合パターン

## 出力形式

`~/.claude/skills/learned/[パターン名].md` にスキルファイルを作成します:

```markdown
# [説明的なパターン名]

**抽出日:** [日付]
**コンテキスト:** [いつ適用されるかの簡単な説明]

## 問題
[解決する問題 - 具体的に]

## 解決策
[パターン/技術/回避策]

## 例
[該当する場合、コード例]

## 使用タイミング
[トリガー条件 - このスキルを有効にすべき状況]
```

## プロセス

1. セッションで抽出可能なパターンをレビュー
2. 最も価値がある/再利用可能な洞察を特定
3. スキルファイルを下書き
4. 保存前にユーザーに確認を求める
5. `~/.claude/skills/learned/` に保存

## 注意事項

- 些細な修正（タイプミス、単純な構文エラー）は抽出しない
- 一度限りの問題（特定のAPIの障害など）は抽出しない
- 将来のセッションで時間を節約できるパターンに焦点を当てる
- スキルは集中させる - 1つのスキルに1つのパターン
