# Evalコマンド

評価駆動開発ワークフローを管理します。

## 使用方法

`/eval [define|check|report|list] [機能名]`

## Evalの定義

`/eval define 機能名`

新しい評価定義を作成します。

1. テンプレートを使用して `.claude/evals/機能名.md` を作成:

```markdown
## EVAL: 機能名
作成日: $(date)

### 機能評価
- [ ] [機能1の説明]
- [ ] [機能2の説明]

### 回帰評価
- [ ] [既存の動作1が正常に動作する]
- [ ] [既存の動作2が正常に動作する]

### 成功基準
- 機能評価: pass@3 > 90%
- 回帰評価: pass^3 = 100%
```

2. ユーザーに具体的な基準を記入するよう促す

## Evalのチェック

`/eval check 機能名`

機能の評価を実行します。

1. `.claude/evals/機能名.md` から評価定義を読み込む
2. 各機能評価について:
   - 基準の検証を試行
   - PASS/FAILを記録
   - `.claude/evals/機能名.log` に試行を記録
3. 各回帰評価について:
   - 関連するテストを実行
   - ベースラインと比較
   - PASS/FAILを記録
4. 現在のステータスを報告:

```
EVAL CHECK: 機能名
========================
機能評価: X/Y 合格
回帰評価: X/Y 合格
ステータス: 進行中 / 準備完了
```

## Evalの報告

`/eval report 機能名`

包括的な評価レポートを生成します。

```
EVAL REPORT: 機能名
=========================
生成日時: $(date)

機能評価
----------------
[eval-1]: PASS (pass@1)
[eval-2]: PASS (pass@2) - 再試行が必要でした
[eval-3]: FAIL - 備考を参照

回帰評価
----------------
[test-1]: PASS
[test-2]: PASS
[test-3]: PASS

メトリクス
-------
機能評価 pass@1: 67%
機能評価 pass@3: 100%
回帰評価 pass^3: 100%

備考
-----
[問題、エッジケース、または観察事項]

推奨事項
--------------
[リリース可 / 要修正 / ブロック中]
```

## Evalのリスト表示

`/eval list`

すべての評価定義を表示します。

```
EVAL 定義一覧
================
feature-auth      [3/5 合格] 進行中
feature-search    [5/5 合格] 準備完了
feature-export    [0/4 合格] 未着手
```

## 引数

$ARGUMENTS:
- `define <名前>` - 新しい評価定義を作成
- `check <名前>` - 評価を実行してチェック
- `report <名前>` - 完全なレポートを生成
- `list` - すべての評価を表示
- `clean` - 古い評価ログを削除（最新10件を保持）
