# コードレビュー

未コミットの変更を包括的にセキュリティと品質に対してレビューします：

1. 変更されたファイルを取得：`git diff --name-only HEAD`

2. 変更された各ファイルについて、チェック：

**セキュリティ問題（重大）：**

* ハードコードされた認証情報、API キー、トークン
* SQL インジェクション脆弱性
* XSS 脆弱性
* 入力検証の不足
* 不安全な依存関係
* パストラバーサルリスク

**コード品質（高）：**

* 関数の長さが 50 行以上
* ファイルの長さが 800 行以上
* ネストの深さが 4 層以上
* エラーハンドリングの不足
* `console.log` ステートメント
* `TODO`/`FIXME` コメント
* 公開 API に JSDoc がない

**ベストプラクティス（中）：**

* 可変パターン（イミュータブルパターンを使用しますすべき）
* コード/コメント内の絵文字使用します
* 新しいコードのテスト不足
* アクセシビリティ問題（a11y）

3. 以下を含むレポートを生成：
   * 重大度：重大、高、中、低
   * ファイル位置と行番号
   * 問題の説明
   * 推奨される修正方法

4. 重大または高優先度の問題が見つかった場合、コミットをブロック

セキュリティ脆弱性を含むコードは絶対に許可しないこと！
